#
# Functions to find the UPS parametrs
#
DATABASE mwc

GLOBALS	 "globals0.4gl"

#
# Find product weight
# 
FUNCTION ups_weight()
	SELECT product.weight
		INTO p_product.weight
		FROM product
		WHERE prod_no = p_line.prod_no

	IF status = NOTFOUND THEN
		CALL msgs("Product not found !!!")
	END IF

	IF p_line.quantity != 0 AND p_line.quantity IS NOT NULL THEN
		LET p_product.weight = p_product.weight * p_line.quantity
	END IF
END FUNCTION

#
# Find UPS price
#
FUNCTION ups_price(commercial)

DEFINE commercial SMALLINT

	SELECT w_z_p.price
		INTO p_wzp.price 
		FROM w_z_p
		WHERE weight = p_wzp.weight AND zone = p_wzp.zone
			AND commer = commercial

	IF status = NOTFOUND THEN
		LET p_wzp.price = 0
	END IF

END FUNCTION

#
# Find UPS zone number. Can find zone number only for the USA, Puerto Rico
# and Hawaii. You can expect surprise from Alaska Rural but lets hope that
# Polar Bear does not use COHERENT.
#
FUNCTION ups_zone()

	DEFINE zip_code	SMALLINT,
		tmp	CHAR(3)

	LET p_wzp.zone = 0

	IF s_address.country IS NOT NULL THEN
		RETURN
	END IF

	CASE
	WHEN p_invoice.ship_no = 1 OR p_invoice.ship_no = 12	# UPS ground
		LET tmp = s_address.zipcode	# tmp cut zipcode to 3 digits
		LET zip_code = tmp

		SELECT ground.zone
			INTO p_wzp.zone
			FROM ground
			WHERE from_zip <= zip_code AND
			      to_zip >= zip_code

		IF status = NOTFOUND THEN
			SELECT ground.zone
				INTO p_wzp.zone
				FROM ground
				WHERE from_zip = zip_code
		END IF


	WHEN p_invoice.ship_no = 2		# UPS blue
		SELECT states.blue_zone
			INTO p_wzp.zone
			FROM states
			WHERE state = s_address.state

	WHEN p_invoice.ship_no = 3		# UPS red
		SELECT states.red_zone
			INTO p_wzp.zone
			FROM states
			WHERE state = s_address.state

	END CASE

	IF status = NOTFOUND THEN
		LET p_wzp.zone = 0
	END IF

END FUNCTION

#
# Delete all rows that was closed before and
# install "close" sign on the rest rows
#
FUNCTION ups_close()
	DEFINE cur_date	DATE,
	       number	INTEGER

	CALL yn("Do you want to close report <y/n>?")
		RETURNING answer

	IF answer = "n" THEN 
		RETURN
	END IF

	SELECT MAX(cl_date) INTO cur_date FROM pickup_line
		
	IF cur_date >= TODAY THEN
		CALL yn("Report HAD BEEN closed ! Close it <y/n> ? ")
			RETURNING answer
		IF answer = "n" THEN
			RETURN	
		END IF
	END IF

	DELETE FROM pickup_line
		WHERE closed = "x"

	UPDATE pickup_line
		SET closed = "x", cl_date = TODAY

	# Update dates in main table for UPS customers
	DECLARE cl_qurs CURSOR FOR
	SELECT * FROM pickup_line
			
	FOREACH cl_qurs INTO p_pickup.*
		UPDATE invoice
		SET ship_date = TODAY
		WHERE invoice_no = p_pickup.invoice_no
	END FOREACH

	CLOSE cl_qurs

	CALL msgs("Report closed")
END FUNCTION
