#
# To do job with pickup_line table
#

GLOBALS "globals0.4gl"

#
# To do correct and check UPS report table pickup_line
#
FUNCTION ups_correct()

	MENU ""

	COMMAND "Find" "Find UPS entry"
		CALL ups_find()
		IF chosen THEN
			NEXT OPTION "Modify"
		END IF

	COMMAND "Modify" "Modify UPS entry"
		IF chosen THEN
			CALL ups_modify()
		ELSE
			NEXT OPTION "Find"
		END IF

	COMMAND "Delete" "Delete row"
		IF chosen THEN
			CALL ups_delete()
		ELSE
			NEXT OPTION "Find"
		END IF

	COMMAND "Exit" "Exit from UPS report table"
		EXIT MENU
	END MENU
END FUNCTION

#
# Display information from table
# 
FUNCTION ups_displ()
	DISPLAY	p_line.invoice_no,	p_cust.contact, 
		s_address.line1,	s_address.city, 
		s_address.state, 	s_address.country, 
		s_address.zipcode,	p_wzp.weight, 
		p_wzp.zone,		p_wzp.price,	p_wzp.commer,
		p_pickup.cod_amt,	p_pickup.cod_chrg 
	TO
		pickup_line.invoice_no,	pickup_line.contact, 
		pickup_line.address,	pickup_line.city, 
		pickup_line.state, 	pickup_line.country, 
		pickup_line.zipcode,	pickup_line.weight, 
		pickup_line.zone,	pickup_line.charge, pickup_line.commer,
		pickup_line.cod_amt,	pickup_line.cod_chrg
END FUNCTION

#
# Find row in pickup_line table
#
FUNCTION ups_find()
	DEFINE tmp_invoice INTEGER

	CLEAR FORM

	CALL msgs("")

	CONSTRUCT query1 ON invoice_no, contact, address, city, state,
	   country, zipcode
	   FROM invoice_no, contact, address, city, state, country, zipcode

	LET s1 = "SELECT * FROM pickup_line WHERE ", 
		"closed = \"o\" AND ", query1 CLIPPED

	PREPARE s_w FROM s1

	DECLARE pick_curs CURSOR FOR s_w

	FOREACH pick_curs INTO p_pickup.*

		MESSAGE ""

		DISPLAY BY NAME p_pickup.invoice_no THRU p_pickup.cll

		IF p_pickup.cll = "x" THEN

			SELECT * INTO p_call.* FROM call_tag
			   WHERE invoice_no = p_pickup.invoice_no

			IF p_call.invoice_no = p_pickup.invoice_no THEN
				DISPLAY BY NAME p_call.tag_no, 
				   p_call.why, p_call.action, 
				   p_call.issue_date, p_call.rec_date
			ELSE
				MESSAGE "Tag wasn't found ", p_call.invoice_no
			END IF
		END IF

		CALL yn("Select this row <y/n>? ") RETURNING answer

		IF answer = "y" THEN
			LET chosen = 1	
			CLOSE pick_curs
			RETURN		
		END IF

		CLEAR FORM
	END FOREACH

	CLOSE pick_curs

	CLEAR FORM
	MESSAGE "There are no more entries"
	LET chosen = 0
END FUNCTION

#
# Modify row in pickup_line table that was found
#
FUNCTION ups_modify()
	DEFINE tag_state, cmr	SMALLINT

	IF p_pickup.cll = "x" THEN
		LET tag_state = 1
	ELSE
		LET tag_state = 0
	END IF

	DELETE FROM pickup_line
		WHERE invoice_no = p_pickup.invoice_no AND 
		      charge = p_pickup.charge AND
		      closed = "o"

	INPUT BY NAME p_pickup.invoice_no THRU p_pickup.cll
		WITHOUT DEFAULTS

	AFTER FIELD state
		IF p_pickup.state IS NOT NULL THEN 
			NEXT FIELD zipcode
		END IF

	AFTER FIELD dec_value
		IF p_pickup.dec_value IS NOT NULL AND 
					p_pickup.dec_value < 100.01 THEN 
		       	CALL msgs
			("Declare value should be > $100 or notihing ")
			NEXT FIELD dec_value
		END IF

	AFTER FIELD aod
		IF p_pickup.aod IS NOT NULL AND p_pickup.aod <> "x" THEN
			CALL msgs("aod can be 'x' or nothing") 
			NEXT FIELD aod
			IF p_pickup.cll IS NULL THEN
				DELETE FROM call_tag
				   WHERE invoice_no = p_pickup.invoice_no
			END IF
		END IF

	AFTER FIELD cll
		IF p_pickup.cll IS NOT NULL AND p_pickup.cll <> "x" THEN
			CALL msgs("Call tag can be 'x' or nothing") 
			NEXT FIELD cll
		END IF
		
		IF p_pickup.cll = "x" THEN
			LET p_pickup.cod_chrg = NULL
			LET p_pickup.cod_amt = NULL

			IF p_call.invoice_no = p_pickup.invoice_no THEN
				CALL tag_modify()
			ELSE
				CALL tag_add()
			END IF
		ELSE
			IF tag_state = 1 THEN
				DELETE FROM call_tag
				   WHERE invoice_no = p_pickup.invoice_no
				   LET p_call.invoice_no = 0
			END IF
		END IF

	AFTER FIELD weight
		IF p_pickup.weight IS NULL THEN
			LET p_pickup.weight = 0
		END IF
			
		LET p_wzp.weight = p_pickup.weight
			
	AFTER FIELD zone
		LET p_wzp.zone = p_pickup.zone
		CALL ups_price(cmr)

		IF  p_wzp.price = 0 THEN
			CALL msgs("Zone number or weight wrong")
			NEXT FIELD weight
		END IF

		LET p_pickup.charge = p_wzp.price

	AFTER FIELD commer
		LET cmr = p_pickup.commer
		CALL ups_price(cmr)
		IF  p_wzp.price = 0 THEN
			CALL msgs("Zone number or weight wrong")
			NEXT FIELD weight
		END IF
		LET p_pickup.charge = p_wzp.price
	END INPUT

	DISPLAY BY NAME p_pickup.invoice_no THRU p_pickup.cll

	LET p_pickup.ship_loc = shiploc

	INSERT INTO pickup_line VALUES (p_pickup.*)

	CALL msgs("Row was modified")

	LET chosen = 0
END FUNCTION

#
# Delete row from pickup_line table
#
FUNCTION ups_delete()
	CALL yn("Are you sure <y/n>? ") RETURNING answer

	IF answer = "y" THEN
		DELETE FROM pickup_line
			WHERE invoice_no = p_pickup.invoice_no AND
			      charge = p_pickup.charge AND
			      closed = "o"
		
		IF p_pickup.closed = "o" THEN
			DELETE FROM call_tag
				WHERE invoice_no = p_pickup.invoice_no
		END IF
		
		CLEAR FORM 
		CALL msgs("Row deleted")
	ELSE
		CALL msgs("Canceled")
	END IF

	LET chosen = 0

END FUNCTION		

