#
# Code to handle the term file
#
GLOBALS "globals0.4gl"

FUNCTION term_menu()
	DISPLAY FORM term_form

	LET chosen = FALSE

	MENU "TERMS"
	COMMAND "Add" "Add a new term"
		LET answer = "y"
		WHILE answer = "y"
			CALL enter_term()

			CALL yn("Enter another row <y/n>")
				RETURNING answer
		END WHILE

	COMMAND "Query" "Search for a term"
		CALL query_term()

		IF chosen THEN
			NEXT OPTION "Modify"
		END IF

	COMMAND "Modify" "Modify a term"
		IF chosen THEN
			CALL change_term()
		ELSE
			MESSAGE "Use query first "
			NEXT OPTION "Query"
		END IF

	COMMAND "Delete" "Delete a term"
		IF chosen THEN
			CALL yn("Are you sure <y/n>") RETURNING answer

			IF answer = "y" THEN
				CALL delete_term()
				LET chosen = FALSE
			END IF
		ELSE
			MESSAGE "Use query first "
			NEXT OPTION "Query"
		END IF

	COMMAND "Exit" "Leave the term menu"
		EXIT MENU
	END MENU

	CLEAR SCREEN
END FUNCTION

#
# Report on all terms to file
#
REPORT term_list (r_term)
	DEFINE r_term RECORD LIKE terms.*

	OUTPUT
		REPORT TO "terms.lst"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0
		PAGE LENGTH 80

	FORMAT
	ON EVERY ROW
		PRINT 	r_term.term_no USING "###", " ",
			r_term.term_name
END REPORT

FUNCTION enter_term()
	MESSAGE ""
	CLEAR FORM

	INPUT BY NAME p_term.term_name
	AFTER FIELD term_name
		IF p_term.term_name IS NULL THEN
			NEXT FIELD term_name
		END IF
	END INPUT

	INSERT INTO terms VALUES (0, p_term.term_name)

	LET p_term.term_no = SQLCA.SQLERRD[2]

	DISPLAY BY NAME p_term.term_no

	MESSAGE "Row added"
END FUNCTION

FUNCTION query_term()
	DEFINE exist SMALLINT,
	       answer CHAR(1)

	CLEAR FORM
	MESSAGE ""

	CONSTRUCT query1 ON terms.* FROM terms.*

	LET s1 = "SELECT * FROM terms WHERE ", query1 CLIPPED

	PREPARE s_1 FROM s1

	DECLARE t_curs CURSOR FOR s_1

	LET exist = FALSE
	LET chosen = FALSE

	FOREACH t_curs INTO p_term.*
		LET exist = TRUE

		DISPLAY BY NAME p_term.*

		CALL yn("Enter 'y' to select this term")
			RETURNING answer

		IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH

	CLOSE t_curs

	IF exist = FALSE THEN
		MESSAGE "No term rows found"
	ELSE
		IF chosen = FALSE THEN
			MESSAGE "No more rows"
		END IF
	END IF
END FUNCTION

FUNCTION change_term()
	INPUT BY NAME p_term.term_name WITHOUT DEFAULTS

	UPDATE terms SET terms.* = p_term.* 
	 WHERE term_no = p_term.term_no
END FUNCTION

FUNCTION delete_term()
	DELETE FROM terms WHERE term_no = p_term.term_no

	CLEAR FORM
END FUNCTION
