#
# Registration card entry system
#
DATABASE mwc

GLOBALS "globals0.4gl"

FUNCTION reg_base()
	DISPLAY FORM reg_form

	LET chosen = FALSE

	MENU "REGCARD"
	COMMAND "Add" "Add a new regcard."
		LET answer = "y"
		WHILE answer = "y"
			CALL enter_reg(0)
			CALL yn("Enter another reg card :")
				RETURNING answer
		END WHILE
		LET chosen = FALSE

	COMMAND "Query" "Search for a regcard"
		CALL query_reg()

		IF chosen THEN
			NEXT OPTION "Modify"
		END IF

	COMMAND "Invoice" "Invoice query"
		OPEN FORM big_form FROM "mainline"
		DISPLAY FORM big_form
		CALL find_invoice(0)
		CLOSE FORM big_form
		DISPLAY FORM reg_form
		IF chosen = TRUE THEN
			CALL enter_reg(p_invoice.cust_no)
			LET chosen = FALSE
		ELSE
			NEXT OPTION "Add"
		END IF

	COMMAND "Modify" "Modify a regcard."
		IF chosen THEN
			CALL change_reg()
		ELSE
			MESSAGE "No regcard has been selected. "
			NEXT OPTION "Query"
		END IF

	COMMAND "Delete" "Delete a regcard"
		IF chosen THEN
			CALL yn("Are you sure you want to delete this <y/n>")
				RETURNING answer
			IF answer = "y" THEN
				CALL delete_reg()
			END IF
		ELSE
			MESSAGE "No regcard has been selected. "
			NEXT OPTION "Query"
		END IF

	COMMAND "Report" "Regcards Statistical Report"
		CALL reg_report()

	COMMAND "Exit" "Leave regcard menu"
		EXIT MENU
	END MENU

	CLEAR SCREEN
END FUNCTION

FUNCTION query_reg()
	DEFINE  exist SMALLINT,
		answer CHAR(1)

	CLEAR FORM

	CONSTRUCT query1 ON
		comp_type, ser_no, cust_no, reg_date
	FROM
		comp_type, ser_no, cust_no, reg_date

	LET s1 = "SELECT * FROM regcard WHERE ", query1 CLIPPED

	PREPARE s_1 FROM s1

	DECLARE rg_curs CURSOR FOR s_1 

	LET exist  = FALSE
	LET chosen = FALSE
	
	FOREACH rg_curs INTO p_reg.*
		LET exist = TRUE

		DISPLAY BY NAME p_reg.*

		CALL yn("Enter 'y' to select this regcard ") RETURNING answer

		IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH
	
	CLOSE rg_curs

	IF exist = FALSE THEN
		MESSAGE "No regcards found"
	ELSE
		IF chosen = FALSE THEN
			MESSAGE "No more regcards"
		END IF
	END IF
END FUNCTION

FUNCTION change_reg()
	INPUT BY NAME p_reg.cust_no THRU p_reg.education WITHOUT DEFAULTS

	UPDATE regcard SET regcard.* = p_reg.* 
	 WHERE regcard.ser_no = p_reg.ser_no
END FUNCTION

FUNCTION delete_reg()
	DELETE FROM regcard WHERE regcard.ser_no = p_reg.ser_no
END FUNCTION

FUNCTION reg_report()
	CLEAR FORM

	CONSTRUCT BY NAME query1 ON regcard.*

	LET s1 = "SELECT regcard.*",
		 "  FROM regcard",
	         " WHERE ", query1 CLIPPED

	PREPARE s_2 FROM s1

	DECLARE rr_curs CURSOR FOR s_2

	MESSAGE ""

	START REPORT reg_list

	FOREACH rr_curs INTO p_reg.*
		IF p_reg.comp_type IS NULL THEN
			LET p_reg.comp_type = "-"
		ELSE
			LET p_reg.comp_type = UPSHIFT(p_reg.comp_type)
		END IF
		OUTPUT TO REPORT reg_list(p_reg.*)
	END FOREACH

	CLOSE rr_curs

	FINISH REPORT reg_list
END FUNCTION

FUNCTION look_mag(n, ct)
	DEFINE n SMALLINT
	DEFINE ct INTEGER

	SELECT * INTO p_mag.* FROM magazines WHERE inq_src = n

	IF p_mag.cost != 0 THEN
		LET eff = (ct * 100) / p_mag.cost
	ELSE
		LET eff = NULL
	END IF
END FUNCTION

REPORT reg_list(r)
	DEFINE r RECORD LIKE regcard.*
	DEFINE ct SMALLINT
	DEFINE c ARRAY[41] OF INTEGER
	DEFINE tot INTEGER

	DEFINE i SMALLINT

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY r.comp_type

	FORMAT
	FIRST PAGE HEADER
		FOR i = 1 TO 41
			LET c[i] = 0
		END FOR

		PRINT	PAGENO USING "Page <<", 5 SPACES,
			"Regcard statistical report",
			5 SPACES, TODAY
		PRINT	query1 CLIPPED
		SKIP 2 LINES

	PAGE HEADER
		PRINT	PAGENO USING "Page <<", 5 SPACES,
			"Regcard statistical report",
			5 SPACES, TODAY
		PRINT	query1 CLIPPED
		SKIP 2 LINES

	ON EVERY ROW
		CASE
		WHEN r.ser_no >= 300000000
			LET c[41] = c[41] + 1
		WHEN r.ser_no >= 200000000
			LET c[40] = c[40] + 1
		OTHERWISE
			LET c[39] = c[39] + 1
		END CASE

		SELECT COUNT(*)
		  INTO ct
		  FROM invoice
		 WHERE cust_no = r.cust_no

		IF ct == 0 THEN
			LET c[37] = c[37] + 1
		ELSE
			LET c[38] = c[38] + 1
		END IF

		IF r.byte_m = "x" THEN
			LET c[1] = c[1] + 1
		END IF
		IF r.c_gazette = "x" THEN
			LET c[2] = c[2] + 1
		END IF
		IF r.cug = "x" THEN
			LET c[3] = c[3] + 1
		END IF
		IF r.circ_cel = "x" THEN
			LET c[4] = c[4] + 1
		END IF
		IF r.comm_acm = "x" THEN
			LET c[5] = c[5] + 1
		END IF
		IF r.comp_shop = "x" THEN
			LET c[6] = c[6] + 1
		END IF
		IF r.comp_lang = "x" THEN
			LET c[7] = c[7] + 1
		END IF
		IF r.comp_world = "x" THEN
			LET c[8] = c[8] + 1
		END IF
		IF r.dr_dobbs = "x" THEN
			LET c[9] = c[9] + 1
		END IF
		IF r.unix_rev = "x" THEN
			LET c[10] = c[10] + 1
		END IF
		IF r.unix_today = "x" THEN
			LET c[11] = c[11] + 1
		END IF
		IF r.unix_world = "x" THEN
			LET c[12] = c[12] + 1
		END IF
		IF r.ee_times = "x" THEN
			LET c[13] = c[13] + 1
		END IF
		IF r.embed_sys = "x" THEN
			LET c[14] = c[14] + 1
		END IF
		IF r.ieee_spec = "x" THEN
			LET c[15] = c[15] + 1
		END IF
		IF r.info_world = "x" THEN
			LET c[16] = c[16] + 1
		END IF
		IF r.pc_comp = "x" THEN
			LET c[17] = c[17] + 1
		END IF
		IF r.personal_comp = "x" THEN
			LET c[18] = c[18] + 1
		END IF
		IF r.personal_wk = "x" THEN
			LET c[19] = c[19] + 1
		END IF
		IF r.prog_journal = "x" THEN
			LET c[20] = c[20] + 1
		END IF
		IF r.sys_integrat = "x" THEN
			LET c[21] = c[21] + 1
		END IF
		IF r.pc_mag = "x" THEN
			LET c[22] = c[22] + 1
		END IF
		IF r.pc_week = "x" THEN
			LET c[23] = c[23] + 1
		END IF
		IF r.pc_world = "x" THEN
			LET c[24] = c[24] + 1
		END IF

		IF r.personal_use = "x" THEN
			LET c[25] = c[25] + 1
		END IF
		IF r.business_use = "x" THEN
			LET c[26] = c[26] + 1
		END IF
		IF r.education = "x" THEN
			LET c[27] = c[27] + 1
		END IF

		CASE
		WHEN r.exp_level = "b"
			LET c[28] = c[28] + 1
		WHEN r.exp_level = "i"
			LET c[29] = C[29] + 1
		WHEN r.exp_level = "p"
			LET c[30] = c[30] + 1
		WHEN r.exp_level = "n"
			LET c[31] = c[31] + 1
		END CASE

		LET c[32] = c[32] + 1

		LET tot = tot + 1	# subtotal for comp type 

	AFTER GROUP OF r.comp_type
		CASE
		WHEN r.comp_type MATCHES "*286*"
			LET c[33] = c[33] + tot
		WHEN r.comp_type MATCHES "*386*"
			LET c[34] = c[34] + tot
		WHEN r.comp_type MATCHES "*486*"
			LET c[35] = c[35] + tot
		OTHERWISE
			IF r.comp_type = "-" THEN
				LET r.comp_type = NULL
			END IF 
			LET c[36] = c[36] + tot
			PRINT tot, " ", r.comp_type
		END CASE

	BEFORE GROUP OF r.comp_type
		LET tot = 0

	ON LAST ROW
		SKIP TO TOP OF PAGE
		PRINT 	c[33], " 286 Users"
		PRINT	c[34], " 386 Users"
		PRINT	c[35], " 486 Users"
		PRINT	c[36], " Not identified"
		SKIP 2 LINES

		CALL look_mag(1,  c[1])
		PRINT	c[1], " ", p_mag.mag_name, eff	
		CALL look_mag(17, c[2])
		PRINT	c[2], " ", p_mag.mag_name, eff	
		CALL look_mag(15, c[3])
		PRINT	c[3], " ", p_mag.mag_name, eff	
		CALL look_mag(16, c[4])
		PRINT	c[4], " ", p_mag.mag_name, eff	
		CALL look_mag(19, c[5])
		PRINT	c[5], " ", p_mag.mag_name, eff	
		CALL look_mag(14, c[6])
		PRINT	c[6], " ", p_mag.mag_name, eff	
		CALL look_mag(4,  c[7])
		PRINT	c[7], " ", p_mag.mag_name, eff	
		CALL look_mag(36, c[8])
		PRINT	c[8], " ", p_mag.mag_name, eff	
		CALL look_mag(2,  c[9])
		PRINT	c[9], " ", p_mag.mag_name, eff	
		CALL look_mag(21, c[10])
		PRINT	c[10], " ", p_mag.mag_name, eff	
		CALL look_mag(5,  c[11])
		PRINT	c[11], " ", p_mag.mag_name, eff	
		CALL look_mag(13, c[12])
		PRINT	c[12], " ", p_mag.mag_name, eff	
		CALL look_mag(30, c[13])
		PRINT	c[13], " ", p_mag.mag_name, eff	
		CALL look_mag(37, c[14])
		PRINT	c[14], " ", p_mag.mag_name, eff	
		CALL look_mag(38, c[15])
		PRINT	c[15], " ", p_mag.mag_name, eff	
		CALL look_mag(3,  c[16])
		PRINT	 c[16], " ", p_mag.mag_name, eff	
		CALL look_mag(39, c[17])
		PRINT	c[17], " ", p_mag.mag_name, eff	
		CALL look_mag(42, c[18])
		PRINT	c[18], " ", p_mag.mag_name, eff	
		CALL look_mag(43, c[19])
		PRINT	c[19], " ", p_mag.mag_name, eff	
		CALL look_mag(10, c[20])
		PRINT	c[20], " ", p_mag.mag_name, eff	
		CALL look_mag(40, c[21])
		PRINT	c[21], " ", p_mag.mag_name, eff	
		CALL look_mag(9,  c[22])
		PRINT	 c[22], " ", p_mag.mag_name, eff
		CALL look_mag(24, c[23])
		PRINT	c[23], " ", p_mag.mag_name, eff	
		CALL look_mag(41, c[24])
		PRINT	c[24], " ", p_mag.mag_name, eff	
		SKIP 1 LINE
		PRINT	"Efficiency = count * 100 / monthly_cost"
		SKIP 1 LINE
		PRINT c[25], "  personal use"
		PRINT c[26], "  business use"
		PRINT c[27], "  education"
		SKIP 1 LINE
		PRINT c[28], "  beginner"
		PRINT c[29], "  intermediate"
		PRINT c[30], "  professional"
		PRINT c[31], "  new to unix"
		SKIP 1 LINE
		PRINT c[32], "  Regcards sampled"
		PRINT c[37], "   Have no invoice"
		PRINT c[38], "   Have an invoice"
		PRINT c[39], "   Have a 3.0 serial no"
		PRINT c[40], "   Have a 3.1 serial no" 
		PRINT c[41], "   Have a 3.2 serial no" 
END REPORT

#
# Enter a reg card
# This function gets used so many ways I ended up with
# 
FUNCTION enter_reg(cu_no)
	DEFINE cu_no INTEGER
	DEFINE ret_status, ctr SMALLINT
	DEFINE u_str, l_str CHAR(38)
	CLEAR FORM

	LET p_reg.cust_no = NULL
	LET p_shipreg.cust_no = NULL

	INPUT BY NAME 	p_reg.ser_no
	AFTER FIELD ser_no
		MESSAGE " "
		IF p_reg.ser_no IS NULL THEN
			MESSAGE "No serial number"
			NEXT FIELD ser_no
		END IF
		CALL ch_num(p_reg.ser_no) RETURNING ret_status
		IF ret_status <> 0 THEN
			MESSAGE "Invalid serial number"

			NEXT FIELD ser_no
		END IF

		SELECT COUNT(*) INTO ctr FROM regcard
		 WHERE regcard.ser_no = p_reg.ser_no

		IF ctr <> 0 THEN
			MESSAGE "Serial Number already entered"
			RETURN
		END IF

		SELECT * INTO p_shipreg.* FROM shipreg
		 WHERE ser_no = p_reg.ser_no
		LET p_reg.cust_no = p_shipreg.cust_no
	END INPUT

	IF cu_no <> 0 THEN
		LET p_reg.cust_no = cu_no
	END IF

LABEL retry:
	IF p_reg.cust_no IS NULL THEN
		INPUT BY NAME p_cust.contact, p_reg.cust_no
	END IF

	IF p_reg.cust_no IS NOT NULL THEN
		LET p_cust.contact = NULL
		SELECT * INTO p_cust.* FROM customer
		 WHERE cust_no = p_reg.cust_no
		IF p_cust.contact IS NULL THEN
			MESSAGE "Customer not found"
			LET p_reg.cust_no = NULL
			GOTO retry
		END IF

		SELECT * INTO s_address.* FROM address
		 WHERE address.cust_no = p_cust.cust_no
		   AND address.add_type <> "b"

		DISPLAY BY NAME	p_cust.contact,
				p_cust.cust_no,
				s_address.line1,
				s_address.line2,
				s_address.city,
				s_address.state,
				s_address.country,
				s_address.zipcode

		CALL yn("Use this customer ") RETURNING answer
		IF answer = "y" THEN
			LET chosen = TRUE
			GOTO looked_up
		ELSE
			LET chosen = FALSE
			GOTO grab_data
		END IF
	END IF

	CALL cruncher(p_cust.contact) RETURNING u_str

	DECLARE t_curs CURSOR FOR
	 SELECT * FROM customer
	  WHERE crunch MATCHES u_str

	LET chosen = FALSE
	FOREACH t_curs INTO p_cust.*
		SELECT * INTO s_address.* FROM address
		 WHERE address.cust_no = p_cust.cust_no
		   AND address.add_type <> "b"

		DISPLAY BY NAME	p_cust.contact,
				p_cust.cust_no,
				s_address.line1,
				s_address.line2,
				s_address.city,
				s_address.state,
				s_address.country,
				s_address.zipcode

		CALL yn("Enter 'y' To select this invoice:")
			RETURNING answer

		IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH

LABEL looked_up:
	IF chosen = TRUE THEN
		LET p_reg.cust_no = p_cust.cust_no
	ELSE
		CALL yn("No Customer found. Proceed <y/n>") RETURNING answer
		IF answer <> "y" THEN
			RETURN
		END IF
	END IF

LABEL grab_data:
	INPUT BY NAME	p_reg.comp_type,
			p_reg.disk_size,
			p_reg.byte_m,
			p_reg.c_gazette,
			p_reg.cug,
			p_reg.circ_cel,
			p_reg.comm_acm,
			p_reg.comp_shop,
			p_reg.comp_lang,
			p_reg.comp_world,
			p_reg.dr_dobbs,
			p_reg.unix_rev,
			p_reg.unix_today,
			p_reg.unix_world,
			p_reg.ee_times,
			p_reg.embed_sys,
			p_reg.ieee_spec,
			p_reg.info_world,
			p_reg.pc_comp,
			p_reg.personal_comp,
			p_reg.personal_wk,
			p_reg.prog_journal,
			p_reg.sys_integrat,
			p_reg.pc_mag,
			p_reg.pc_week,
			p_reg.pc_world

	# split to make esc convienient
	INPUT BY NAME	p_reg.exp_level,
			p_reg.personal_use,
			p_reg.business_use,
			p_reg.education

	IF chosen = FALSE THEN
		DISPLAY FORM mail_form
		CALL enter_mail(1)
		LET p_reg.cust_no = p_cust.cust_no
		DISPLAY FORM reg_form
		LET p_reg.reg_date = TODAY
		DISPLAY BY NAME p_reg.*,
				p_cust.contact,
				s_address.line1,
				s_address.line2,
				s_address.city,
				s_address.state,
				s_address.country,
				s_address.zipcode

		IF p_shipreg.cust_no IS NOT NULL THEN
			LET p_shipreg.cust_no = NULL
			DELETE FROM shipreg WHERE ser_no = p_reg.ser_no
		END IF
	ELSE
		SELECT MIN(invoice.invoice_date)
		  INTO p_reg.reg_date
		  FROM invoice
		 WHERE invoice.cust_no = p_reg.cust_no
		IF status = NOTFOUND THEN
			LET p_reg.reg_date = TODAY
		END IF
	END IF

	INSERT INTO regcard VALUES (p_reg.*)

	IF p_shipreg.cust_no IS NULL THEN
		INSERT INTO shipreg VALUES (
			p_reg.cust_no,
			p_reg.ser_no,
			NULL
		)
	END IF
END FUNCTION
