#
# New Registration card entry system
#
DATABASE mwc

GLOBALS "globals0.4gl"

FUNCTION nreg_base()
	DISPLAY FORM reg_form

	LET chosen = FALSE

	MENU "REGCARD"
	COMMAND "Add" "Add a new regcard."
		LET answer = "y"
		WHILE answer = "y"
			CALL enter_nreg(0)
			CALL yn("Enter another reg card :")
				RETURNING answer
		END WHILE
		LET chosen = FALSE

	COMMAND "Query" "Search for a regcard"
		CALL query_nreg()

		IF chosen THEN
			NEXT OPTION "Modify"
		END IF

	COMMAND "Invoice" "Invoice query"
		OPEN FORM big_form FROM "mainline"
		DISPLAY FORM big_form
		CALL find_invoice(0)
		CLOSE FORM big_form
		DISPLAY FORM reg_form
		IF chosen = TRUE THEN
			CALL enter_nreg(p_invoice.cust_no)
			LET chosen = FALSE
		ELSE
			NEXT OPTION "Add"
		END IF

	COMMAND "Modify" "Modify a regcard."
		IF chosen THEN
			CALL change_nreg()
		ELSE
			MESSAGE "No regcard has been selected. "
			NEXT OPTION "Query"
		END IF

	COMMAND "Delete" "Delete a regcard"
		IF chosen THEN
			CALL yn("Are you sure you want to delete this <y/n>")
				RETURNING answer
			IF answer = "y" THEN
				CALL delete_nreg()
			END IF
		ELSE
			MESSAGE "No regcard has been selected. "
			NEXT OPTION "Query"
		END IF

	COMMAND "Report" "Regcards Statistical Report"
		CALL nreg_report()

	COMMAND "Exit" "Leave regcard menu"
		EXIT MENU
	END MENU

	CLEAR SCREEN
END FUNCTION

FUNCTION query_nreg()
	DEFINE  exist SMALLINT,
		answer CHAR(1)

	CLEAR FORM

	CONSTRUCT query1 ON
		comp_type, ser_no, cust_no, reg_date
	FROM
		comp_type, ser_no, cust_no, reg_date

	LET s1 = "SELECT * FROM newreg WHERE ", query1 CLIPPED

	PREPARE s_1 FROM s1

	DECLARE rg_curs CURSOR FOR s_1 

	LET exist  = FALSE
	LET chosen = FALSE
	
	FOREACH rg_curs INTO p_nreg.*
		LET exist = TRUE

		DISPLAY BY NAME p_nreg.*

		CALL yn("Enter 'y' to select this regcard ") RETURNING answer

		IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH
	
	CLOSE rg_curs

	IF exist = FALSE THEN
		MESSAGE "No regcards found"
	ELSE
		IF chosen = FALSE THEN
			MESSAGE "No more regcards"
		END IF
	END IF
END FUNCTION

FUNCTION change_nreg()
	INPUT BY NAME p_nreg.cust_no THRU p_nreg.other_os WITHOUT DEFAULTS

	UPDATE newreg SET newreg.* = p_nreg.* 
	 WHERE newreg.ser_no = p_nreg.ser_no
END FUNCTION

FUNCTION delete_nreg()
	DELETE FROM newreg WHERE newreg.ser_no = p_nreg.ser_no
END FUNCTION

FUNCTION nreg_report()
	CLEAR FORM

	CONSTRUCT BY NAME query1 ON newreg.*

	LET s1 = "SELECT newreg.*",
		 "  FROM newreg",
	         " WHERE ", query1 CLIPPED

	PREPARE s_2 FROM s1

	DECLARE rr_curs CURSOR FOR s_2

	MESSAGE ""

	START REPORT nreg_list

	FOREACH rr_curs INTO p_nreg.*
		IF p_nreg.comp_type IS NULL THEN
			LET p_nreg.comp_type = "-"
		ELSE
			LET p_nreg.comp_type = UPSHIFT(p_nreg.comp_type)
		END IF
		OUTPUT TO REPORT nreg_list(p_nreg.*)
	END FOREACH

	CLOSE rr_curs

	FINISH REPORT nreg_list
END FUNCTION

REPORT nreg_list(r)
	DEFINE r RECORD LIKE newreg.*
	DEFINE ct SMALLINT
	DEFINE c ARRAY[41] OF INTEGER
	DEFINE exp ARRAY[6] OF INTEGER
	DEFINE tot INTEGER

	DEFINE i SMALLINT

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY r.comp_type

	FORMAT
	FIRST PAGE HEADER
		FOR i = 1 TO 41
			LET c[i] = 0
		END FOR

		PRINT	PAGENO USING "Page <<", 5 SPACES,
			"Regcard statistical report",
			5 SPACES, TODAY
		PRINT	query1 CLIPPED
		SKIP 2 LINES

	PAGE HEADER
		PRINT	PAGENO USING "Page <<", 5 SPACES,
			"Regcard statistical report",
			5 SPACES, TODAY
		PRINT	query1 CLIPPED
		SKIP 2 LINES

	ON EVERY ROW
		IF r.software_exp IS NOT NULL AND
		   r.software_exp > 0 AND
		   r.software_exp < 7 THEN
			LET i = r.software_exp
			LET exp[i] = exp[i] + 1
		END IF

		CASE
		WHEN r.ser_no >= 300000000
			LET c[41] = c[41] + 1
		WHEN r.ser_no >= 200000000
			LET c[40] = c[40] + 1
		OTHERWISE
			LET c[39] = c[39] + 1
		END CASE

		SELECT COUNT(*)
		  INTO ct
		  FROM invoice
		 WHERE cust_no = r.cust_no

		IF ct == 0 THEN
			LET c[37] = c[37] + 1
		ELSE
			LET c[38] = c[38] + 1
		END IF

		IF r.develop = "x" THEN
			LET c[1] = c[1] + 1
		END IF
		IF r.learn = "x" THEN
			LET c[2] = c[2] + 1
		END IF
		IF r.other = "x" THEN
			LET c[3] = c[3] + 1
		END IF
		IF r.communication = "x" THEN
			LET c[4] = c[4] + 1
		END IF
		IF r.business = "x" THEN
			LET c[5] = c[5] + 1
		END IF
		IF r.c_comp = "x" THEN
			LET c[6] = c[6] + 1
		END IF
		IF r.turbo_c = "x" THEN
			LET c[7] = c[7] + 1
		END IF
		IF r.microsoft_c = "x" THEN
			LET c[8] = c[8] + 1
		END IF
		IF r.other_c = "x" THEN
			LET c[9] = c[9] + 1
		END IF
		IF r.macintosh = "x" THEN
			LET c[10] = c[10] + 1
		END IF
		IF r.windows = "x" THEN
			LET c[11] = c[11] + 1
		END IF
		IF r.workstations = "x" THEN
			LET c[12] = c[12] + 1
		END IF
		IF r.sun = "x" THEN
			LET c[13] = c[13] + 1
		END IF
		IF r.ibm = "x" THEN
			LET c[14] = c[14] + 1
		END IF
		IF r.dec_sys = "x" THEN
			LET c[15] = c[15] + 1
		END IF
		IF r.hewlett_packard = "x" THEN
			LET c[16] = c[16] + 1
		END IF
		IF r.operating_sys = "x" THEN
			LET c[17] = c[17] + 1
		END IF
		IF r.unix_v = "x" THEN
			LET c[18] = c[18] + 1
		END IF
		IF r.ultrix = "x" THEN
			LET c[19] = c[19] + 1
		END IF
		IF r.xenix = "x" THEN
			LET c[20] = c[20] + 1
		END IF
		IF r.aix = "x" THEN
			LET c[21] = c[21] + 1
		END IF
		IF r.sunos = "x" THEN
			LET c[22] = c[22] + 1
		END IF
		IF r.hpux = "x" THEN
			LET c[23] = c[23] + 1
		END IF
		IF r.esix = "x" THEN
			LET c[24] = c[24] + 1
		END IF

		IF r.personal_use = "x" THEN
			LET c[25] = c[25] + 1
		END IF
		IF r.business_use = "x" THEN
			LET c[26] = c[26] + 1
		END IF
		IF r.education = "x" THEN
			LET c[27] = c[27] + 1
		END IF

		CASE
		WHEN r.exp_level = "b"
			LET c[28] = c[28] + 1
		WHEN r.exp_level = "i"
			LET c[29] = C[29] + 1
		WHEN r.exp_level = "p"
			LET c[30] = c[30] + 1
		WHEN r.exp_level = "n"
			LET c[31] = c[31] + 1
		END CASE

		LET c[32] = c[32] + 1

		LET tot = tot + 1	# subtotal for comp type 

	AFTER GROUP OF r.comp_type
		CASE
		WHEN r.comp_type MATCHES "*286*"
			LET c[33] = c[33] + tot
		WHEN r.comp_type MATCHES "*386*"
			LET c[34] = c[34] + tot
		WHEN r.comp_type MATCHES "*486*"
			LET c[35] = c[35] + tot
		OTHERWISE
			IF r.comp_type = "-" THEN
				LET r.comp_type = NULL
			END IF 
			PRINT tot, " ", r.comp_type
		END CASE

	BEFORE GROUP OF r.comp_type
		LET tot = 0

	ON LAST ROW
		SKIP TO TOP OF PAGE
		PRINT 	c[33], " 286 Users"
		PRINT	c[34], " 386 Users"
		PRINT	c[35], " 486 Users"
		PRINT	c[36], " Not identified"
		SKIP 2 LINES

		PRINT	"Planned Use"
		PRINT	c[1], " Development"

		PRINT	c[2], " Learn Unix"

		PRINT	c[3], " Other"

		PRINT	c[4], " Communication"

		PRINT	c[5], " Business"

		SKIP 1 LINE
		PRINT	c[6], " C compilers"

		PRINT	c[7], " Turbo C"

		PRINT	c[8], " MicroSoft C"
		PRINT	c[9], " Other"

		SKIP 1 LINE
		PRINT	c[10], " Macintosh"

		SKIP 1 LINE
		PRINT	c[11], " Windows"

		SKIP 1 LINE
		PRINT	c[12], " Workstations"
		PRINT	c[13], " SUN"
		PRINT	c[14], " IBM"
		PRINT	c[15], " DEC"
		PRINT	c[16], " Hewlett-Packard"

		SKIP 1 LINE
		PRINT	c[17], " Operating Systems"
		PRINT	c[18], " UNIX System V"
		PRINT	c[19], " ULTRIX"
		PRINT	c[20], " SCO UNIX or XENIX"
		PRINT	c[21], " AIX"
		PRINT	c[22], " SUNOS"
		PRINT	c[23], " HPUX"
		PRINT	c[24], " ESIX"

		SKIP 1 LINE
		PRINT c[25], "  personal use"
		PRINT c[26], "  business use"
		PRINT c[27], "  education"
		SKIP 1 LINE
		PRINT c[28], "  beginner"
		PRINT c[29], "  intermediate"
		PRINT c[30], "  professional"
		PRINT c[31], "  new to unix"
		SKIP 1 LINE
		PRINT c[32], "  Regcards sampled"
		PRINT c[37], "   Have no invoice"
		PRINT c[38], "   Have an invoice"
		PRINT c[39], "   Have a 3.0 serial no"
		PRINT c[40], "   Have a 3.1 serial no" 
		PRINT c[41], "   Have a 3.2 serial no"
		SKIP 1 LINE
		PRINT exp[1], "   Software Expence <  250"
		PRINT exp[2], "   Software Expence <  500"
		PRINT exp[3], "   Software Expence < 1000"
		PRINT exp[4], "   Software Expence < 3000"
		PRINT exp[5], "   Software Expence < 5000"
		PRINT exp[6], "   Software Expence > 5000"
END REPORT

#
# Enter a reg card
# This function gets used so many ways I ended up with
# 
FUNCTION enter_nreg(cu_no)
	DEFINE cu_no INTEGER
	DEFINE ret_status, ctr SMALLINT
	DEFINE u_str, l_str CHAR(38)
	CLEAR FORM

	LET p_nreg.cust_no = NULL
	LET p_shipreg.cust_no = NULL

	INPUT BY NAME 	p_nreg.ser_no
	AFTER FIELD ser_no
		MESSAGE " "
		IF p_nreg.ser_no IS NULL THEN
			MESSAGE "No serial number"
			NEXT FIELD ser_no
		END IF
		CALL ch_num(p_nreg.ser_no) RETURNING ret_status
		IF ret_status <> 0 THEN
			MESSAGE "Invalid serial number"

			NEXT FIELD ser_no
		END IF

		SELECT COUNT(*) INTO ctr FROM newreg
		 WHERE newreg.ser_no = p_nreg.ser_no

		IF ctr <> 0 THEN
			MESSAGE "Serial Number already entered"
			RETURN
		END IF

		SELECT * INTO p_shipreg.* FROM shipreg
		 WHERE ser_no = p_nreg.ser_no
		LET p_nreg.cust_no = p_shipreg.cust_no
	END INPUT

	IF cu_no <> 0 THEN
		LET p_nreg.cust_no = cu_no
	END IF

LABEL retry:
	IF p_nreg.cust_no IS NULL THEN
		INPUT BY NAME p_cust.contact, p_nreg.cust_no
	END IF

	IF p_nreg.cust_no IS NOT NULL THEN
		LET p_cust.contact = NULL
		SELECT * INTO p_cust.* FROM customer
		 WHERE cust_no = p_nreg.cust_no
		IF p_cust.contact IS NULL THEN
			MESSAGE "Customer not found"
			LET p_nreg.cust_no = NULL
			GOTO retry
		END IF

		SELECT * INTO s_address.* FROM address
		 WHERE address.cust_no = p_cust.cust_no
		   AND address.add_type <> "b"

		DISPLAY BY NAME	p_cust.contact,
				p_cust.cust_no,
				s_address.line1,
				s_address.line2,
				s_address.city,
				s_address.state,
				s_address.country,
				s_address.zipcode

		CALL yn("Use this customer ") RETURNING answer
		IF answer = "y" THEN
			LET chosen = TRUE
			GOTO looked_up
		ELSE
			LET chosen = FALSE
			GOTO grab_data
		END IF
	END IF

	CALL cruncher(p_cust.contact) RETURNING u_str

	DECLARE t_curs CURSOR FOR
	 SELECT * FROM customer
	  WHERE crunch MATCHES u_str

	LET chosen = FALSE
	FOREACH t_curs INTO p_cust.*
		SELECT * INTO s_address.* FROM address
		 WHERE address.cust_no = p_cust.cust_no
		   AND address.add_type <> "b"

		DISPLAY BY NAME	p_cust.contact,
				p_cust.cust_no,
				s_address.line1,
				s_address.line2,
				s_address.city,
				s_address.state,
				s_address.country,
				s_address.zipcode

		CALL yn("Enter 'y' To select this invoice:")
			RETURNING answer

		IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH

LABEL looked_up:
	IF chosen = TRUE THEN
		LET p_nreg.cust_no = p_cust.cust_no
	ELSE
		CALL yn("No Customer found. Proceed <y/n>") RETURNING answer
		IF answer <> "y" THEN
			RETURN
		END IF
	END IF

LABEL grab_data:
	INPUT BY NAME	p_nreg.comp_type,
			p_nreg.disk_size,
			p_nreg.develop,
			p_nreg.learn,
			p_nreg.other,
			p_nreg.communication,
			p_nreg.business,
			p_nreg.software_exp,
			p_nreg.exp_level,
			p_nreg.personal_use,
			p_nreg.business_use,
			p_nreg.education,
			p_nreg.c_comp,
			p_nreg.turbo_c,
			p_nreg.microsoft_c,
			p_nreg.other_c,
			p_nreg.macintosh,
			p_nreg.windows,
			p_nreg.workstations,
			p_nreg.sun,
			p_nreg.ibm,
			p_nreg.dec_sys,
			p_nreg.hewlett_packard,
			p_nreg.operating_sys,
			p_nreg.unix_v,
			p_nreg.ultrix,
			p_nreg.xenix,
			p_nreg.aix,
			p_nreg.sunos,
			p_nreg.hpux,
			p_nreg.esix,
			p_nreg.other_os

	IF chosen = FALSE THEN
		DISPLAY FORM mail_form
		CALL enter_mail(1)
		LET p_nreg.cust_no = p_cust.cust_no
		DISPLAY FORM reg_form
		LET p_nreg.reg_date = TODAY
		DISPLAY BY NAME p_nreg.*,
				p_cust.contact,
				s_address.line1,
				s_address.line2,
				s_address.city,
				s_address.state,
				s_address.country,
				s_address.zipcode

		IF p_shipreg.cust_no IS NOT NULL THEN
			LET p_shipreg.cust_no = NULL
			DELETE FROM shipreg WHERE ser_no = p_nreg.ser_no
		END IF
	ELSE
		SELECT MIN(invoice.invoice_date)
		  INTO p_nreg.reg_date
		  FROM invoice
		 WHERE invoice.cust_no = p_nreg.cust_no
		IF status = NOTFOUND THEN
			LET p_nreg.reg_date = TODAY
		END IF
	END IF

	INSERT INTO newreg VALUES (p_nreg.*)

	IF p_shipreg.cust_no IS NULL THEN
		INSERT INTO shipreg VALUES (
			p_nreg.cust_no,
			p_nreg.ser_no,
			NULL
		)
	END IF
END FUNCTION
