#
# Count the number of customers for each base product;
# see how far each one went in his purchasing cycle.
# 
# by fwb, 3/3/94
#
DATABASE mwc

MAIN
	DEFINE cust_number LIKE customer.cust_no
	DEFINE prod_number LIKE inv_line.prod_no
	DEFINE	cust_total,
		no_update,
		coherent_31,
		coherent_32,
		coherent_40,
		coherent_42	INTEGER

# count COHERENT 3.0
	LET cust_total = 0
	LET no_update = 0
	LET coherent_31 = 0
	LET coherent_32 = 0
	LET coherent_40 = 0
	LET coherent_42 = 0

	DECLARE curs1 CURSOR FOR
	SELECT	invoice.cust_no
	FROM	invoice, inv_line
	WHERE	inv_line.prod_no IN (1, 2)
			AND
		inv_line.invoice_no = invoice.invoice_no

        FOREACH curs1 INTO cust_number
            LET cust_total = cust_total + 1
            LET prod_number = NULL

	    SELECT
                MAX(prod_no)
                INTO    prod_number
                FROM    invoice, inv_line
                WHERE   invoice.cust_no = cust_number
                            AND
                        invoice.invoice_no = inv_line.invoice_no
			    AND
                        prod_no IN (
                                28, 29, 37, 38, 48, 49, 56, 57, 62,
                                63, 94, 95, 98, 99, 113, 114
			)

	    IF prod_number IS NULL THEN
                LET no_update = no_update + 1
            ELSE
                CASE
		# updates to COHERENT 3.1
                    WHEN prod_number = 28
                	LET coherent_31 = coherent_31 + 1
                    WHEN prod_number = 29
                	LET coherent_31 = coherent_31 + 1
                    WHEN prod_number = 37
                	LET coherent_31 = coherent_31 + 1
                    WHEN prod_number = 38
                	LET coherent_31 = coherent_31 + 1
		# updates to COHERENT 3.2
                    WHEN prod_number = 48
			LET coherent_32 = coherent_32 + 1
                    WHEN prod_number = 49
			LET coherent_32 = coherent_32 + 1
                    WHEN prod_number = 56
			LET coherent_32 = coherent_32 + 1
                    WHEN prod_number = 57
			LET coherent_32 = coherent_32 + 1
		# updates to COHERENT 4.0
                    WHEN prod_number = 62
			LET coherent_40 = coherent_40 + 1
                    WHEN prod_number = 63
			LET coherent_40 = coherent_40 + 1
		# everything else is COHERENT 4.2
		    OTHERWISE
                        LET coherent_42 = coherent_42 + 1
                END CASE
	    END IF
        END FOREACH

        DISPLAY "COHERENT 3.0"
	DISPLAY "   Total customers: ", cust_total
	DISPLAY "   No update: ", no_update
	DISPLAY "   Updates ended at COHERENT 3.1: ", coherent_31
        DISPLAY "   Updates ended at COHERENT 3.2: ", coherent_32
        DISPLAY "   Updates ended at COHERENT 4.0: ", coherent_40
        DISPLAY "   Updated ended at COHERENT 4.2: ", coherent_42

# count COHERENT 3.1
	LET cust_total = 0
	LET no_update = 0
	LET coherent_32 = 0
	LET coherent_40 = 0
	LET coherent_42 = 0

	DECLARE curs2 CURSOR FOR
	SELECT	invoice.cust_no
	FROM	invoice, inv_line
	WHERE	inv_line.prod_no IN (26, 27)
			AND
		inv_line.invoice_no = invoice.invoice_no

        FOREACH curs2 INTO cust_number
            LET cust_total = cust_total + 1
            LET prod_number = NULL

	    SELECT
                MAX(prod_no)
                INTO    prod_number
                FROM    invoice, inv_line
                WHERE   invoice.cust_no = cust_number
                            AND
                        invoice.invoice_no = inv_line.invoice_no
			    AND
                        prod_no IN (
                                48, 49, 56, 57, 62,
                                63, 94, 95, 98, 99, 113, 114
			)

	    IF prod_number IS NULL THEN
                LET no_update = no_update + 1
            ELSE
                CASE
		# updates to COHERENT 3.2
                    WHEN prod_number = 48
			LET coherent_32 = coherent_32 + 1
                    WHEN prod_number = 49
			LET coherent_32 = coherent_32 + 1
                    WHEN prod_number = 56
			LET coherent_32 = coherent_32 + 1
                    WHEN prod_number = 57
			LET coherent_32 = coherent_32 + 1
		# updates to COHERENT 4.0
                    WHEN prod_number = 62
			LET coherent_40 = coherent_40 + 1
                    WHEN prod_number = 63
			LET coherent_40 = coherent_40 + 1
		# everything else is COHERENT 4.2
		    OTHERWISE
                        LET coherent_42 = coherent_42 + 1
                END CASE
	    END IF
        END FOREACH

        DISPLAY "COHERENT 3.1"
	DISPLAY "   Total customers: ", cust_total
	DISPLAY "   No update: ", no_update
        DISPLAY "   Updates ended at COHERENT 3.2: ", coherent_32
        DISPLAY "   Updates ended at COHERENT 4.0: ", coherent_40
        DISPLAY "   Updated ended at COHERENT 4.2: ", coherent_42

# count COHERENT 3.2
	LET cust_total = 0
	LET no_update = 0
	LET coherent_40 = 0
	LET coherent_42 = 0

	DECLARE curs3 CURSOR FOR
	SELECT	invoice.cust_no
	FROM	invoice, inv_line
	WHERE	inv_line.prod_no IN (44, 45)
			AND
		inv_line.invoice_no = invoice.invoice_no

        FOREACH curs3 INTO cust_number
            LET cust_total = cust_total + 1
            LET prod_number = NULL

	    SELECT
                MAX(prod_no)
                INTO    prod_number
                FROM    invoice, inv_line
                WHERE   invoice.cust_no = cust_number
                            AND
                        invoice.invoice_no = inv_line.invoice_no
			    AND
                        prod_no IN (
                                62, 63, 94, 95, 98, 99, 113, 114
			)

	    IF prod_number IS NULL THEN
                LET no_update = no_update + 1
            ELSE
                CASE
		# updates to COHERENT 4.0
                    WHEN prod_number = 62
			LET coherent_40 = coherent_40 + 1
                    WHEN prod_number = 63
			LET coherent_40 = coherent_40 + 1
		# everything else is COHERENT 4.2
		    OTHERWISE
                        LET coherent_42 = coherent_42 + 1
                END CASE
	    END IF
        END FOREACH

        DISPLAY "COHERENT 3.2"
	DISPLAY "   Total customers: ", cust_total
	DISPLAY "   No update: ", no_update
        DISPLAY "   Updates ended at COHERENT 4.0: ", coherent_40
        DISPLAY "   Updated ended at COHERENT 4.2: ", coherent_42

# count COHERENT 4.0
	LET cust_total = 0
	LET no_update = 0
	LET coherent_42 = 0

	DECLARE curs4 CURSOR FOR
	SELECT	invoice.cust_no
	FROM	invoice, inv_line
	WHERE	inv_line.prod_no IN (60, 61)
			AND
		inv_line.invoice_no = invoice.invoice_no

        FOREACH curs4 INTO cust_number
            LET cust_total = cust_total + 1
            LET prod_number = NULL

	    SELECT
                MAX(prod_no)
                INTO    prod_number
                FROM    invoice, inv_line
                WHERE   invoice.cust_no = cust_number
                            AND
                        invoice.invoice_no = inv_line.invoice_no
			    AND
                        prod_no IN ( 
			        94, 95, 98, 99, 113, 114
			)

	    IF prod_number IS NULL THEN
                LET no_update = no_update + 1
            ELSE
                LET coherent_42 = coherent_42 + 1
	    END IF
        END FOREACH

        DISPLAY "COHERENT 4.0"
	DISPLAY "   Total customers: ", cust_total
	DISPLAY "   No update: ", no_update
        DISPLAY "   Updated to COHERENT 4.2: ", coherent_42

# count COHERENT 4.2
	DECLARE curs5 CURSOR FOR
	SELECT	prod_no
	FROM	inv_line
	WHERE	prod_no IN (107, 108, 109, 110, 115, 116, 117, 118)

        LET cust_total = 0
        FOREACH curs5 INTO prod_number
            LET cust_total = cust_total + 1
        END FOREACH

        DISPLAY "COHERENT 4.2: ", cust_total

# count COHERENT 4.2 (Borland list)
	DECLARE curs6 CURSOR FOR
	SELECT	prod_no
	FROM	inv_line
	WHERE	prod_no IN (256, 257)

        LET cust_total = 0
        FOREACH curs6 INTO prod_number
            LET cust_total = cust_total + 1
        END FOREACH

        DISPLAY "COHERENT 4.2 (Borland list): ", cust_total
END MAIN

