DATABASE mwc

MAIN
	DEFINE
		prod		char(4),
		mycust		INTEGER,
		myname		LIKE customer.contact,
		myphone		LIKE customer.phone_no,
		mycountry	LIKE address.country,
		myaddr		LIKE address.line1,
		myaddr2		LIKE address.line2,
		myproduct	LIKE cprodlst.prod_no

# select customer's by customer number, and get their phone number, state,

	DECLARE cust_curs CURSOR FOR
		SELECT	customer.cust_no, customer.contact,
			customer.phone_no, address.line1, address.line2, address.country
		INTO 	mycust, myname, myphone, myaddr, myaddr2, mycountry
		FROM 	customer, address
		WHERE 	address.cust_no = customer.cust_no AND
			address.country IS NOT NULL
		ORDER BY address.country


	START REPORT by_country

# Now walk though the customer/product table and find out what they have
	FOREACH cust_curs
		DECLARE prod_curs CURSOR FOR
			SELECT cprodlst.prod_no
			INTO myproduct
			FROM cprodlst
			WHERE cprodlst.cust_no = mycust AND
			      cprodlst.prod_no IN (60, 61)

# a product by product comparison. When a product is matched, a string is
# set to a value which will print on the report.

		FOREACH prod_curs
			IF (myproduct = 60) OR (myproduct = 61) THEN 
				OUTPUT TO REPORT 
					by_country (mycust, myname, myphone, myaddr, myaddr2, mycountry, prod)
			END IF			

		END FOREACH

	END FOREACH
	FINISH REPORT by_country


END MAIN

REPORT by_country (mynumber, cname, cphone, caddr, caddr2, ccountry, cprod)


	DEFINE 	mynumber INTEGER,
		cname 	LIKE customer.contact,
		cphone	LIKE customer.phone_no,
		caddr	LIKE address.line1,
		caddr2	LIKE address.line2,
		ccountry LIKE address.country,
		cprod	CHAR(4)

	OUTPUT
		LEFT MARGIN 0
		RIGHT MARGIN 132
		TOP MARGIN 2
		BOTTOM MARGIN 2
		PAGE LENGTH 60
		REPORT TO PIPE "print_land | lp"

	FORMAT
	PAGE HEADER
		PRINT	COLUMN 1,  PAGENO USING "Page ####",
			COLUMN 25, "4.0 Owners Outside of U.S.",
			25 SPACES,"Date: ", TODAY
		PRINT	COLUMN 6, "Customer Name", COLUMN 45, "Address",
			COLUMN 79, "Cust No.", COLUMN 90,"Country","  ",
			COLUMN 103,"Prod."
		SKIP 1 LINE

	AFTER GROUP OF cname
		PRINT	COLUMN 1, cname, COLUMN 40, caddr, COLUMN 79 ,mynumber USING "<<<<<<",
			          COLUMN 87, ccountry
		PRINT	COLUMN 40, caddr2
		SKIP 1 LINE

END REPORT
