# more reports for invoice program
#
GLOBALS "globals0.4gl"

#
# Which report do we run?
#
MAIN
	OPTIONS MESSAGE LINE 22,
		PROMPT LINE 21,
		DELETE KEY CONTROL-K,
		NEXT KEY CONTROL-N,
		PREVIOUS KEY CONTROL-P

	OPEN FORM big_form FROM "mainline"
	DISPLAY FORM big_form

	MENU "REPORT"
	COMMAND "Batch" "Batch report"
		CALL b_report()

	COMMAND "Tym" "Batch report from bank"
		CALL t_report()

	COMMAND "Orig" "Original inquiry report"
		CALL o_report()

	COMMAND "Card" "Credit card report"
		CALL c_report()

	COMMAND "Line" "quantity date by business name"
		CALL e_report()

	COMMAND "Multi" "Multi copys to same address"
		CALL m_report()

	COMMAND	"Pay" "Late payment report"
		CALL p_report()

	COMMAND "Quick" "Quick report"
		CALL q_report()

	COMMAND "Inv" "Invoice list after timenet"
		RUN "tnet.4ge"

	COMMAND "Dup" "List duplicate mailing addresses"
		RUN "dupfind.4ge"

	COMMAND "Exit" "Exit report menu"
		EXIT MENU
	END MENU
END MAIN

#
# Display a message and get a y or n
#
FUNCTION yn(msg)
	DEFINE msg CHAR(50)
	DEFINE ans CHAR(1)

	WHILE 1=1
		PROMPT msg CLIPPED, " " FOR ans
		IF ans IS NULL THEN
			RETURN "n"
		END IF

		LET ans = downshift(ans)

		IF ans = "y" OR ans = "n" THEN
			RETURN ans
		END IF
	END WHILE
END FUNCTION

FUNCTION clear_totals()
	LET i_no = 0

	FOR counter = 1 TO 3 # clear totals
		LET qtot[counter] = 0
		LET qtota[counter] = 0
		LET qtotb[counter] = 0
		LET dTot[counter] = 0
		LET subTot[counter] = 0
		LET taxTot[counter] = 0
		LET finTot[counter] = 0
		LET shipTot[counter] = 0
	END FOR
END FUNCTION

#
# Original inquiry report
#
FUNCTION o_report()
	CONSTRUCT BY NAME query1 ON
		invoice_date, invoice.inq_src, inv_line.prod_no

	LET s1 = "SELECT * FROM invoice, customer, inv_line ",
		 "WHERE ", query1 CLIPPED,
		 "  AND customer.cust_no = invoice.cust_no",
		 "  AND inv_line.invoice_no = invoice.invoice_no"

	PREPARE s_5 FROM s1

	DECLARE o_curs CURSOR FOR s_5

	CALL clear_totals()

	MESSAGE ""

	START REPORT o_rep

	FOREACH o_curs INTO p_invoice.*, p_cust.*, p_line.*
		OUTPUT TO REPORT o_rep(p_invoice.*, p_cust.*, p_line.*)
	END FOREACH

	FINISH REPORT o_rep
END FUNCTION

#
# The inquiry source report.
#
REPORT o_rep (p_invoice, p_cust, p_line)
	DEFINE	p_cust RECORD LIKE customer.*,
		p_invoice RECORD LIKE invoice.*,
		p_line RECORD LIKE inv_line.*

	DEFINE	qper, iper, dper DECIMAL(5,2)

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY	p_cust.inq_src,
			p_cust.cust_no,
			p_invoice.invoice_no

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<", 30 SPACES,
			"Original inquiry report", 30 SPACES, TODAY
		PRINT	query1 CLIPPED
		PRINT	22 SPACES, "Customers   Quantity   per/cust     ",
			   "Invoices  per/cust     Subtotal  per/cust"
		SKIP 2 LINES

	AFTER GROUP OF p_cust.cust_no
		LET qtota[1] = qtota[1] + 1

	AFTER GROUP OF p_invoice.invoice_no
		LET qtotb[1] = qtotb[1] + 1
		LET subTot[1] = subTot[1] + p_invoice.subtotal

	ON EVERY ROW
		LET qtot[1] = qtot[1] + p_line.quantity

	AFTER GROUP OF p_cust.inq_src
		SELECT * INTO p_mag.* FROM magazines
		 WHERE magazines.inq_src = p_cust.inq_src
		LET stot = qtota[1]
		LET qper = qtot[1] / stot
		LET iper = qtotb[1] / stot
		LET dper = subTot[1] / stot
		PRINT	p_mag.mag_name, qtota[1],
			qtot[1], 4 SPACES, qper, 2 SPACES,
			qtotb[1], 3 SPACES, iper,
			subTot[1], 3 SPACES, dper

		LET qtot[2] = qtot[2] + qtot[1]
		LET qtota[2] = qtota[2] + qtota[1]
		LET qtotb[2] = qtotb[2] + qtotb[1]
		LET subTot[2] = subTot[2] + subTot[1]

		IF p_mag.mag_name MATCHES "*Mailing*" OR
		   p_mag.mag_name MATCHES "*Evaluation*" OR
		   p_mag.mag_name = "None" OR
		   qtotb[1] < 200 THEN
			# Don't accumulate to adjusted totals
		ELSE
			LET qtot[3] = qtot[3] + qtot[1]
			LET qtota[3] = qtota[3] + qtota[1]
			LET qtotb[3] = qtotb[3] + qtotb[1]
			LET subTot[3] = subTot[3] + subTot[1]
		END IF

		LET qtot[1] = 0
		LET qtota[1] = 0
		LET qtotb[1] = 0
		LET subTot[1] = 0

	ON LAST ROW
		SKIP 1 LINE
		LET stot = qtota[2]
		LET qper = qtot[2] / stot
		LET iper = qtotb[2] / stot
		LET dper = subTot[2] / stot
		PRINT	20 SPACES, qtota[2],
			qtot[2], 4 SPACES, qper, 2 SPACES,
			qtotb[2], 3 SPACES, iper,
			subTot[2], 3 SPACES, dper

		SKIP 1 LINE
		LET stot = qtota[3]
		LET qper = qtot[3] / stot
		LET iper = qtotb[3] / stot
		LET dper = subTot[3] / stot
		PRINT	"Adjusted", 12 SPACES, qtota[3],
			qtot[3], 4 SPACES, qper, 2 SPACES,
			qtotb[3], 3 SPACES, iper,
			subTot[3], 3 SPACES, dper
END REPORT
#
# Get late payments
#
FUNCTION p_report()
	DEFINE	day10, day30, day90 DATE
	DEFINE  ctr INTEGER

	LET day10 = TODAY - 10
	LET day30 = TODAY - 30
	LET day90 = TODAY - 90

	DECLARE p_curs CURSOR FOR
	 SELECT *
	   FROM invoice, OUTER payment
	  WHERE ((invoice.term_no = 7 AND invoice.invoice_date < day10)
	     OR  (invoice.term_no = 8 AND invoice.invoice_date < day30))
	    AND invoice.invoice_date >= day90
	    AND payment.invoice_no = invoice.invoice_no

	MESSAGE ""

	START REPORT p_rep

	FOREACH p_curs INTO p_invoice.*, p_payment.* 
		SELECT COUNT(*)
		  INTO ctr
		  FROM cmemo
		 WHERE invoice_no = p_invoice.invoice_no

		IF ctr IS NOT NULL AND ctr > 0 THEN
			OUTPUT TO REPORT p_rep(p_invoice.*, p_payment.*)
		END IF
	END FOREACH

	FINISH REPORT p_rep

	CLOSE p_curs
END FUNCTION

REPORT p_rep(i, p)
	DEFINE i RECORD LIKE invoice.*
	DEFINE p RECORD LIKE payment.*
	DEFINE amt MONEY(8,2)

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY i.invoice_no

	FORMAT
	PAGE HEADER
		PRINT	pageno USING "page <<", 47 SPACES,
			"Late Payment Report", 46 SPACES, TODAY
		PRINT	"invoice invoice date terms  customer name",
			64 SPACES, "invoice amt    payments"
		SKIP 1 LINE

	BEFORE GROUP OF i.invoice_no
		LET amt = 0

	ON EVERY ROW
		IF p.amount IS NOT NULL THEN
			LET amt = amt + p.amount
		END IF

	AFTER GROUP OF i.invoice_no
		IF (i.itotal - 20.00) > amt THEN
			SELECT *
			  INTO p_cust.*
			  FROM customer
			 WHERE customer.cust_no = i.cust_no

			SELECT *
			  INTO b_address.*
			  FROM address
			 WHERE address.cust_no = i.cust_no
			   AND address.add_type <> "s"

			PRINT	i.invoice_no USING "######", 3 SPACES,
				i.invoice_date, 3 SPACES,
				i.term_no USING "##", 4 SPACES,
				p_cust.contact, 
				b_address.line1, " ",
				i.itotal, " ",
				amt
		END IF
END REPORT

#
# Get batch report from bank
#
FUNCTION t_report()
	WHENEVER ERROR GOTO no_sws
	LOCK TABLE sws IN EXCLUSIVE MODE
	WHENEVER ERROR STOP

	RUN "cp REP.DAT IFT.DAT"	# make command file
	RUN "tmn -v"
	RUN "egrep \"B|6088\" TBI.DAT > tymerept.dat"
	RUN "ph tymerept.dat"

	UNLOCK TABLE sws
	RETURN

LABEL no_sws:
	PROMPT "Tymenet connection in use" FOR answer
END FUNCTION

#
# quantity & date report
#
FUNCTION e_report()
	CONSTRUCT  BY NAME query1 ON line1

	LET s1 = "SELECT * FROM address, invoice, inv_line",
		 " WHERE address.cust_no = invoice.cust_no",
		 "   AND address.add_type <> \"s\"",
		 "   AND inv_line.invoice_no = invoice.invoice_no",
		 "   AND ", query1 CLIPPED

	PREPARE s_7 FROM s1

	DECLARE e_curs CURSOR FOR s_7

	MESSAGE ""

	LET i_no = 0

	START REPORT e_rep

	FOREACH e_curs INTO b_address.*, p_invoice.*, p_line.*
		OUTPUT TO REPORT e_rep(p_invoice.*, p_line.*)
	END FOREACH

	CLOSE e_curs

	CALL replace(query1, "line1=", "contact=") RETURNING query1

	LET s1 = "SELECT * FROM customer, invoice, inv_line",
		 " WHERE customer.cust_no = invoice.cust_no",
		 "   AND inv_line.invoice_no = invoice.invoice_no",
		 "   AND ", query1 CLIPPED

	PREPARE s_8 FROM s1

	DECLARE f_curs CURSOR FOR s_8

	FOREACH e_curs INTO p_cust.*, p_invoice.*, p_line.*
		OUTPUT TO REPORT e_rep(p_invoice.*, p_line.*)
	END FOREACH

	FINISH REPORT e_rep

	CLOSE f_curs
END FUNCTION

REPORT e_rep(i, l)
	DEFINE i RECORD LIKE invoice.*
	DEFINE l RECORD LIKE inv_line.*

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY i.invoice_date

	FORMAT
	PAGE HEADER
		PRINT	pageno USING "page <<", 10 SPACES,
			"Business name report", 10 SPACES, TODAY
		PRINT	query1
		PRINT	"Date       quantity"
		SKIP 1 LINE

	ON EVERY ROW
		PRINT	i.invoice_date, l.quantity
		LET i_no = i_no + l.quantity

	ON LAST ROW
		SKIP 1 LINE
		PRINT	"Total", i_no
END REPORT

#
# Quick report
#
FUNCTION q_report()
	CONSTRUCT BY NAME query1 ON invoice_date, discount, term_no

	LET s1 = "SELECT inv_line.* FROM invoice, inv_line",
		 " WHERE inv_line.invoice_no = invoice.invoice_no",
		 "   AND ", query1 CLIPPED

	PREPARE s_6 FROM s1

	DECLARE q_curs CURSOR FOR s_6

	MESSAGE ""

	START REPORT q_rep

	FOREACH q_curs INTO p_line.*
		OUTPUT TO REPORT q_rep(p_line.*)
	END FOREACH

	FINISH REPORT q_rep

	CLOSE q_curs
END FUNCTION

REPORT q_rep(l)
	DEFINE l RECORD LIKE inv_line.*
	DEFINE p RECORD LIKE product.*
	DEFINE ct, tot SMALLINT
	DEFINE st, gt MONEY(8, 2)

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY l.prod_no
	
	FORMAT
	FIRST PAGE HEADER
		LET tot = 0
		LET gt = 0
		PRINT	20 SPACES, "Quick Report", 10 SPACES, TODAY
		PRINT 	query1
		SKIP 2 LINES

	BEFORE GROUP OF l.prod_no
		LET ct = 0
		LET st = 0

	ON EVERY ROW
		LET ct = ct + l.quantity

	AFTER GROUP OF l.prod_no
		SELECT * INTO p.* FROM product WHERE prod_no = l.prod_no
		LET st = ct * p.price
		LET gt = gt + st
		LET tot = tot + ct
		PRINT p.prod_name, p.comment1, ct, st
		
	ON LAST ROW
		SKIP 1 LINE
		PRINT 60 SPACES, tot, gt
END REPORT

#
# Attempt to find out how many purchaces are made by large companys
#
FUNCTION m_report()
	# Delete work file if it exists
	WHENEVER ERROR CONTINUE
	DROP TABLE multiworkf
	WHENEVER ERROR STOP

	CREATE TABLE multiworkf (
		line1		CHAR(38),
		quantity	SMALLINT,
		customer	INTEGER
	)

	CALL build_up()
	CALL co_report()

	DROP TABLE multiworkf
END FUNCTION

FUNCTION build_up()

# Select the customers who satisfy the input from the inv screen and report
# their cust_no, 1st address line and product quantity to the function that
# will generate a report of people who have multiple copies of a product.

	DEFINE w RECORD
		line1		CHAR(38),
		quantity	SMALLINT,
		customer	INTEGER
	END RECORD

	CONSTRUCT query1 ON
		line1, prod_no, term_no, discount, invoice_date
	FROM
		line1, prod_no, term_no, discount, invoice_date

	MESSAGE ""	# prevent spooler message from eating the screen.

# May 19, 1993: Added cust_no for Marketting (Bob H.)

	LET s1 = "SELECT line1, quantity, invoice.cust_no FROM invoice, inv_line, address",
		 " WHERE invoice.invoice_no = inv_line.invoice_no",
		 "   AND invoice.cust_no = address.cust_no",
		 "   AND address.add_type != \"b\" AND ",
		 query1 CLIPPED

	PREPARE s_4 FROM s1

	DECLARE co_curs CURSOR FOR s_4

	START REPORT u_rep

	FOREACH co_curs INTO w.*
			OUTPUT TO REPORT u_rep(w.*)
	END FOREACH

	FINISH REPORT u_rep

	CLOSE co_curs
END FUNCTION

REPORT u_rep(d)
	DEFINE d, w RECORD
		line1		CHAR(38),
		quantity	SMALLINT,
		customer	INTEGER
	END RECORD

	OUTPUT
		REPORT TO "/dev/null"

	ORDER BY d.line1

	FORMAT
	BEFORE GROUP OF d.line1
		LET w.quantity = 0
		LET w.line1 = d.line1
		LET w.customer = d.customer

	AFTER GROUP OF d.line1
		IF w.quantity > 2 THEN
			INSERT INTO multiworkf VALUES (w.*)
		END IF

	ON EVERY ROW
		LET w.quantity = w.quantity + d.quantity
END REPORT

FUNCTION co_report()
	DEFINE w RECORD
		line1		CHAR(38),
		quantity	SMALLINT,
		customer	INTEGER
	END RECORD

	DECLARE cr_curs CURSOR FOR SELECT * FROM multiworkf

	START REPORT u_r

	FOREACH cr_curs INTO w.*
		OUTPUT TO REPORT u_r(w.*)
	END FOREACH

	FINISH REPORT u_r

	CLOSE cr_curs
END FUNCTION

REPORT u_r(w)
	DEFINE 
		ccontact	LIKE customer.contact,
		cphone		LIKE customer.phone_no,
		w RECORD
			line1		CHAR(38),
			quantity	SMALLINT,
			cno		INTEGER
		END RECORD


	OUTPUT
		REPORT TO PIPE "c10 | lp"
#		REPORT TO "/tmp/bobfile.multi"
		LEFT MARGIN 0
		PAGE LENGTH 80

	ORDER BY w.quantity 

	FORMAT
	PAGE HEADER
		PRINT	23 SPACES, "Multiple Copy Purchasers",
#		PRINT	20 SPACES, "Corporate Report",
			20 SPACES, TODAY
		PRINT	query1 CLIPPED
		SKIP 2 LINES

	ON EVERY ROW
		SELECT customer.contact, customer.phone_no
		INTO ccontact, cphone
		FROM customer
		WHERE w.cno = customer.cust_no

		PRINT	ccontact CLIPPED, COLUMN 30, w.line1, w.quantity
		PRINT 	cphone
		SKIP 1 LINE

END REPORT

#
# Batch report. There are both invoices and credit memos in a batch.
# This is done with two FOREACH loops feeding the REPORT.
#
FUNCTION b_report()
	CONSTRUCT query1 ON
		batch.batch_ix, batch.batch_no, batch.batch_date, 
		invoice.ref_no
	     FROM
		invoice.batch_ix, invoice.cust_no, invoice.invoice_date,
		invoice.ref_no
 
	LET s1 = 
		"SELECT batch.*, invoice.*, terms.term_name, customer.contact",
		"  FROM batch, invoice, terms, customer",
		" WHERE ", query1 CLIPPED,
		  " AND invoice.batch_ix = batch.batch_ix",
		  " AND invoice.term_no  = terms.term_no",
		  " AND invoice.cust_no  = customer.cust_no"

	MESSAGE query1 CLIPPED

	PREPARE s_2 FROM s1

	DECLARE b_curs CURSOR FOR s_2

	LET finTot[1] = 0
	LET qtot[1] = 0
	LET dTot[1] = 0
	LET finTot[2] = 0
	LET qtot[2] = 0
	LET dTot[2] = 0
	LET dTot[3] = 0

	#
	# Pass invoice data to c_rep() via the memo record.
	#
	LET p_memo.memo_no = NULL
	LET p_memo.auth_no = NULL
	
	CALL yn("print report <y/n>") RETURNING answer

	IF answer == "y" THEN
		START REPORT c_rep
	ELSE
		START REPORT cx_rep
	END IF

	FOREACH b_curs 
	   INTO p_batch.*, p_invoice.*, p_term.term_name, p_cust.contact
		IF p_invoice.tym_flag == 6 THEN
			CONTINUE FOREACH
		END IF 

		LET p_memo.tym_flag = p_invoice.tym_flag
		LET p_memo.invoice_no = p_invoice.invoice_no
		LET p_memo.amount = p_invoice.itotal
		LET p_memo.memo_date = p_invoice.invoice_date
		LET p_memo.ref_no = p_invoice.ref_no

		IF answer == "y" THEN
			OUTPUT TO REPORT
				c_rep(p_batch.*, p_memo.*, p_term.term_name,
					p_cust.contact)
		ELSE
			OUTPUT TO REPORT
				cx_rep(p_batch.*, p_memo.*, p_term.term_name,
					p_cust.contact)
		END IF
	END FOREACH

	CLOSE b_curs

	LET s1 = 
		" SELECT batch.*, cmemo.*, terms.term_name,",
		"	 customer.contact, invoice.ref_no, invoice.tym_flag",
		"   FROM batch, cmemo, invoice, terms, customer",
		"  WHERE ", query1 CLIPPED,
		"    AND cmemo.batch_ix   = batch.batch_ix",
		"    AND cmemo.invoice_no = invoice.invoice_no",
		"    AND invoice.term_no  = terms.term_no",
		"    AND invoice.cust_no  = customer.cust_no"

	PREPARE s_3 from s1 
	DECLARE c_curs CURSOR FOR s_3

	#
	# pass memo data to c_rep()
	#
	FOREACH c_curs
	   INTO p_batch.*, p_memo.*, p_term.term_name,
		p_cust.contact, p_invoice.ref_no, p_invoice.tym_flag

		IF p_memo.tym_flag == 6 THEN
			CONTINUE FOREACH
		END IF 

		LET p_memo.amount = - p_memo.amount

		IF answer == "y" THEN
			OUTPUT TO REPORT
				c_rep(p_batch.*, p_memo.*, p_term.term_name,
					p_cust.contact)
		ELSE
#			LET p_memo.amount = - p_memo.amount
			OUTPUT TO REPORT
				cx_rep(p_batch.*, p_memo.*, p_term.term_name,
					p_cust.contact)
		END IF
	END FOREACH

	IF answer == "y" THEN
		FINISH REPORT c_rep
	ELSE
		FINISH REPORT cx_rep
		run "doscp batch.dat /dev/fd0"
	END IF
	CLOSE c_curs
END FUNCTION

#
# Batch report
#
REPORT c_rep(b, m, term_name, contact)
	DEFINE b RECORD  LIKE batch.*
	DEFINE m RECORD  LIKE cmemo.*
	DEFINE term_name LIKE terms.term_name
	DEFINE contact   LIKE customer.contact

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY b.batch_ix, m.memo_date, m.memo_no, m.invoice_no

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<<", 32 SPACES,
			"BATCH REPORT", 33 SPACES, TODAY, " ", TIME
		PRINT	query1 CLIPPED
		PRINT	"Contact", 33 spaces,
			"memo      auth   invoice    terms      ",
			"amount    ref no   flag"
		SKIP 1 LINE

	BEFORE GROUP OF m.memo_date
		SKIP 1 LINE
		PRINT	m.memo_date

	ON EVERY ROW
		LET qtot[1] = qtot[1] + 1
		LET finTot[1] = finTot[1] + m.amount

		CASE
		WHEN term_name = "amex"
			LET dTot[1] = dTot[1] + m.amount
		WHEN term_name = "discov"
			LET dTot[2] = dTot[2] + m.amount
		OTHERWISE
			LET dTot[3] = dTot[3] + m.amount
		END CASE

		PRINT	contact,
			m.memo_no USING "######", 4 SPACES,
			m.auth_no USING "######", 4 SPACES,
			m.invoice_no USING "######", 5 SPACES,
			term_name,
			m.amount USING "---,---.--",
			m.ref_no USING "##########", 6 SPACES,
			m.tym_flag USING "#"

	AFTER GROUP OF b.batch_ix
		IF qtot[1] != 0 THEN 
			SKIP 1 LINE
			PRINT	"batch ", b.batch_ix, " ",
				b.batch_no, " ",
				b.batch_date, 9 SPACES,
				qtot[1] USING "######", 25 SPACES,
				finTot[1] USING "---,---.--"

			LET qtot[2] = qtot[2] + qtot[1]
			LET finTot[2] = finTot[2] + finTot[1]
		END IF
		LET qtot[1] = 0
		LET finTot[1] = 0

	ON LAST ROW
		SKIP 1 LINE
		PRINT	38 SPACES, qtot[2] USING "######", 31 SPACES,
			finTot[2] USING "---,---.--"
		SKIP 1 LINE
		PRINT	"AMEX  ", dTot[1]
		PRINT	"DISCOV", dTot[2]
		PRINT	"OTHER ", dTot[3]
END REPORT

#
# Batch report to file
#
REPORT cx_rep(b, m, term_name, contact)
	DEFINE b RECORD  LIKE batch.*
	DEFINE m RECORD  LIKE cmemo.*
	DEFINE term_name LIKE terms.term_name
	DEFINE contact   LIKE customer.contact

	OUTPUT
		REPORT TO PIPE "bacct"
#		REPORT TO "test.dat"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0

	ORDER BY b.batch_ix, m.memo_date, m.memo_no, m.invoice_no

	FORMAT
	ON EVERY ROW
		IF m.memo_no IS NULL THEN
			LET m.memo_no = 0
		END IF

		IF m.ref_no IS NULL THEN
			LET m.ref_no = 0
		END IF

		LET m.amount = - m.amount # wierdness from owen

		PRINT	m.invoice_no,
			m.memo_no, " ",
			m.memo_date, " ",
			b.batch_date, " ",
			term_name,
			m.amount USING "------.--",
			m.ref_no,
			b.batch_ix
	ON LAST ROW
		PRINT	"***"
END REPORT

#
# Credit card report
#
FUNCTION c_report()
	CONSTRUCT query1 ON
		invoice.invoice_no, invoice_date, term_no, invoice.batch_ix
	FROM
		invoice.invoice_no, invoice_date, term_no, invoice.batch_ix

	LET s1 = "SELECT * FROM invoice WHERE ", query1 CLIPPED

	PREPARE s_1 FROM s1

	DECLARE d_curs CURSOR FOR s_1

	MESSAGE ""	# prevent spooler message from eating the screen.

	LET finTot[1] = 0

	START REPORT card_rep

	FOREACH d_curs
		INTO p_invoice.* OUTPUT TO REPORT card_rep(p_invoice.*)
	END FOREACH

	FINISH REPORT card_rep
END FUNCTION

#
# Credit card report
#
REPORT card_rep(p_invoice)
	DEFINE p_invoice RECORD LIKE invoice.*
	
	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY p_invoice.invoice_no

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<<", 10 SPACES,
			"CREDIT CARD REPORT", 10 SPACES, TODAY
		PRINT	query1 CLIPPED
		PRINT	"Terms    Invoice #   Date          Card No",
			11 SPACES, "Total"
		SKIP 2 LINES

	ON EVERY ROW
		LET finTot[1] = finTot[1] + p_invoice.itotal
	    	SELECT * INTO p_term.* FROM terms
		 WHERE terms.term_no = p_invoice.term_no

		PRINT	p_term.term_name, 4 SPACES,
			p_invoice.invoice_no USING "######", 2 SPACES,
			p_invoice.invoice_date, 2 SPACES,
			p_invoice.card_no,
			p_invoice.itotal USING "##,###.##"

	ON LAST ROW
		SKIP 1 LINE
		PRINT	47 SPACES, finTot[1] USING "#,###,###.##"
END REPORT
