#
# Print name, phone #, state, customer #, and current version for
# every customer prior to release 4.2
#
# by fwb, adapted from "bigmail.4gl", 2/14/94
#
DATABASE mwc
#
# Produce mailing lists set up by mailcalc
#
GLOBALS
	DEFINE  addr RECORD LIKE address.*
	DEFINE	cust RECORD LIKE customer.*
	DEFINE	work RECORD LIKE workf.*
END GLOBALS

MAIN
	DECLARE curs CURSOR FOR
	SELECT	address.*, customer.*, workf.*
	FROM	address, customer, workf
	WHERE	address.country IS NULL
		    AND
		address.add_type != "s"
	    	    AND
		address.cust_no = customer.cust_no
		    AND
		customer.phone_no IS NOT NULL
		    AND
		customer.cust_no = workf.cust_no
		    AND
# assume that numbers in workf.tbl correspond to lists printed in
# output of "bigmail.4gl" - perhaps a dubious assumption
		(workf.tbl < 7
		    AND
		 workf.tbl > 0)

	ORDER BY
		workf.tbl, address.state, customer.cust_no

	START REPORT mail_list

	FOREACH curs INTO addr.*, cust.*, work.*
		OUTPUT TO REPORT mail_list(cust.*, addr.*, work.*)
	END FOREACH

	FINISH REPORT mail_list

	CLOSE curs
END MAIN

REPORT mail_list(cust, addr, work)
	DEFINE  cust RECORD LIKE customer.*
	DEFINE  addr RECORD LIKE address.*
	DEFINE	work RECORD LIKE workf.*

	OUTPUT
		REPORT TO "mail2.cm"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0

	FORMAT

	ON EVERY ROW
		PRINT	cust.contact CLIPPED, " ",
			cust.phone_no CLIPPED, " ",
			addr.state CLIPPED, " ", cust.cust_no
		PRINT
		PRINT
END REPORT

