/* RWDOCS */
/* filename	: global.h
 * purpose	: global definitions
 */

#if	defined(__STDC__)
#define	ANSIPROTO	1
#endif

#ifdef COH42
#define COH386
#define COH
#define UNIX
#define SYS5
#endif

/* COHPROF turns on the profiler compiling. This is a custom profiler
 * and it requires that the mz device driver - with lbolt reading -
 * be installed in the kernel. The output goes to file ./prof.out.
 * prof.out file can be interpreted by profdump. To turn off profiling
 * comment out the definition here. You can also specify profiling
 * in only certain modules by defining COHPROF in those modules.
 */
#undef COHPROF

#ifdef COH386
#undef NULL
void free();
#endif

#define	INTERRUPT	void
#define ETHER

/* Global definitions used by every source file.
 * Some may be compiler dependent.
 */

#ifndef COH42
#define index strchr
#define rindex strrchr
#endif

/* Indexes into binmode in files.c; hook for compilers that have special
 * open modes for binary files
 */
#define	READ_BINARY	0
#define	WRITE_BINARY	1
#define APPEND_BINARY   2
extern char *binmode[];

/* not all compilers grok defined() */
#ifdef NODEFINED
#define defined(x) (x)
#endif

/* These two lines assume that your compiler's longs are 32 bits and
 * shorts are 16 bits. It is already assumed that chars are 8 bits,
 * but it doesn't matter if they're signed or unsigned.
 */
typedef unsigned int int32;		/* 32-bit unsigned integer */
typedef unsigned short int16;		/* 16-bit unsigned integer */
#define	uchar(x) ((unsigned char)(x & 255))
#define	MAXINT16 (int16)65535L		/* Largest 16-bit integer */

/* Since not all compilers support structure assignment, the ASSIGN()
 * macro is used. This controls how it's actually implemented.
 */
#ifdef	NOSTRUCTASSIGN	/* Version for old compilers that don't support it */
#define	ASSIGN(a,b)	memcpy((char *)&(a),(char *)&(b),sizeof(b));
#else			/* Version for compilers that do */
#define	ASSIGN(a,b)	((a) = (b))
#endif

/* Define null object pointer in case stdio.h isn't included */
#ifndef	NULL
/* General purpose NULL pointer */
#define NULL 0
#endif

#define	NULLCHAR (char *)0	/* Null character pointer */
#define	NULLFP	 (int (*)())0	/* Null pointer to function returning int */
#define	NULLVFP	 (void (*)())0	/* Null pointer to function returning void */
#define	NULLFILE (FILE *)0	/* Null file pointer */

/* General purpose function macros */
#define	min(x,y)	((x)<(y)?(x):(y))	/* Lesser of two args */
#define	max(x,y)	((x)>(y)?(x):(y))	/* Greater of two args */

/* Convert an address to a LONG value for printing */
#define ptr2long(x)	((unsigned long) (x))	/* typecast suffices for others */


/* Extract a short from a long */
/* According to my docs, this bug is fixed in MWC 3.0. (from 3.0.6 release
   notes.) -- hyc */

#define hiword(n)	(((int16)((n) >> 16)) & 0xffff)
#define	loword(n)	(((int16)(n)) & 0xffff)

/* Extract a byte from a short */
#define	hibyte(n)	(((n) >> 8) & 0xff)
#define	lobyte(n)	((n) & 0xff)

/* Extract nibbles from a byte */
#define	hinibble(n)	(((n) >> 4) & 0xf)
#define	lonibble(n)	((n) & 0xf)


char *malloc(),*calloc(),*ctime(),*tmpnam();

/* a quick, non-checking free() function as a macro */
#ifdef QFREE
#define free(p)		((char *) (p))[-1] |= 1;
#endif


/* RWDOCE */
/* end of global.h */
