/*
 * A clist structure is the head
 * of a linked list queue of characters.
 * The characters are stored in 16-word
 * blocks containing a link and 60 characters.
 * The routines getc and putc (machine code assists)
 * manipulate these structures.
 */
struct clist
{
	int	c_cc;		/* character count */
	int	c_cf;		/* pointer to first block */
	int	c_cl;		/* pointer to last block */
};

/*
 * The actual structure of a clist block manipulated by
 * getc and putc (mch.s)
 */
struct cblock {
	struct cblock *c_next;
	char info[NINFO];
};

/*
 * A tty structure is needed for
 * each UNIX character device that
 * is used for normal terminal IO.
 * The routines in tty.c handle the
 * common code associated with
 * these structures.
 * The definition and device dependent
 * code is in each driver. (trm.c)
 */
struct tty
{
	struct	clist t_rawq;	/* input chars right off device */
	struct	clist t_canq;	/* input chars after erase and kill */
	struct	clist t_outq;	/* output list to device */
	struct	buf *t_ibp;	/* input buffer */
	struct	buf *t_obp;	/* output buffer */
	int	t_flags;	/* mode, settable by stty call */
	int	t_addr;		/* device address (register or startup fcn) */
	char	t_delct;	/* number of delimiters in raw q */
	char	t_col;		/* printing column of device */
	char	t_erase;	/* erase character */
	char	t_kill;		/* kill character */
	int	t_state;	/* internal state, not visible externally */
	int	t_speeds;	/* output+input line speed */
	int	t_dev;		/* device name (major/minor) */
	int	t_devaddr;	/* device address */
	int	t_il;		/* requested input length */
	int	t_wresid;	/* residual write count */
	char	t_sense;	/* sense info */
	char	t_char;		/* character temporary */
};

extern char partab[];		/* ASCII table: parity, character class */

#define	TTIPRI	10
#define	TTOPRI	20

#define CERASE  010		/* backspace */
#define	CEOT	017		/* control O */
#define	CKILL	'@'
#define	CQUIT	034		/* FS, cntl shift L */
#define CESC	033
#define CINTR	003		/* control C - interrupt */
#define CDLM	0377
#define PADCHAR #fb		/* 270X quiet line character(reversed)*/

/* limits */
#define	TTHIWAT	512
#define	TTYHOG	1024

/* modes */
#define	HUPCL	01
#define	XTABS	02
#define	LCASE	04
#define	ECHO	010
#define	CRMOD	020
#define	RAW	040
#define	ODDP	0100
#define	EVENP	0200
#define	NLDELAY	001400
#define	TBDELAY	006000
#define	CRDELAY	030000
#define	VTDELAY	040000
