#
#include	"../manifest.h"
#include	"../param.h"
#include	"../systm.h"
#include	"../user.h"

/*
 * The following constant refers to the number of words which the
 * stack is dropped by the compiler when the routine is entered.
 * We must know this in order to compute the addresses of registers
 * 2 through 12, which are cleared by the exec system call.
 */
#define	DROPSIZE	20
#define	PGMTRAP	0100000		/* x'8000' */
#define	CC	030000	/* condition code bits in ec psw */
#define	PGMCODE	140	/* location of program interrupt code */
#define	SVCCODE	136	/* location of svc interrupt code */
#define	USER	0200000	/* user mode bit in ec psw */

 /* structure of the system entry table (sysent.c)
 */
extern struct sysent	{
	int	count;		/* argument count */
	int	(*call)();	/* name of handler */
} sysent[64];

trap(rsp,r14,r15,r0,r1,ps,pc)
{
	int i,ar1;
	struct sysent *callp;

	if((ps&USER) == 0) {
		printf("arsp = %x\n",&rsp);
		printf("pgmcode = %x\n",PGMCODE->integ);
		printf("psw = %x%x\n",ps,pc);
		panic("trap");
	}

	u->u_arsp = &rsp;
	u->u_orega = (&rsp) - DROPSIZE;	/* point at saved regs, so 
					   exec can clear them */

	if((ps&PGMTRAP) == 0) {	/* svc */
		ps =& ~CC;
		callp = &sysent[(SVCCODE)->integ & 077];
		ar1 = r1;
		for(i = 0; i<callp->count; i++) {
			u->u_arg[i] = fuword(ar1);
			ar1 =+ 4;
		}
		u->u_dirp = u->u_arg[0];
		u->u_error = 0;
		trap1(callp->call);
		if(u->u_intflg)
			u->u_error = EINTR;
		if(u->u_error) {
			if(u->u_error >= 100) {
				i = SIGSYS;
				goto signal;
			}
			ps =| CC;	/* set overflow cc */
			r0 = u->u_error;	/* remember that the 360 doesnt extend the sign */
		}
	} else {
				/* program check */
		i = PGMCODE->integ & 037;
		if(i == 16 || i == 17) {
			grow(rsp);
			goto out;
		}
		i =+ SIGPGM-1;
	signal:
		psignal(u->u_procp,i);
	}

out:
	if(issig())
		psig();
	setpri(u->u_procp);
}

trap1(f)
int (*f)();
{
	u->u_intflg = 1;
	savu(u->u_qsav);
	(*f)();
	u->u_intflg = 0;
}

nosys()
{
	u->u_error = 100;
}

nullsys()
{
}
