#
#include	"../filsys.h"
#include	"../ino.h"
 
#define	BLKSIZE	512	/* bytes */
#define	BLKSIZEW	(BLKSIZE/4)
#define	DIRENTSZ	16
#define	DIRSIZ		14
#define MAXF_N		200

struct filsys filsys;
 
struct minode
{
	int i_number;
	struct inode inoed;
};

fortran bio(),blkrd(),blkwrt(),indir(),filsiz(); 

extern	cin;
extern urnleft;
extern	char etatab[];
char	*charp;
int	buf[BLKSIZEW];
char	string[50];
char	*fsys;
char	*proto;
int	diskaddr;
/*
 * for 3340's...
 */
int	f_n	144;
int	f_m	3;
int	f_l	12;  /* blocks per track */

main(argc, argv)
char **argv;
{
	int f, n;

	/*
	 * open relevent files
	 */

	if(argc != 3) {
		printf("arg count\n");
		cexit(12);
	}
	fsys = argv[1];
	proto = argv[2];
	scanf(-1,fsys,"%x",&diskaddr);
	/* initialize disk routine */
	if (bio(diskaddr)) {
		printf("BIO error\n");
		cexit(12);
	}
	cin = copen(proto,'r');
	if(cin < 0)  {
		n = 0;
		for (f=0; proto[f]; f++) {
			if (proto[f]<'0' || proto[f]>'9') {
				printf("%s: cannoot open\n",proto);
				cexit(12);
			}
			n = n*10 + proto[f]-'0';
		}
		filsys.s_fsize = n;
		filsys.s_isize = n/(43+n/1000)<<1;
		printf("isize = %d\n",filsys.s_isize);
		if (f_n != 1)
			printf("free list %d/%d\n", f_m, f_n);
		charp = "d--777 0 0 $ ";
		goto f3;
	}

	/*
	 * get name of file
	 * and read onto block 0
	 */

	getstr();
	f = copen(string,'r');
	if (f<0) {
		printf("%s: cannot open block 0 file\n",string);
		goto f2;
	}
	for (n=0; n<BLKSIZEW; n++)
		buf[n] = 0;
	uread(f,buf,BLKSIZE);
	wtfs(0,buf);

f1:
	cclose(f);

	/*
	 * get total disk size
	 * and inode block size
	 */

f2:
	filsys.s_fsize = getnum();
	filsys.s_isize = getnum();

f3:
	if(filsys.s_isize > filsys.s_fsize ||
	   filsys.s_fsize-filsys.s_isize-2 < filsys.s_isize) {
		printf("%d/%d: bad ratio\n", filsys.s_fsize, filsys.s_isize);
		cexit(12);
	}
	/*
	 * initialize block free list 
	 */
	bflist();

	/*
	 * initialize files
	 */

	for(n=0; n<BLKSIZEW; n++)
		buf[n] = 0;
	for(n=0; n<filsys.s_isize; n++)
		wtfs(n+2, buf);
	/*
	 * creat the files...
	 */

	cfile(0);

	/*
	 * write out super block
	 */

	/* unused fields should be zero in superblock */
	wtfs(1, &filsys);
}

cfile(par)
struct minode *par;
{
	struct minode in;
	int db[BLKSIZEW], ib[BLKSIZEW];
	int dbc, ibc;
	static ino;
	int i, tmp, f, *p1, *p2;

	/*
	 * get mode, uid and gid
	 */

	getstr();
	/*
	 * zero inode (so it is pretty on disk)
	 */

	p1 = &in.inoed;
	for (i=0; i<ISIZEW; i++)
		*p1++ = 0;

	in.inoed.i_mode = IALLOC;
	in.inoed.i_mode =| gmode(string[0], "bcd", IFBLK, IFCHR, IFDIR);
	in.inoed.i_mode =| gmode(string[1], "u", ISUID);
	in.inoed.i_mode =| gmode(string[2], "g", ISGID);
	for(i=3; i<6; i++) {
		if(string[i]<'0' || string[i]>'7') {
			printf("%c/%s: bad digit\n", string[i], string);
			cexit(12);
		}
		in.inoed.i_mode =| (string[i]-'0')<<(15-3*i);
	}
	in.inoed.i_uid = getnum();
	in.inoed.i_gid = getnum();

	/*
	 * general initialization prior to
	 * switching on format
	 */

	in.i_number = ++ino;
	if (ino/IPERBLK > filsys.s_isize) {
		printf("too many inodes\n");
		cexit(12);
	}
	in.inoed.i_nlink = 1;
	in.inoed.i_size = 0;
	for(i=0; i<IADDRSIZ; i++)
		in.inoed.i_addr[i] = 0;
	for(i=0; i<BLKSIZEW; i++) {
		db[i] = 0;
		ib[i] = 0;
	}
	if(par == 0) {
		par = &in;
		in.inoed.i_nlink--;
	}
	dbc = 0;
	ibc = 0;
	switch(in.inoed.i_mode&IFMT) {

	case 0:
		/*
		 * regular file
		 * contents is a file name
		 */

		getstr();
		f = copen(string,'r');
		if(f < 0) {
			printf("%s: cannot open\n", string);
			break;
		}
		/*
		 * kludge for poorly written cread routine...
		 *  (also need to blank pad the string...)
		 * I know the code is not the most elegant, but better clear && 
		 *   a little slower, than too fast for my brain given the hour
		 */

		for (i=1; i<7; i++) {
			if (string[i]==0) string[i] = ' ';
			if (string[i]==' ') string[i+1] = ' ';
		}
		tmp = indir(filsiz,string);
		urnleft = 0; /* flush the buffer */

		while((i=uread(f, db, BLKSIZE))  > 0) {

			in.inoed.i_size =+ i;
			newblk(&dbc, db, &ibc, ib);
			if (in.inoed.i_size >= tmp) break;
		}
		cclose(f);
		in.inoed.i_size = tmp;
		break;

	case IFBLK:
	case IFCHR:
		/*
		 * special file
		 * content is maj/min types
		 */

		in.inoed.i_addr[0] = getnum()<<8;
		in.inoed.i_addr[0] =| getnum();
		break;

	case IFDIR:
		/*
		 * directory
		 * put in extra links
		 * call recursively until
		 * name of "$" found
		 */

		par->inoed.i_nlink++;
		direntry(par->i_number, "..", &dbc, db, &ibc, ib);
		in.inoed.i_nlink++;
		direntry(in.i_number, ".", &dbc, db, &ibc, ib);
		in.inoed.i_size = DIRENTSZ<<1;
		for(;;) {
			getstr();
			if(string[0]=='$' && string[1]=='\0')
				break;
			direntry(ino+1, string, &dbc, db, &ibc, ib);
			in.inoed.i_size =+ DIRENTSZ;
			cfile(&in);
		}
		break;
	}
	if(dbc != 0)
		newblk(&dbc, db, &ibc, ib);
	if(ibc > IADDRSIZ) {
		in.inoed.i_mode =| ILARG;
		dbc = alloc();
		wtfs(dbc, ib);
		in.inoed.i_addr[0] = dbc;
	} else
	for(i=0; i<ibc; i++)
		in.inoed.i_addr[i] = ib[i];
	i = in.i_number + IOFFSET;
	dbc = i / IPERBLK;
	p1 = &buf[(i%IPERBLK)*ISIZEW];
	p2 = &in.inoed;
	rdfs(dbc, buf);
	for(i=0; i<ISIZEW; i++)
		*p1++ = *p2++;
	wtfs(dbc, buf);
}

gmode(c, s, m0, m1, m2, m3)
char c, *s;
{
	int i;

	for(i=0; s[i]!='\0'; i++)
		if(c == s[i])
			return((&m0)[i]);
	if(c == '-')
		return(0);
	printf("%c/%s: bad mode\n", c, string);
	cexit(12);
}

getnum()
{
	int n, i;

	getstr();
	n = 0;
	i = 0;
	for(i=0; string[i]!='\0'; i++) {
		if(string[i]<'0' || string[i]>'9') {
			printf("%s: bad number\n", string);
			cexit(12);
		}
		n = n*10 + string[i] - '0';
	}
	return(n);
}

getstr()
{
	int i, c;

loop:
	switch(c=getch()) {

	case ' ':
	case '\t':
	case '\n':
		goto loop;

	case '\0':
		printf("EOF\n");
		cexit(12);

	case ':':
		while(getch() != '\n');
		goto loop;

	}
	i = 0;

	do {
		string[i++] = c;
		c = getch();
	} while(c!=' '&&c!='\t'&&c!='\n'&&c!='\0');
	string[i] = '\0';
}

rdfs(bno,bf)
{
	indir(blkrd,bf,bno);
}

wtfs(bno, bf)
{
	indir(blkwrt,bf,bno);
}

alloc()
{
	int bno, i;

	filsys.s_nfree--;
	bno = filsys.s_free[filsys.s_nfree];
	filsys.s_free[filsys.s_nfree] = 0;
	if(bno == 0) {
		printf("out of free space\n");
		cexit(12);
	}
	if(filsys.s_nfree <= 0) {
		rdfs(bno, buf);
		filsys.s_nfree = buf[0];
		for(i=0; i<SFREESIZ; i++)
			filsys.s_free[i] = buf[i+1];
	}
	return(bno);
}

free(bno)
{
	int i;

	if(filsys.s_nfree >= SFREESIZ) {
		buf[0] = filsys.s_nfree;
		for(i=0; i<SFREESIZ; i++)
			buf[i+1] = filsys.s_free[i];
		wtfs(bno, buf);
		filsys.s_nfree = 0;
	}
	filsys.s_free[filsys.s_nfree] = bno;
	filsys.s_nfree++;
}

direntry(ino, str, adbc, db, aibc, ib)
char *str;
int *adbc, *db, *aibc, *ib;
{
	char *s;
	int i;

	s = &db[*adbc];
	strhalf(s,ino);
	s =+ 2;  /* skip halfword inode number... */
	for(i=0; i<DIRSIZ; i++) {
		*s++ = etatab[*str];
		if(*str != '\0')
			str++;
	}
	*adbc =+ DIRENTSZ/sizeof *db;
	if(*adbc >= BLKSIZEW)
		newblk(adbc, db, aibc, ib);
}

strhalf(target,source)
char *target;
{
	struct {
		char z_fill1,z_fill2;
		char highbyte,lowbyte;
	};

	target[0] = source.highbyte;
	target[1] = source.lowbyte;
}

newblk(adbc, db, aibc, ib)
int *adbc, *db, *aibc, *ib;
{
	int bno, i;

	bno = alloc();
	wtfs(bno, db);
	for(i=0; i<BLKSIZEW; i++)
		db[i] = 0;
	*adbc = 0;
	ib[*aibc] = bno;
	(*aibc)++;
	if(*aibc >= BLKSIZEW) {
		printf("indirect block full\n");
		cexit(12);
	}
}

getch()
{

	if(charp)
		return(*charp++);
	return(getchar());
}

bflist()
{
	char flg[MAXF_N], adr[MAXF_N];
	register i, j;
	char *low, *high;

	if(f_n > MAXF_N)
		f_n = MAXF_N;
	for(i=0; i<f_n; i++)
		flg[i] = 0;
	i = 0;
	for(j=0; j<f_n; j++) {
		while(flg[i])
			i = (i+1)%f_n;
		adr[j] = i;
		flg[i]++;
		i = (i+f_m)%f_n;
	}

	high = filsys.s_fsize-1;
	low = filsys.s_isize+2;
	/*
	 * mark end of list of free blocks
	 */
	free(0);
	/* add f_l to account for missing track */
	for(i=high; (i+f_l+1)%f_n; i--) {
		if(i < low)
			break;
		free(i);
	}
	for(; i >= low+f_n; i =- f_n)
		for(j=0; j<f_n; j++)
			free(i-adr[j]);
	for(;i >= low; i--)
		free(i);
}
