/*
 * Inode structure as it appears on
 * the disk. Not used by the system,
 * but by things like check, df, dump.
 */
 /* inode is actually now 64 bytes long on 370 */
#define	ISIZE	64
#define	ISIZEW	(ISIZE/4)
#define	IPERBLK	(BLKSIZE/ISIZE)
#define	IOFFSET	(2*IPERBLK-1)
#define	IADDRSIZ	8
#define	ISPARESZ	3

struct	inode
{
	int	i_mode;
	char	i_nlink;
	char	i_uid;
	char	i_gid;
 /*	char	i_size0;
	char	*i_size1;
 */
	char	i_fil;
	int	i_size;
	int	i_addr[IADDRSIZ];
 /*	int	i_atime[2];
	int	i_mtime[2];
 */
	int	i_atimei;
	int	i_mtimei;
	int	i_spare[ISPARESZ];
};

/* modes */
#define	IALLOC	0100000
#define	IFMT	060000
#define		IFDIR	040000
#define		IFCHR	020000
#define		IFBLK	060000
#define	ILARG	010000
#define	ISUID	04000
#define	ISGID	02000
#define ISVTX	01000
#define	IREAD	0400
#define	IWRITE	0200
#define	IEXEC	0100
