#
/* C compiler    ( file - c02.c )

Copyright 1972 Bell Telephone Laboratories, Inc.

*/

#include "c0h.c"

/*  */
extdef() {
	register o, width;
	int type, elsize, nel;
	char *cs;
	register struct hshtab *ds;

	if(((o=symbol())==EOF) || o==SEMI)
		return;
	type = 0;
	xdflg++;
	xtern = NO;
	ftern = NO;
    xxx:
	if (o==KEYW) {
		if (cval==EXTERN) {
			xtern = YES;
			o = symbol();
			goto xxx;
		}
		if (cval==FORTRAN) {
			ftern = YES;
			o = symbol();
			goto xxx;
		}
		if ((type=cval)>STRUCT)
			goto syntax;	/* not type */
		elsize = 0;
		if (type==STRUCT) {
			elsize = strdec(&type, 0);
			if ((peeksym=symbol())!=KEYW)
{
				blkhed();
}
		}
	} else {
		if (o!=NAME)
			goto syntax;
		peeksym = o;
	}
	do {
		defsym = 0;
		strflg = 1;
		endp = YES;
		decl1(xtern==YES?GXTERN:(ftern==YES?FORTRAN:EXTERN), type&07, 0, elsize, NO);
		/* (this also sets ndp) */
		if ((ds=defsym)==0)
			return;
		cs = ds->name;
		funcsym = ds;
		ds -> hflags =| GLOBAL;	/*  flag global  */
		xdflg = 0;
		type = ds->type;
		if ((type&030)==FUNC && ((peeksym=symbol())==LBRACE
		   || peeksym==KEYW)) {
			mainchk(cs);  /* add extra BAL code for main functions. */
			ds -> hflags =| DEFINED;	/*  set defined flag.  */
			ds->hflags =| PERM;   /* nondeletable  */
			cfunc(cs, ndp);	/*  This is the only call of cfunc.  */
			return;
		}
		if ((xtern == NO)&&(ftern == NO)) ds->hflags =| DEFINED;
		ds->hflags =| PERM;		/* non-deletable */
		nel = 1;
		while ((ds->type&030)==ARRAY) {
			nel = dimtab[ds->ssp];
			ds->type = decref(ds->type);
		}
		width = length(ds);
		if (ds->type==STRUCT) {
			nel = nel * width/4;
			width = 4;
		}
		ds->type = type;
		cinit(cs, type, nel, width);
		hgprloc(hgcode);
	} while ((o=symbol())==COMMA);
	if (o==SEMI)
		return;
syntax:
	if (o == RBRACE) {
		error("Too many }'s");
		return;
	}
	error("External definition syntax");
	errflush(o);
	statement(0);
}

cfunc(cs, np)	/*  Compile a function.  */
char *cs;
int np;
{
	register savdimp;

	regvar = 1;
	strflg = 0;
	function = YES;
	savdimp = dimp;
	declist(ARG);
	retlab = isn++;
	statement(1, cs);
	printf("$%d	EPILOG	%d,%d\n", retlab, np, autolen);
	/* autolen contains the total length of the automatics and temps */
	printf("	DC	C'END %.8s' \n", cs);
	dimp = savdimp;
}

cinit(cs, type, nel, awidth)
char *cs;
{
	register o, ninit, width;

	hgprloc(hgdata);
	width = awidth;
	if ((peeksym=symbol())==COMMA || peeksym==SEMI) {
		if (xtern == NO && ftern == NO)  {
			printf("%.8s	dc	%dx'00' \n", cs, (nel*width+3)&~03);
		}	/* Allocate storage only in multiples of four bytes. */
		return;
	}
	ninit = 0;
	if (xtern == YES)  error("Can not initialize externals.");
	if(width==8 || width==4)
	printf("	cnop	0,%d\n",width);
	printf("%.8s	equ	* \n", cs);
	if ((o=symbol())==LBRACE) {
		do
			ninit = cinit1( width, ninit);
		while ((o=symbol())==COMMA);
		if (o!=RBRACE)
			peeksym = o;
	} else {
		peeksym = o;
		ninit = cinit1( width, 0);
	}
	if (ninit<nel)
		printf("	dc	%dx'00' \n", (nel-ninit)*width);
	else
		nel = ninit;
	if (nel>1 && (type&030)!=ARRAY && (type&07)!=STRUCT)
		error("Too many initializers");
		printf("	cnop	0,4 \n");
}

cinit1( width, ninit)
{
	register struct tnode *s;
	register int sign;

	sign = 1;

	if ((peeksym=symbol())==STRING ) {
		peeksym = -1;
		if( width == 4 ){
			hgprloc( hgistring );
			getstr();
			hgprloc( hgdata );
			printf( "	dc	a($%d)\n", cval );
			return(1);
			}
		getstr();
		return(nchstr);
	}
	if (peeksym==RBRACE)
		return(ninit);
	initflg++;
	s = tree();
	hgprloc(hgdata);
	initflg = 0;
	switch(width) {

	case 1:
		rcexpr0(block(1,INIB,0,0,s), regtab);
		break;
	case 4:
		if (s->op != FCON) {
			rcexpr0(block(1,INIT,0,0,s), regtab);
			break;
		}
	case 8:
		if (s->op==FCON) {
			if(peeksym==MINUS) {
				peeksym = -1; sign = -sign;}
			prtflo(sign,width); break;
			}


	default:
		bxdec();

	}
	return(++ninit);
}

bxdec()
{
	error("Inconsistent external initialization");
}

statement(d, cs)
	char *cs;
{
	register o, o1, o2;
	int o3;
	struct tnode *np;


stmt:
	switch(o=symbol()) {

	case EOF:
		error("Unexpected EOF");
	case SEMI:
		return;

	case LBRACE:
		if(d) {
			if (proflg)   error("The profiler is not supported on IBM C.");
			hgprloc(hgcode);
			printf("%.8s	PROLOG	%d \n", cs, ndp);
			blkhed();
		}
		while (!eof) {
			if ((o=symbol())==RBRACE)
				return;
			peeksym = o;
			statement(0);
		}
		error("Missing '}'");
		return;

	case KEYW:
		switch(cval) {

		case GOTO:
			if (o1 = simplegoto())
				branch(o1);
			else
				dogoto();
			goto semi;

		case ASM:

			if(doasm()<0) goto syntax;
			goto semi;


		case RETURN:
			doret();
			goto semi;

		case IF:
			np = pexpr();
			o2 = 0;
			if ((o1=symbol())==KEYW) switch (cval) {
			case GOTO:
				if (o2=simplegoto())
					goto simpif;
				cbrnch0(np, o2=isn++, 0);
				dogoto();
				label(o2);
				goto hardif;

			case RETURN:
				if (nextchar()==';') {
					o2 = retlab;
					goto simpif;
				}
				cbrnch0(np, o1=isn++, 0);
				doret();
				label(o1);
				o2++;
				goto hardif;

			case BREAK:
				o2 = brklab;
				goto simpif;

			case CONTIN:
				o2 = contlab;
			simpif:
				chconbrk(o2);
				cbrnch0(np, o2, 1);
			hardif:
				if ((o=symbol())!=SEMI)
					goto syntax;
				if ((o1=symbol())==KEYW && cval==ELSE)
					goto stmt;
				peeksym = o1;
				return;
			}
			peeksym = o1;
			cbrnch0(np, o1=isn++, 0);
			statement(0);
			if ((o=symbol())==KEYW && cval==ELSE) {
				o2 = isn++;
				branch(o2);
				label(o1);
				statement(0);
				label(o2);
				return;
			}
			peeksym = o;
			label(o1);
			return;

		case WHILE:
			o1 = contlab;
			o2 = brklab;
			label(contlab = isn++);
			cbrnch0(pexpr(), brklab=isn++, 0);
			statement(0);
			branch(contlab);
			label(brklab);
			contlab = o1;
			brklab = o2;
			return;

		case BREAK:
			chconbrk(brklab);
			branch(brklab);
			goto semi;

		case CONTIN:
			chconbrk(contlab);
			branch(contlab);
			goto semi;

		case DO:
			o1 = contlab;
			o2 = brklab;
			contlab = isn++;
			brklab = isn++;
			label(o3 = isn++);
			statement(0);
			label(contlab);
			contlab = o1;
			if ((o=symbol())==KEYW && cval==WHILE) {
				cbrnch0(tree(), o3, 1);
				label(brklab);
				brklab = o2;
				goto semi;
			}
			goto syntax;

		case CASE:
			o1 = conexp();
			if ((o=symbol())!=COLON)
				goto syntax;
			if (swp==0) {
				error("Case not in switch");
				goto stmt;
			}
			if(swp>=swtab+swsiz) {
				error("Switch table overflow");
			} else {
				swp->swlab = isn;
				(swp++)->swval = o1;
				label(isn++);
			}
			goto stmt;

		case SWITCH:
			o1 = brklab;
			brklab = isn++;
			np = pexpr();
			chkw(np);
			rcexpr0(block(1,RFORCE,0,0,np), regtab);
			pswtch0();
			brklab = o1;
			return;

		case DEFAULT:
			if (swp==0)
				error("Default not in switch");
			if ((o=symbol())!=COLON)
				goto syntax;
			label(deflab = isn++);
			goto stmt;

		case FOR:
			o1 = contlab;
			o2 = brklab;
			contlab = isn++;
			brklab = isn++;
			if (o=forstmt())
				goto syntax;
			label(brklab);
			contlab = o1;
			brklab = o2;
			return;
		}

		error("Unknown keyword = %o",cval);
		goto syntax;

	case NAME:
		if (nextchar()==':') {
			peekc = 0;
			o1 = csym;
			if (o1->hclass>0) {
				error("Redefinition");
				goto stmt;
			}
			o1->hclass = STATIC;
			o1->htype = ARRAY;
			if (o1->hoffset==0)
				o1->hoffset = isn++;
			label(o1->hoffset);
			if ((peeksym=symbol())==RBRACE)
				return;
			goto stmt;
		}
	}

	peeksym = o;
	rcexpr0(tree(), efftab);

semi:
	if ((o=symbol())==SEMI)
		return;
syntax:
	error("Statement syntax");
	errflush(o);
	return;
}

blkhed()
{
	register pl;
	register struct hshtab *cs;

	autolen = hgreglen + ndp*4;	/* Save 16 registers and declared parameters. */
	declist(0);
	pl = 0;
	while(paraml) {
		parame->hoffset = 0;
		cs = paraml;
		paraml = paraml->hoffset;
		if (cs->htype==FLOAT)
			cs->htype = DOUBLE;
		cs->hoffset = pl;
		cs->hclass = AUTO;
		if ((cs->htype&030) == ARRAY) {
			cs->htype =- 020;	/* set ptr */
			cs->ssp++;		/* pop dims */
		}
		if (cs->htype == CHAR)
			cs->htype = INT;
		pl =+ rlength(cs);
	}
	for (cs=hshtab; cs<hshtab+hshsiz; cs++) {
		if (cs->name[0] == '\0')
			continue;
		/* check tagged structure */
		if (cs->hclass>KEYWC && (cs->htype&07)==RSTRUCT) {
			cs->lenp = dimtab[cs->lenp]->lenp;
			cs->htype = cs->htype&~07 | STRUCT;
		}
		if (cs->hclass == STRTAG && dimtab[cs->lenp]==0)
			error("Undefined structure: %.8s", cs->name);
		if (cs->hclass == ARG)
			error("Not an argument: %.8s", cs->name);
	}
	osleft = ossiz;
	space = treebase;
	return(autolen);
}

blkend() {
	register struct hshtab *cs;

	for (cs=hshtab; cs<hshtab+hshsiz; cs++) {
		if (cs->name[0]) {
			if ((cs->hflags & DELETED) == 0) {
				if (cs->hclass==0)
					error("%.8s undefined", cs->name);
				if((cs->hflags&PERM)==0) {
					cs->hflags =| DELETED;	/* delete nonglobal items from the symbol table. */
					hshused--;
				}
			}
		}
	}
}

errflush(ao)
{
	register o;

	o = ao;
	while(o>RBRACE)	/* ; { } */
		o = symbol();
	peeksym  = o;
}

declist(skwd)
{
	int o, elsize, ndec;
	register offset, tkw, skw;

	offset = 0;
loop:
	ndec = 0;
	tkw = -1;
	skw = skwd;
	elsize = 0;
	while ((o=symbol())==KEYW)
		switch(cval) {
	case AUTO:
	case STATIC:
	case EXTERN:
	case GXTERN:
	case FORTRAN:
	case REG:
		if (skw)
			error("Conflict in storage class");
		skw = cval;
		ndec++;
		if (tkw<0)
			continue;
		goto list;

	case STRUCT:
		o = cval;
		elsize = strdec(&o, skw==MOS);
		cval = o;
	case INT:
	case CHAR:
	case FLOAT:
	case DOUBLE:
		ndec++;
		if (tkw>=0)
			error("Type clash");
		tkw = cval;
		if (skw==0)
			continue;
		goto list;

	default:
		goto brk1;
	}
  brk1:
	peeksym = o;
	if (ndec==0)
		return(offset);
list:
	if (tkw<0)
		tkw = INT;
	if (skw==0)
		skw = AUTO;
	offset = declare(skw, tkw, offset, elsize);
	goto loop;
}

strdec(tkwp, mosf)
int *tkwp;
{
	register elsize, o;
	register struct hshtab *ssym;
	struct hshtab *ds;

	mosflg = 1;
	ssym = 0;
	if ((o=symbol())==NAME) {
		ssym = csym;
		if (ssym->hclass==0) {
			ssym->hclass = STRTAG;
			ssym->lenp = dimp;
			dimtab[dimp++] = 0;
		}
		if (ssym->hclass != STRTAG)
			redec();
		mosflg = mosf;
		o = symbol();
	}
	mosflg = 0;
	if (o != LBRACE) {
		if (ssym==0) {
		syntax:
			decsyn(o);
			return(0);
		}
		if (ssym->hclass!=STRTAG)
			error("Bad structure name");
		if ((elsize = dimtab[ssym->lenp])==0) {
			*tkwp = RSTRUCT;
			elsize = ssym;
		}
		peeksym = o;
	} else {
		ds = defsym;
		mosflg = 0;
		elsize = declist(MOS);
		elsize = (elsize+03) & ~03;	/* round to multiple of 4. */
		defsym = ds;
		if ((o = symbol()) != RBRACE)
			goto syntax;
		if (ssym) {
			if (dimtab[ssym->lenp])
				error("%.8s redeclared", ssym->name);
			dimtab[ssym->lenp] = elsize;
		}
	}
	return(elsize);
}


prtflo(sign,init)   /*print floating point value */

	{
	/* sign is +1 for +, -1 for -  */
	/* init is 0 for execution constants, non-zero for initialization: */
	/* 4 for single precision, 8 for double precision */

	if (!init) hgprloc(hgdata);
	printf("$%d	dc	",cval=isn++);
	if (init == hgfloatsz)  /*  double precision  */
		printf("d'");
	else  /*  single precision  */
		printf("d'");
	if(sign<0) printf("-");
	printf(fcval,'e');
	printf("'\n");
	if (!init) hgprloc(hgcode);
	}
