/*
 * WAT - Write A Tape.
 * Small tool found with the Ultrix-11 V3inary kit in the PUPS
 * archive.  Basically, grabs the data generated by the RAT tool,
 * and writes a tape accordlingly.
 *
 * I only added stuff and cleaned up the code so it would run on the
 * PDP-11 again.  --Fred van Kempen 2001/03/04.
 */
#include <stdio.h>

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>
#include <sys/dir.h>

#define TAPE "/dev/rtk0"

main (argc,argv)
  int argc ;
  char ** argv ;
{
	long int total = (long)0;
	register int fd, bytes ;
	int written;
	FILE * lfd, * dfd ;
	char * buffer ;
	char line[256] ;
	struct mtop mt_command;
	extern char * malloc() ;
	extern int errno;

	if ( argc != 3 )
	{
		fprintf (stderr,"Usage: %s log-file dump-file\n",argv[0]) ;
		exit (1) ;
	}

#ifdef pdp11
	buffer = malloc (20000) ;
	if (buffer == NULL) {
		fprintf(stderr, "wat: cant get buffer !\n");
		exit (1);
	}
#else
	buffer = malloc (65535) ;
#endif

	if ( ( fd = open (TAPE,1) ) < 0 )
	{
		fprintf (stderr,"%s: can't open tape unit %s\n",
			argv[0], TAPE) ;
		exit (1) ;
	}

	if ( ( lfd = fopen (argv[1],"r") ) == NULL )
	{
		perror (argv[1]) ;
		exit (1) ;
	}

	if ( ( dfd = fopen (argv[2],"r") ) == NULL )
	{
		perror (argv[2]) ;
		exit (1) ;
	}

	while ( fgets (line,sizeof(line),lfd) != NULL )
	{
		line[strlen(line) - 1] = '\0';
		if ( strncmp (line,"EOF",3) == 0 )
		{
			mt_command.mt_op = MTWEOF ;
			mt_command.mt_count = 1 ;

			if ( ioctl (fd,MTIOCTOP,&mt_command) != 0 )
				fprintf (stderr,"tape EOF problem?\n") ;

			fprintf (stderr,"\n end of file.\n") ;
		}
		else if ( strncmp (line,"EOT",3) == 0 )
		{
			fprintf (stderr,"End of Tape.\n") ;
			break ;
		}
		else
		{
			bytes = atoi (line) ;

			if ( bytes <= 0 || (bytes%512) != 0 )
			{
				fprintf (stderr,"bogus write line?\n") ;
				fprintf (stderr,">>> \"%s\"\n", line);
				break ;
			}

			if ( fread (buffer,1,bytes,dfd) != bytes )
			{
				fprintf (stderr,"bad read chunk?\n") ;
				break ;
			}

			if (( written = write (fd,buffer,bytes)) != bytes )
			{
				fprintf (stderr,"tape write error?\n") ;
				fprintf (stderr,"bytes %d written %d errno %d\n",
							bytes, written, errno);
				
				break ;
			}

			fprintf (stderr,".") ;
			total += (long)bytes;
		}
	}

	(void) close (fd) ;
	(void) fclose (lfd) ;
	(void) fclose (dfd) ;
	fprintf(stderr, "Total bytes written: %lu\n", total);
	exit (0) ;
}
