#
/* narc - new archiver for UNIX 
 *
 * J. N. Rottman
	small harvard changes by forrest howard
 */

#define	MAGIC	0177554
#define tmpfile	"NARC.TMP"
#define tmpmode 0400

char	*args[100];
int	acount;
char	*keylib;
int	libin;
int	tmpout;

struct	a_head	{
	char	a_name[14];
	int	a_mtime[2];
/*	char	a_uid;
	char	a_gid;*/
	int	a_uid;	/* a la harvard */
	int	a_mode;
	int	a_size[2];
} a_head;

struct	sbuff	{
	char	minor;
	char	major;
	int	inumber;
	int	flags;
	char	nlinks;
	char	uid;
	char	gid;
	char	size0;
	int	size1;
	int	addr[8];
	int	actime[2];
	int	modtime[2];
} sbuff;
/* recall that harvard uid is uid*256.!gid */

main(argc,argv)
int argc;
char *argv[];
{
	register int k,icount;
	register char keychar;
	extern	cntlexit();
	if(argc < 3)
		ferror("Bad file spec.");
	if (signal(2,&cntlexit) & 1) signal(2,1);
	keylib = argv[1];
	keychar = argv[2][1];
	icount = argc - 3;
	for(k=0;k<icount;k++)
		args[k] = argv[k+3];
	for(;;) {
		acount = icount;
		for(k=0;k<icount;k++)
			if(*args[k]=='-') {
				acount = k;
				break;
			}

		switch(keychar) {
		
		case 'd':	delete(); break; /* delete from lib */
		case 'r':	replace(); break;
		case 'm':	modify(); break;
		case 'i':	insert(); break;
		case 'x':	extract(); break;
		case 'a': 	append(); break;
		case 'l':	list(); break;
		default:	ferror("Invalid key-character.");

		}

		if(icount == acount)
			exit(0);
		keychar = args[acount][1];
		for(k=0;k<icount-acount-1;k++)
			args[k]=args[k+acount+1];
		icount =- (acount + 1);
	}
}

ferror(s)
char *s;
{
	printf("%s\n",s);
	unlink(tmpfile);
	exit(1);
}
cntlexit()
{
	unlink(tmpfile);
	exit();
}

openlib()
{
	int m;
	libin = open(keylib,0);
	if(libin == -1)
		ferror("Cannot open library.");
	read(libin,&m,2);
	if( m != MAGIC)
		ferror("Not archive.");
}

mktmp()
{
	unlink(tmpfile);
	tmpout = creat(tmpfile,tmpmode);
	if(tmpout == -1)
		ferror("Cannot create work file.");
}

getlib()
{
	return(read(libin,&a_head,26));
}

slew(file)
int file;
{
	extern int ldivr;
	int bcount,rcount;
	bcount = ldiv(a_head.a_size[0],a_head.a_size[1],512);
	rcount = (ldivr +1 ) & ~1;
/*	while(bcount--)
		seek(file,512,1);*/

	if (bcount) seek(file,bcount,4);
		/* 077777777>>9 is positive */

	seek(file,rcount,1);
}

trn(infile,outfile)
int infile,outfile;
{
	write(outfile,&a_head,26);
	mfile(infile,outfile,a_head.a_size);
}

mfile(infile,outfile,fsize)
int infile,outfile,fsize[];
{
	char	block[512];
	int	bcount,rcount;
	extern	int ldivr;

	bcount = ldiv(fsize[0], fsize[1], 512);
	rcount = (ldivr +1 ) & ~1;
	while(bcount--) {
		read(infile,block,512);
		write(outfile,block,512);
	}
	if(rcount != 0) {
		read(infile,block,rcount);
		write(outfile,block,rcount);
	}
}

rename()
{
	int	fsize[2];
	register int	olds;
	int	m;
	m = MAGIC;
	close(libin);
	close(tmpout);
	olds = signal(2,1);
	libin = creat(keylib,0644);
	if(libin == -1)
		ferror("Cannot rewrite library.");
	tmpout = open(tmpfile,0);
	if(tmpout == -1)
		ferror("Cannot reread temp file.");
	write(libin,&m,2);
	fstat(tmpout,&sbuff);
	fsize[0] = sbuff.size0;
	fsize[1] = sbuff.size1;
	mfile(tmpout,libin,fsize);
	close(libin);
	close(tmpout);
	unlink(tmpfile);
	signal(2,olds);
}

match(s)
char *s;
{
	int w;
	register char *vs,*fs,c;
	vs = s;
	fs = a_head.a_name;
	w = 14;
	while(w--) {
		if(c = *vs)
			vs++;
		if(c != *fs++)
			return(0);
	}
	return(1);
}

replace()
{
	int i;
	openlib();
	mktmp();
	for(i=0;i<acount;i++) {
		for(;;) {
			if(getlib()==0)
				goto contin;
			if(match(args[i])) {
				slew(libin);
				insfile(args[i],tmpout);
				break;
			}
			trn(libin,tmpout);
		}
	}
contin:
	for(;i<acount;i++)
		printf("%s : Not found.\n",args[i]);
	while(getlib())
		trn(libin,tmpout);
	rename();
}

delete()
{
	int i;
	openlib();
	mktmp();
	for(i=0;i<acount;i++) {
		for(;;) {
			if(getlib()==0)
				goto contin;
			if(match(args[i])) {
				slew(libin);
				break;
			}
			trn(libin,tmpout);
		}
	}
contin:
	for(;i<acount;i++)
		printf("%s : Not found.\n",args[i]);
	while(getlib())
		trn(libin,tmpout);
	rename();
}

insfile(s,file)
char *s;
int file;
{
	int fi,w;
	register char *sp;
	fi = open(s,0);
	if(fi == -1) {
		printf("%s : ",s);
		ferror("Cannot open.");
	}
	fstat(fi,&sbuff);
	a_head.a_mode = sbuff.flags;
	a_head.a_mtime [0] = sbuff.modtime[0];
	a_head.a_mtime [1] = sbuff.modtime[1];
/*	a_head.a_uid = sbuff.uid;
	a_head.a_gid = sbuff.gid;*/

	a_head.a_uid = (sbuff.uid * 0400) | sbuff.gid;

	a_head.a_size[0] = sbuff.size0;
	a_head.a_size[1] = sbuff.size1;
	w = 14;
	sp = a_head.a_name;
	while(w--)
		*sp++ = (*s == 0 ? 0 : *s++);
	trn(fi,tmpout);
	close(fi);
}

insert()
{
	int	i,f;
	openlib();
	mktmp();
	if(acount == 0)
		ferror("No insert key.");
	while(f=getlib()) 
		if(match(args[0])) {
			seek(libin,-26,1);
			for(i=1;i<acount;i++)
				insfile(args[i],tmpout);
			break;
		} else
			trn(libin,tmpout);
	if(f==0)
		printf("%s : Not found.\n",args[0]);
	while(getlib())
		trn(libin,tmpout);
	rename();
}

modify()
{
	int i;
	openlib();
	mktmp();
	for(i=0;i<acount;i++) {
		for(;;) {
			if(getlib()==0) 
				goto contin;
			if(
				match(args[i]) &&
				stat(args[i],&sbuff) <= 0 &&
				(
					sbuff.modtime[0] != a_head.a_mtime[0] ||
					sbuff.modtime[1] != a_head.a_mtime[1] 
				)
			  ) {
				slew(libin);
				insfile(args[i],tmpout);
				break;
			}
			trn(libin,tmpout);
		}
	}
contin:
	for(;i<acount;i++)
		printf("%s : Not found.\n",args[i]);
	while(getlib())
		trn(libin,tmpout);
	rename();
}
list()
{
	char *locv(),*ctime();

	openlib();
	printf("\n\nName                 uid       Length    Mode   Modified\n\n");
	while(getlib()) {
		printf("%-14.14s      %5d    %8.8s    %4o   %s",
			a_head.a_name,
			a_head.a_uid,
			locv(a_head.a_size[0],a_head.a_size[1]),
			a_head.a_mode & 07707,
			ctime(a_head.a_mtime));
		slew(libin);
	}
	printf("\n\n");
	close(libin);
}
append()
{
	int fi,i;
	fi = open(keylib,0);
	mktmp();
	if(fi != -1) {
		close(fi);
		openlib();
		while(getlib())
			trn(libin,tmpout);
	}
	for(i=0;i<acount;i++)
		insfile(args[i],tmpout);
	rename();
}
extract()
{
	int	i;
	openlib();
	if(acount == 0) {
		while(getlib())
			makeout();
		close(libin);
		return;
	}
	for(i=0;i<acount;i++) {
		for(;;) {
			if(getlib()==0)
				goto contin;
			if(match(args[i])) {
				makeout();
				break;
			}
			slew(libin);
		}
	}
contin:
	for(;i<acount;i++)
		printf("%s : Not found.\n",args[i]);
	close(libin);
}

makeout()
{
	char fname[16];
	register int i,fo,olds;
	int bcount,rcount;
	char buff[512];
	extern int ldivr;
	for(i=0;i<14;i++)
		fname[i] = a_head.a_name[i];
	fname[14] = 0;
	unlink(fname);
	fo = creat(fname,a_head.a_mode);
	if(fo == -1)
		{
		printf("%s : ",fname);
		ferror("Cannot create.");
		}
	olds = signal(2,1);
	bcount = ldiv(a_head.a_size[0],a_head.a_size[1],512);	/* do it here, so no evening */
	rcount = ldivr;
	while(bcount--) {
		read(libin,buff,512);
		write(fo,buff,512);
	}
	if(rcount) {
		read(libin,buff,rcount);
		write(fo,buff,rcount);
	}
	if(rcount&1)
		seek(libin,1,1);
	close(fo);
/*	chgrp(fname,a_head.a_gid);*/
	chown(fname,a_head.a_uid);
/*	mdate(fname,a_head.a_mtime);*/
	signal(2,olds);
	
}
