#include "stp.h"

char	*edir	&dir[0];	/* Allocate no block initially */
char	*nptr	&dir[MDIRENT];	/* just above the nameblock */
int	flags	020;		/* default is flu */

char	mt[]	 "/dev/mt0";
char	nrw_mt[]	 "/dev/nrw_mt0";
char	backup[] "/tmp/mt0dir";

main(argc,argv)
char **argv;
{
	register char c,*ptr;
	extern cmd(), cmr(),cmx(), cmt();

	command = &cmr;
	if ((narg = rnarg = argc) < 2)	narg = 2;
	else {
		ptr = argv[1];	/* get first argument */
		parg = &argv[2]; /* pointer to second argument */
		while (c = *ptr++) switch(c)  {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
				mt[7] = c;
				nrw_mt[11] = c;
				backup[7] = c;
				continue;
			case 'c':
				flags =| flc;  continue;
			case 'd':
				setcom(&cmd);  continue;
			case 'f':
				flags =| flf;  continue;
			case 'i':
				flags =| fli;  continue;
			case 'm':
				continue;
			case 'r':
				flags =& ~flu;  setcom(&cmr);  continue;
			case 't':
				setcom(&cmt);  continue;
			case 'u':
				flags =| flu;  setcom(&cmr);  continue;
			case 'v':
				flags =| flv;  continue;
			case 'w':
				flags =| flw;  continue;
			case 'x':
				setcom(&cmx);  continue;
			default:
				useerr();
		}
	}
	(*command)();
}

/* open tape, positioned at beg. of file number "filenum" */
/* 0 = normal data, 1 = stp directory */
/* file descriptor in "fio" on return */

int cur_fn -1;	/* current file number */
optap(filenum, how)
{
	register h;

	if (cur_fn < 0 || filenum < cur_fn) rewtap();
	/* leave cur_fn incremented one beyond filenum */
	/* corresponding to tape pos. after next close */
	while (++cur_fn <= filenum)
		close(open(nrw_mt, 0));
	h = how;
	/* always use no-rewind device */
	if ((fio = open(nrw_mt,h)) < 0) {
		printf("Cannot open %s\n",nrw_mt);
		if (h)		h = 3;
		done(h);
	}
}

rewtap()
{
	if (close(open(mt, 0)) < 0) {
		printf("Cannot open %s\n", mt);
		exit(-1);
	}
	cur_fn = 0;
}

setcom(newcom)
{
	extern cmr();

	if (command != &cmr)  		useerr();
	command = newcom;
}

useerr()
{
	printf("Bad usage\n");
	done(0);
}

/*/* COMMANDS */

cmd()
{	extern delete();

	if (flags & (flc|flf))		useerr();
	if (narg <= 2)			useerr();
	rddir();
	gettape(&delete);
	optap(1, 2);	/* second file read/write */
	wrdir();
	close(fio);
	check();
}

cmr()
{
	if ((flags & flc) == 0) {
		if ((backio = creat(backup,0600)) < 0) {
			printf("Cannot create %s\n", backup);
			done(0);
		}
		rddir();
	}
	getfiles();
	update();
	optap(1, 2);	/* second file read/write */
	wrdir();
	close(fio);
	check();
}

cmt()
{	extern taboc();

	if (flags & (flc|flf|flw))	useerr();
	rddir();
	if (flags & flv)
		printf("   mode    uid gid tapa    size   date    time name\n");
	gettape(&taboc);
	check();
}

cmx()
{	extern extract();

	if (flags & (flc|flf))		useerr();
	rddir();
	optap(0, 0);
	gettape(&extract);
	close(fio);
	done(0);
}
/**/

check()
{
	flags =& ~flc;
	usage();
	done(0);
}

done(how)  /* 0 no harm, 1 twrite, 2 wseek, 3 optap(~1) */
{
	printf("End\n");
	if ((how==0) && (backio > 0))  /* leave backup file if troublesome exit */
		unlink(backup);
	rewtap();
	exit(how);
}

encode(pname,dptr)	/* pname points to the pathname
			 * nptr points to next location in nameblk
			 * dptr points to the dir entry		   */
{
	register  char *np, *sp;

	sp = pname;
	dptr->d_namep = np = nptr;
	if (np <= edir + 32)  {
			printf("Out of Core\n");
			done(0);
	}
	while (*--np = *sp++);	/* stored backwards */
	nptr = np;
}

decode(pname,dptr)	/* dptr points to the dir entry
			 * name is placed in pname[] */
{

	register char *np, *sp;

	sp = pname;
	np = dptr->d_namep;
	while (*sp++ = *--np);	/* retrieved backwards */
}
