#define RUB 0177
#define DEL ('U' - '@')
#define RETYP ('R' - '@')
/* read one line, simulate as though input is coming
from tty (as it may be!), by reading a buffer full,
then searching for first terminator, returning the appropriate
char cnt and doing a seek to reset the system pointer
associated with the file.
*/

char *retypeptr;	/* if this is non zero, it is assumed to point to
		where retyping is to begin when ^r is typed */

char *terminators;	/* if this is non zero, it is assumed to point to
		a char string of terminators, otherwise \n is used */

readline(fh, buf, cnt)
char *buf;
{
	register char *bp, *ep;
	register cc;
	char *cp;
	char *bufend;
	int pipflg;

	pipflg = seek(fh,0,1);	/* set pipe flag */
	bp = buf;
	bufend = bp+cnt;

	for (;;) {
		if ((cc = bufend - bp) == 0) {
			/* buffer full, return */
			return (cnt);
		}
		if (pipflg) cc=1;	/* one char reads from pipe */
		cc = read(fh, bp, cc);
		if (cc < 0) return (cc);
		if (cc == 0) {
			/* eof */
			*bp = 0;
			 return (bp-buf);
		}

		if (*bp == RUB) {
			/* char delete */
			if (bp != buf) {
				write (1, --bp, 1);
			} else {
				/* char-del with empty buf */
				/* notify calling prog if retypeptr */
				if (retypeptr) return (cc);
			}
			continue;
		}
		ep = bp + cc;
		cp = ep;

		if (*--ep == DEL) {
			/* last char was line-delete */
			if (terminators && *terminators == 0) {
				/* no terminators, scan back for nl */
				bp = ep;
				while (bp > buf && *--bp != '\n');
				if (*bp++ == '\n') continue;
			}
			bp = buf;
			if (retypeptr == 0) continue;
			/* return single char of line-del if retypeptr */
			*bp = *ep;
			return (1);
		}
		if (*ep == RETYP) {
			/* retype a clean copy */
			bp = ep;
			if (terminators && *terminators == 0) {
				/* no terminators */
				/* scan back for nl */
				while (ep > buf && *--ep != '\n');
				if (*ep++ == '\n' && ep != bp) {
					write(1, ep, bp-ep);
					continue;
				}
			}
			if (ep = retypeptr)
				write (1, ep, bp - ep);
			else
				write (1, buf, bp - buf);
			continue;
		}

		/* return only up to a terminator */
		if (terminators) {
			do {
				cc = *bp++;
				for (ep = terminators; *ep; )
					if (cc == *ep++) goto gotline;
			} while (bp < cp);
		} else {
			do {
				if (*bp++ == '\n') goto gotline;
			} while (bp < cp);
		}
	}
gotline:
	if (cc = bp - cp) {
		/* seek back.  if a pipe, return whole buffer */
		if (seek(fh, cc, 1) < 0) return (cp - buf);
	}
	return (bp - buf);
}
