#

/*
 * This program is the listing generator for the pascal compiler.
 * As input it gets triples: errornumber,linenumber and positionnumber
 * The output varies depending on the following flags:
 *	-s:	Every errornumber occurring is listed together with
 *		explanation and the lines where it occurred.
 *	-p:	All lines less than two lines before an error are listed
 *		The error is pointed at by an arrow ( ^ ) and explained
 *	-f:	A full listing of the program is given with errors pointed
		at by an arrow and explained at the end of the program.
 *
 * When no flags are given -s is assumed.
 * 
 * Calling sequence:	pclist [flags] [filename]
 * The filename is obligatory when -p or -f are given.
 *
 */


#define UNDEFINED	0100000
#define ERRNO		403
#define NULL		0

struct lineno {
	int l_num;
	struct lineno *l_ptr;
};

struct errors {
	struct lineno *first,*last;
} errors[ERRNO];

int erno,lino,chno,line,nerrors;
int ibuf[259];
char present[ERRNO],explained[ERRNO];
char s_flag,f_flag;

char	n[]	"no error text";
char	*string[]
{
"end of file reached in source text",
"error in simple type",
"identifier expected",
"'program' expected",
"')' expected",
"':' expected",
"illegal symbol",
"error in parameter list",
"'of' expected",
"'(' expected",
"error in type",
"'[' expected",
"']' expected",
"'end' expected",
"';' expected",
"integer expected",
"'=' expected",
"'begin' expected",
"error in declaration part",
"error in field-list",
"',' expected",
"'.' expected",
n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,
"error in constant",
"':=' expected",
"'then' expected",
"'until' expected",
"'do' expected",
"'to'/'downto' expected",
"'if' expected",
"'file' expected",
"error in factor",
"error in variable",
n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,
"identifier declared twice",
"low bound exceeds highbound",
"identifier is not of appropriate class",
"identifier not declared",
"sign not allowed",
"number expected",
"incompatible subrange types",
"file not allowed here",
"type must not be real",
"tagfield must be scalar or subrange",
"incompatible with tagfield type",
"index type must not be real",
"index type must be scalar or subrange",
"base type must not be real",
"base type must be scalar or subrange",
"error in type of standard procedure parameter",
"unsatisfied forward reference",
"forward reference type identifier in variable declaration",
"forward declared; repetition of parameter list not allowed",
"function result type must be scalar, subrange or pointer",
"file value parameter not allowed",
"forward declared function; repetition of result type not allowed",
"missing result type in function declaration",
"F-format for real only",
"error in type of standard function parameter",
"number of parameters does not agree with declaration",
"illegal parameter substitution",
"result type of parameter function does not agree with declaration",
"type conflict of operands",
"expression is not of set type",
"tests on equality allowed only",
"strict inclusion not allowed",
"file comparison not allowed",
"illegal type of operand(s)",
"type of operand must be boolean",
"set element type must be scalar or subrange",
"set element types not compatible",
"type of variable is not array",
"index type is not compatible with declaration",
"type of variable is not record",
"type of variable must be file or pointer",
"illegal parameter substitution",
"illegal type of loop control variable",
"illegal type of expression",
"type conflict",
"assignment of files not allowed",
"label type incompatible with selecting expression",
"subrange bounds must be scalar",
"index type must not be integer",
"assignment to standard function is not allowed",
"assignment to formal function not allowed",
"no such field in this record",
"type error in read",
"actual parameter must be a variable",
"control variable must not be declared on intermediate level",
"multidefined case label",
"too many cases in case statement",
"missing corresponding variant declaration",
"real or string tagfields not allowed",
"previous declaration was not forward",
"again forward declared",
"parameter size must be constant",
"missing variant in declaration",
"substitution of standard proc/func not allowed",
"multidefined label",
"multideclared label",
"undeclared label",
"undefined label",
"error in base set",
"value parameter expected",
"standard file was redeclared",
"undeclared external file",
"Fortran procedure or function expected",
"pascal procedure or function expected",
"missing file input in program heading",
"missing file 'output' in program heading",
"assignment to function identifier not allowed here",
"multidefined record variant",
"X-opt of actual proc/func does not match formal declaration",
"control variable must not be formal",
"constant part of address out of range",
n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,
"error in real constant: digit expected",
"string constant must not exceed source line",
"integer constant exceeds range",
"8 or 9 in octal number",
"zero string not allowed",
"integer part of real constant exceeds range",
n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,
"too many nested scopes of identifiers",
"too many nested procedures and/or functions",
"too many forward references of procedure entries",
"procedure too long",
"too many long constants in this procedure",
"too many errors in this source line",
"too many external references",
"too many externals",
"too many local files",
"expression too complicated",
"integer overflow in compiler: probably arrays too big",
n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,
"division by zero",
"no case provided for this value",
"index expression out of bounds",
"value to be assigned out of bounds",
"element expression out of range",
n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,
n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,
n,n,n,n,n,n,n,n,n,n,
"goto may not lead out of procedure or functionbody",
"comparison of packed arrays or records not allowed",
"inconsistency in typeindication (internal error)",
"bad character",
"string too long",
"implementation restriction",
"implementation restriction",
"error in kind of expression",
n,
"read error in compiler ( may not occur)",
"compiler is missing an interpreter routine (may not occur)"
};


char errmess[]	"errors in pascal program\n";

main(ac,av) char **av; {
	extern fout;

	fout=dup(1);
	if (ac>1 && av[1][0]=='-') {
		switch(av[1][1]) {
			case 'f':++f_flag;	break;
			case 'p':		break;
			case 's':++s_flag;	break;
		}
		--ac;++av;
	} else
		++s_flag;
	if (s_flag)
		liststandard();
	else {
		if(ac<2)
			fatal("arg count");
		if (fopen(av[1],ibuf)<0)
			fatal("cannot open %s",av[1]);
		listextensive();
	}
}


liststandard() {
	register struct lineno *pt1,*pt2;
	register i;
	int tmp;

	nexterror();
	while(erno!=UNDEFINED) {
		pt1=nextlineno();
		pt1->l_num=lino;
		pt2=errors[erno].last;
		if (pt2==NULL)
			errors[erno].first=pt1;
		else
			pt2->l_ptr=pt1;
		errors[erno].last=pt1;
		nexterror();
	}

	if(nerrors==0)
		okexit();

	printf(errmess);
	for(i=0;i<ERRNO;i++)
		if((pt1=errors[i].first)!=NULL) {
			printf("%5d\t%s",i,string[i]);
			for(tmp=0;pt1!=NULL;pt1=pt1->l_ptr,tmp++)
				printf("%s%5d",tmp&7 ? "\t":"\n\t",pt1->l_num);
			putchar('\n');
		}
	notokexit();
}

nextlineno() {
	register struct lineno *p;

	p=alloc(4);
	if (p== -1)
		fatal("out of core\n");
	p->l_ptr=NULL;
	return(p);
}

nexterror() {

	erno=rdi();
	if(erno!=UNDEFINED) {
		lino=rdi();
		chno=rdi();
		++nerrors;
		++present[erno];
	} else {
		lino=UNDEFINED;
		chno=UNDEFINED;
	}
}

rdi() {
	register num,ch;

	while ((ch=getchar())==' ' || ch=='\n')
		;
	if (ch=='\0')
		return(UNDEFINED);
	num = ch - '0';
	while ((ch=getchar())>='0' && ch <= '9')
		num = 10*num + ch - '0';
	return(num);
}

listextensive() {

	nexterror();
	for(;;) {
		if(!f_flag && erno==UNDEFINED)
			extensive_exit();
		if(f_flag || line >= lino-2)
			printline();
		else
			skipline();
		if (line==lino)
			errorline();
	}
}

printline() {
	register ch;

	if ((ch=getc(ibuf))>=0)
		printf("%5d\t",++line);
	do {
		putchar(ch);
		if (ch=='\n')
			return;
	} while((ch=getc(ibuf))>=0);
	extensive_exit();
}

skipline() {
	register ch;

	++line;
	while((ch=getc(ibuf))!='\n' && ch >= 0 )
		;
	if (ch<0)
		extensive_exit();
}

errorline() {
	char erlist[ERRNO];
	register int col,i;
	register char *err;

	for(err=erlist;err< &erlist[ERRNO];)
		*err++ = 0;
	printf("*** ***\t");
	col=1;
	while(lino==line) {
		++erlist[erno];
		while(col<chno) {
			putchar(' ');
			++col;
		}
		printf("%c%d",(col++>chno ? ',':'^'),erno);
		col =+ length(erno);
		nexterror();
	}
	putchar('\n');
	if (f_flag)
		return;
	for(err=erlist,i=0;i<ERRNO;i++,err++)
		if(*err && !(explained[i]++))
			printf("%5d:\t%s\n",i,string[i]);
	separator();
}

separator() {
	register i;

	for(i=0;i<72;i++)
		putchar('-');
	putchar('\n');
}

length(an) {
	register nn;

	if((nn=an)<10)
		return(1);
	if(nn<100)
		return(2);
	return(3);
}

extensive_exit() {
	register i;

	if (nerrors==0)
		okexit();
	if(!f_flag)
		notokexit();
	printf(errmess);
	for (i=0;i<ERRNO;i++)
		if(present[i])
			printf("%5d:\t%s\n",i,string[i]);
	notokexit();
}

okexit() {

	flush();
	exit(0);
}

notokexit() {

	flush();
	exit(1);
}

fatal(text,a) {

	printf("list: ");
	printf(text,a);
	putchar('\n');
	notokexit();
}
