struct diskstat
{
    char    bminor;
    char    bmajor;
    int     binumber;
    int     bflags;
    char    bnlinks;
    char    buid;
    char    bgid;
    char    bsize0;
    int     bsize1;
    int     baddr[8];
    int     bactime[2];
    int     btime0;
    int     btime1;
};
struct stats
{
    char    name[32];
    int     mode;
    char    uid;
    char    gid;
    char    blank1;
    char    size0;
    int     size1;
    int     time0;
    int     time1;
    int     tapa;
    char    blank2[16];
    int     sum;
};
struct stats    x[8],
                dirbuf[8],
                tpstat;
struct diskstat dstat;
int     sptr,
        eptr,
        ends,
        ende,
        readin,
        writeout,
        fillhere,
        on_infile,
        tape;
char   *strng,
        strng_area[512];
main (argc, argv) int   argc;
char  **argv;
{
    char   *dev;
    int     i,
            j,
            k,
            m,
            fildes,
            infile,
            outfile,
            lastblock,
            dptr,
            endd;
    char register  *ptr1;
    int     length[512],
           *length_ptr,
            seke[512],
           *seek_ptr;
    char    buffer[512];
    extern char *cat ();
    if (argc < 3)
	usage ();
    if (argc == 3)
	usage ();
    dev = "/dev/rmtn";
    dev[8] = argv[1][0];
    if ((infile = open (dev, 0)) < 0)
    {
	printf ("input file is no good\n");
	exit ();
    }
    dev[8] = argv[2][0];
    if ((outfile = open (dev, 1)) < 0)
    {
	printf ("output file no good\n");
	exit ();
    }
    if ((sptr = option ("s", "ed", 3, argc, argv)) < 0)
    {
	printf ("illegal option in field %d\n", -sptr);
	exit ();
    }
    if ((eptr = option ("e", "sd", 3, argc, argv)) < 0)
    {
	printf ("illegal option in field %d\n", -eptr);
	exit ();
    }
    if ((dptr = option ("d", "se", 3, argc, argv)) < 0)
    {
	printf ("illegal option in field %d\n", -dptr);
	exit ();
    }
    if ((dptr != 0) & ((dptr < eptr) | (dptr < sptr)))
	usage ();
    if ((eptr != 0) & (eptr < sptr))
	usage ();
    i = 0;
    if (sptr != 0)
	i = sptr;
    if ((eptr != 0) & (sptr == 0))
	i = eptr;
    if ((dptr != 0) & ((sptr == 0) & (eptr == 0)))
	i = dptr;
    if (i > 4)
	usage ();
    if (i != 0)
    {
	ends = (sptr == 0) ? -1 : (((eptr == 0) ? ((dptr == 0) ? argc - 1 : dptr - 2) : eptr - 2));
	ende = (eptr == 0) ? -1 : ((dptr == 0) ? argc - 1 : dptr - 2);
	endd = (dptr == 0) ? -1 : argc - 1;
	dptr = 3;
	endd = argc - 1;
    }
    else
    {
	ende = -1;
	ends = argc - 1;
	sptr = 3;
	dptr = 3;
	endd = argc - 1;
    }
    tape = 63;
    readin = writeout = 0;
    for (i = sptr; i <= ends; i++)
	check (argv[i]);
    for (i = eptr; i <= ende; i++)
	check (argv[i]);
    reed (infile, buffer, &readin);
    rite (outfile, buffer, &writeout);
    for (i = sptr; i <= ends; i++)
    {
	if (stat (argv[i], &dstat) < 0)
	{
	    printf("pseudo-phase error\n");
	    exit ();
	}
	convert (&dstat, &tpstat, argv[i]);
	dirwrite (outfile, &tpstat, 1);
    }
    seek_ptr = seke;
    length_ptr = length;
    while (readin < 63)
    {
	reed (infile, x, &readin);
	for (i = 0; i < 8; i++)
	{
	    if ((x[i].name[0] != 0) | (x[i].name[1] != 0))
	    {
		k = 1;
		for (j = dptr; j <= endd; j++)
		{
		    strng = strng_area;
		    if (glob (cat (x[i].name, ""), cat (argv[j], "")))
		    {
			k = 0;
			printf ("deleted...%s\n", argv[j]);
			break;
		    }
		}
		if (k)
		{
		    *seek_ptr++ = x[i].tapa;
		    *length_ptr++ = blocks (&x[i]);
		    dirwrite (outfile, &x[i], 0);
		    on_infile++;
		    lastblock = x[i].tapa - 63;
		}
	    }
	}
    }
    for (i = eptr; i <= ende; i++)
    {
	if (stat (argv[i], &dstat) < 0)
	{
		printf ("pseudo-phase error\n");
	    exit ();
	}
	convert (&dstat, &tpstat, argv[i]);
	dirwrite (outfile, &tpstat, 1);
    }
    dirclean (infile, outfile);
    filwrite (sptr, ends, outfile, argv);
    seek_ptr = seke;
    length_ptr = length;
    for (i = 0; i < on_infile; i++)
    {
	seak (infile, *seek_ptr++, &readin);
	k = *length_ptr++;
	for (j = 0; j < k; j++)
	{
	    reed (infile, buffer, &readin);
	    rite (outfile, buffer, &writeout);
	}
    }
    filwrite (eptr, ende, outfile, argv);
    close (infile);
    close (outfile);
    exit ();
}
dirwrite (a, b, new) int    a,
                            new;
struct stats   *b;
{
    register char  *ptrto,
                   *ptrfrom;
    extern double   itof24 ();
    int     some,
            i;
    register   *int_ptr;
    if (writeout >= 62)
    {
	printf ("no more directory room\n");
	exit ();
    }
    if ((b -> name[0] == '.') & (b -> name[1] == '/'))
    {
	ptrto = b -> name;
	ptrfrom = &b -> name[2];
	i = 14;
	while (i--)
	    *ptrto++ = *ptrfrom++;
	*ptrto++ = ' ';
	*ptrto = ' ';
    }
    ptrto = &dirbuf[fillhere];
    ptrfrom = b;
    i = 64;
    while (i--)
	*ptrto++ = *ptrfrom++;
    i = blocks (b);
    dirbuf[fillhere].tapa = tape;
    printf ("%8d %15.0f %s\n", dirbuf[fillhere].tapa, itof24 (dirbuf[fillhere].size0,
		dirbuf[fillhere].size1), dirbuf[fillhere].name);
    tape =+ i;
    b -> tapa =+ i;
    int_ptr = &dirbuf[fillhere];
    i = 31;
    some = 0;
    while (i--)
	some =+ *int_ptr++;
    dirbuf[fillhere].sum = -some;
    if (++fillhere >= 8)
    {
	rite (a, &dirbuf, &writeout);
	fillhere = 0;
    }
    return (0);
}
dirclean (infile, outfile) int  infile,
                                outfile;
{
    register int    i;
    char register  *ptrto;
    if (fillhere != 0)
    {
	ptrto = &dirbuf[fillhere];
	i = (8 - fillhere) * 64;
	while (i--)
	    *ptrto++ = '\0';
	rite (outfile, &dirbuf, &writeout);
    }
    else
	fillhere = 8;
    i = fillhere * 64;
    ptrto = &dirbuf[0];
    while (i--)
	*ptrto++ = '\0';
    for (i = writeout; i < 63; i++)
	rite (outfile, &dirbuf, &writeout);
    return;
}
check (file) char  *file;
{
    char    buffer[64];
    if ((stat (file, buffer)) < 0)
    {
	printf ("unknown filename--%s\n", file);
	exit ();
    }
    return;
}
option (find, ok, startat, argc, argv) char *find,
                                           *ok;
int     startat;
int     argc;
char  **argv;
{
    register int    j,
                    i;
    register char  *okptr;
    for (i = startat; i < argc; i++)
    {
	if (argv[i][0] == '-')
	{
	    for (j = 1; argv[i][j] != '\0'; j++)
	    {
		if (argv[i][j] == *find)
		    return (i + 1);
		okptr = ok;
		while (*okptr != '\0')
		{
		    if (argv[i][j] == *okptr)
			break;
		    okptr++;
		}
		if (*okptr == '\0')
		    return (-i);
	    }
	}
    }
    return (0);
}
convert (buffer, statptr, file) struct diskstat *buffer;
struct stats   *statptr;
char   *file;
{
    register int    j;
    register char  *ptr1,
                   *ptr2;
    statptr -> tapa = 63;
    statptr -> mode = buffer -> bflags;
    statptr -> uid = buffer -> buid;
    statptr -> gid = buffer -> bgid;
    statptr -> size0 = buffer -> bsize0;
    statptr -> size1 = buffer -> bsize1;
    statptr -> time0 = buffer -> btime0;
    statptr -> time1 = buffer -> btime1;
    ptr1 = file;
    ptr2 = statptr -> name;
    j = 32;
    while (j--)
	*ptr2++ = *ptr1++;
    return;
}
blocks (b) struct stats *b;
{
    register int    i;
    i = (b -> size1 & 0777) ? 1 : 0;
    i =+ ((b -> size1 >> 9) & 0177);
    i =| (b -> size0 << 7);
    return (i);
}
filwrite (qptr, endq, outfile, argv) int    qptr,
                                            endq,
                                            outfile;
char  **argv;
{
    register int    i,
                    k;
    int     j,
            fildes;
    char    buffer[512],;
    char register  *ptr1;
    for (i = qptr; i <= endq; i++)
    {
	if ((fildes = open (argv[i], 0)) < 0)
	{
	    printf ("error 1\nthe writing tape is bad\n");
	    exit ();
	}
	j = 0;
	while (1)
	{
	    if (seek (fildes, j++, 3) < 0)
		break;
	    if ((k = read (fildes, buffer, 512)) < 512)
		break;
	    rite (outfile, buffer, &writeout);
	}
	if (k)
	{
	    ptr1 = &buffer[k];
	    k = 512 - k;
	    while (k--)
		*ptr1++ = 0;
	    rite (outfile, buffer, &writeout);
	}
	close (fildes);
    }
    return;
}




usage ()
{
    printf ("Usage: tp2 # # [-s files] [-e files] [-d files]\n");
    exit ();
}


reed (fildes, buf, count) int   fildes,
                               *count;
char   *buf;
{
    if (read (fildes, buf, 512) < 512)
    {
	printf ("Input file screwed up\n");
	exit ();
    }
    (*count)++;
    return (0);
}



rite (fildes, buf, count) int   fildes,
                               *count;
char   *buf;
{
    if (write (fildes, buf, 512) < 512)
    {
	printf ("Output file gone awry\n");
	exit ();
    }
    (*count)++;
    return (0);
}


seak (fildes, seek_to, count) int   fildes,
                                    seek_to,
                                   *count;
{
    char    buf[512];
    register int    i;
    for (i = *count; i < seek_to; i++)
    {
	if (read (fildes, buf, 512) < 512)
	{
	    printf ("seek unsuccesful\n");
	    exit ();
	}
    }
    *count = i;
    return (0);
}
