.th Indent III 1/10/77
.sh NAME
Indent \*- Produce an indented C program source
.sh SYNOPSIS
indent [ifile [ofile]] [args]
.sh DESCRIPTION
The arguements that can be specified are:
.s3
.lp \n(in+10 10
ifile	Input file specification.  If this is omitted, input is from standard input.
.s3
.lp \n(in+10 10
ofile	Output file specification.  If this is omitted, output is to standard output.
Ofile cannot be specified without ifile.
.s3
.lp \n(in+10 10
-lnnn	This gives the maximum length of an output line.  The default is -l120.
.s3
.lp \n(in+10 10
-cnnn	This gives the column in which comments will start.  The default is -c57.
.s3
.lp \n(in+10 10
-cdnnn	This gives the column in which comments on declarations will start.  The default
is for these comments to start in the same column as other comments.
.s3
.lp \n(in+10 10
-innn	This gives the number of spaces for one indentation level.  The default is -i4.
.s3
.lp \n(in+10 10
-dj,-ndj	-dj will cause declarations to be left justified.  -ndj will cause
them to be indented the same as code.  The default is -ndj.
.s3
.lp \n(in+10 10
-v,-nv	-v turns on "verbose" mode, -nv turns it off.  When in verbose
mode, indent will report when it 
splits one line of input into two or more lines of output,
and it will give some size statistics at completion.  The default is -nv.
.s3
.lp \n(in+10 10
-bc,-nbc	If -bc is specified, then a newline will be forced after each
comma in a declaration.  -nbc will turn off this option.  The default is -bc.
.s3
.lp \n(in+10 10
-dnnn	This option controls the placement of comments which are not to the right
of code.  The default of -d2 means that such comments will be placed two
indentation levels to the left of code.  -d0 would line up such comments with
the code.  See the section
on comment indentation below.
.s3
.lp \n(in+10 10
-br,-bl	Specifying -bl will cause complex statements to be lined up like this:
.s3
.ne 4
    if (...)
    {
        code
    }
.s3
Specifying -br will make them look like this:
.s3
.ne 3
    if (...) {
        code
    }
.s3
The default is -bl.
.i0
.s3
Indent is intended primarily as a C program indenter.  It will not take an
arbitrary C program and produce a source file which conforms to the DSG
documentation standards.  It will, however, isolate the programmer from much of 
the work required to get his/her source into such a format.  Specifically,
indent will:
.s3
    indent code lines,
    align comments,
    insert spaces around operators, where necessary, and
    break up declaration lists, as in "int a,b,c;".
.s3
It will not break up long statements to make them fit within
the maximum line length, but it will flag lines that are too long.  Lines will 
be broken so that each statement starts a new line, and braces will appear alone
on a line.  (See the -br option for the exception to this.)  Also, a feeble attempt is made to line up identifiers in
declarations.

Multi-line expressions
.s3
Indent will not break up complicated expressions that extend over multiple
lines, but it will usually correctly indent such expressions which have
already been broken up.  Such an expression might end up looking like this:
.s3
.ne 10
.in \n(in+4
x =
        (
            (Arbitrary parenthesized expression)
            +
            (
                (Parenthesized expression)
                *
                (Parenthesized expression)
            )
        );

.i0
.s3
Comments
.s3
Indent recognizes four kinds of comments.  They are straight text, "box" comments,
unix-style comments,
and comments that should be passed thru unchanged.  The action taken with these
various types is as follows:
.s3
   "Box" comments: The DSG documentation standards specify that boxes will be
placed around section headers.  Indent assumes that any comment with a dash
immediately after the start of comment (i.e. "/*-") is such a box.  Each line
of such a comment will be left unchanged, except that the first non-blank
character of each successive line will be lined up with the beginning
slash of the first line.  Box comments will be indented (see below).

   Unix-style comments:  This is the type of section header which is used 
extensively in the unix system source.  If the start of comment ('/*') appears on a
line by itself, indent assumes that it is a unix-style comment.  These will be
treated similarly to box comments, except the first non-blank character on each
line will be lined up with the '*' of the '/*'.

   Unchanged comments: Any comment which starts in column 1 will be left completely
unchanged.  This is intended primarily for documentation header pages.
The check for unchanged comments is made before the check for unix-style comments.

   Straight text: All other comments are treated as straight text.  Indent will fit
as many words (separated by blanks, tabs, or newlines) on a line as possible.
Straight text comments will be indented.

.s3
Comment indentation
.s3
Box, unix-style, and and straight text comments may be indented.  If a comment is on a line
with code, or follows a non-blank line, it will be started in the "comment
column", which is set by the -cnnn command line parameter.  Otherwise, the
comment will be started at nnn indentation levels less than where code is
currently being placed, where nnn is specified by the -dnnn command line parameter.  (Indented
comments will never be placed in column 1.)
.s3
If the code on a line extends past the comment column, the comment will be moved
to the next line.

.s3
.sh DIAGNOSTICS
Diagnostic error messsages, mostly to tell that a code line has been broken
or is too long for the output line, will be printed on the controlling tty.
.sh BUGS
None known at this writing, but they surely exist.  If (when) any are found, please
notify David Willcox.
