#
/*
 */

/*
 *	system table read/write special file
 *	minor device number selects table, 0 <= dev.minor < ntbldev
 */

#include "../param.h"
#include "../user.h"
#include "../buf.h"
#include "../proc.h"
#include "../conf.h"
#include "../textlim.h"
#include "../st_his.h"

struct tbldev {
	char	*tb_start;
	char	*tb_end;
} tbldev[] {
	0,	&end,		/* used for fast reference to data only */
	&proc,	&proc+1,	/* proc table */
	&u,	&u + 1,		/* user page */
	&xlim,	&xlim+1,	/* text limit stuff */
	&st_histr, &st_histr+1,	/* state histogram */
};
#define NTBLDEV (sizeof tbldev/ sizeof tbldev[0])
struct buf tblbuf;	/* all zeroes is correct init. */


tblopen(dev, flag)
{
	if (dev.d_minor >= NTBLDEV)
		u.u_error = ENXIO;
}

tblread(dev)
{
	tblio(dev,B_READ);
}

tblwrite(dev)
{
	tblio(dev,B_WRITE);
}

tblio(dev,flag)
{
	register struct tbldev *tblp;
	register char *bp;

	tblp = &tbldev[dev.d_minor];
	if (u.u_offset[0] != 0) return;
	bp = u.u_offset[1] + tblp->tb_start;
	if (bp < tblp->tb_start || bp >= tblp->tb_end) return;
	iomove(&tblbuf,bp,min(tblp->tb_end-bp,u.u_count),flag);
}
