#
/*	the protocoller written in c!
 *	based on the machine code version
 */

# define psz 35        /* lines displayed each page */
# define sz2 10        /* overlap */

/* global stuff goes here */
char buf[128];
char file;
char twoflag 0;
int tty[3];
int fcnt, sfile, inbuf;
int ttysv;
int mvback;
char sbuf[512], *bptr;
int filep;
int shid, proto2;
int p1[4];
char *name "protocol";
char cmndbuf[] "/usr/bin/                                  ";
struct {char a;char b;int c;int d; char e;char f1;char f2;char g;
int fsize;int h[12];} inode;

main(argc,argv)
char *argv[];
{
	register char *ap;
	register int n;
	register int *pipes;
	extern int getout;
	extern int scrout;
	int sts;

	signal(2,1);
	signal(3,1);
	ap = argv[0];
	if(*ap == '2') twoflag = 1;
	while (*ap++);          /* scan to end */
	if(*(ap-3) == 'l') {
		name = argv[1];
		scroll(016);
		exit();
	}
	pipes = p1;
	if(pipe(pipes++) < 0)
		goto piperr;	/* get 2 pipes */
	if(pipe(++pipes) < 0)
piperr:		error("can't make pipes");
	pipes = p1;             /* restore pipes */
	ap = argv[1];		/* ap is arg ptr */
	if(argc < 2)
		goto dflt;
	if(n = (*ap == '-' || *ap == '+')) {
		if(* ++ap)
			name = ap;
		ap--;
		if(argc!=2) goto nodflt;
dflt:           argv[0] = "";
		n = -1;
		argc = 1;
nodflt: ;}
	if(*ap ==  '+') {
		if((file=open(name,1)) < 0) goto docr;
		if(seek(file,0,2)== -1)
			error("can't seek on output");
	} else 
{docr:          if((file=creat(name,0644)) < 0)
			error("can't create output file");      }
	shid = fork();		/* get middle process */
	if(shid== -1)
		error("can't create middle process");
	if(!shid) {		/* here is the middle process */
		/*
		 * the addition of fd 2 below thanks to jsdy@SAI.
		 */
		close(0);close(1);
		if(twoflag) close(2);
		if(dup(*pipes) || (dup(p1[3]) != 1) ||
		       (twoflag && (dup(p1[3]) != 2)))
			error("can't dup ports");
		while(pipes < &p1[4])
			close(*pipes++);
				/* clean up ports */
		doit(&argv[n],argc-1-n);
	}
	proto2 = fork();	/* now get input process */
	if(proto2== -1)
		error("can't spawn input process");
	if(!proto2) {		/* input process */
		signal(1,&getout);
		signal(13,&getout);
		close(*pipes++);
		close(*++pipes); close(*++pipes);
		pipes =- 2;
loop:           if ((n=read(0,buf,128)) < 0)
			error("tty read err");
		if(n < 3 && *buf == 07) {
			scroll(021);
			goto loop;
		}
		move(n);        /* copy buffers */
		if(write(file,sbuf,n)<n)
			error("file write err");
		if (((n == 0)? eofp(*pipes) : write(*pipes,buf,n)) < n)
			error("pipe write err");
		goto loop;
	}
	close(*pipes++);close(*pipes++);close(*++pipes); /* 3rd proc */
	--pipes;
	type(2,"[starting protocol]\n");
lop2:   if((n=read(*pipes,buf,128)) < 0)
		err("pipe read err");
	if(!n) {		/* eof? */
		kill(proto2,1);	/* murder input process */
		while(wait(&sts) != proto2);
		exit();
	}
	write(file,buf,n);
	if(write(1,buf,n)<n)
		err("tty write err");
	goto lop2;
}


scroll(frstcmnd)
{
	register int n;
	register char *p;
	extern int scrout,getout;
	extern int fout;
	int sts;
	if((sfile=open(name,0)) < 0) {
		type(2,"can't!\n");
		return;
	}
	fout = dup(2);
	gtty(0,tty);
	ttysv = tty[2];
	tty[2] =| 040;
	tty[2] =& ~ (010);
	signal(1,&scrout);
	stty(0,tty);
	n = gfilesz();
	type(2,"(size=");
	prndec(2,n);
	type(2,")\n");
	seek(sfile,n,0);
	fcnt = n;
	inbuf = 0;
	if(!backbuf()) goto scexit;
	mvback = sz2;
	*buf = frstcmnd;
	goto intoit;
	for(;;) {
		write(2,":",1);
		n = read(0,buf,1);
		*buf =& 0177;
		write(2,"\r",1);
		if(n != 1) goto scexit;
intoit:         switch(*buf) {
	case 021:
			moveback(psz-sz2+mvback);
dsply:			space();
			display(psz,1);
			continue;
	case 031:
			display(psz-sz2,1);
			continue;
	case 016:
			moveit(0);
			getbuf(0);
			goto dsply;
	case 022:
			type(2,"?");
			read(0,buf,1);
			*buf =& 0177;
			write(2,buf,1);
			n = *buf - '0';
			if (n<0 || n>120) n=0;
			while(display(psz,1)) {
				if(!empty(0)) break;
				sleep(n);
			}
			continue;
	case 012:
			moveit(gfilesz());
			backbuf();
			moveback(psz);
			goto dsply;
	case 025:
			type(2,"(=");
			prndec(2,fcnt+bptr-sbuf-inbuf);
			type(2,")\n");
			continue;
	case '!':
	case '?':
			n = fork();
			if(n== -1) {
				type(2,"can't get process\n");
				continue;
			}
			type(2,"\n");
			tty[2] =& ~040;
			tty[2] =| 010;
			stty(0,tty);
			if (n==0) {
			    signal(2,0);
			    if((*buf&0177)=='?')
				 execl("/bin/l","l","/u1/ss/help/lacmnds",0);
			    else execl("/bin/sh","- (proto shell)",0);
			}
			while(wait(&sts) != n);
			tty[2] =& ~010;
			tty[2] =| 040;
			stty(0,tty);
			continue;
	case '-':
	case '+':
			if((n = getnum(1)-1)==0) goto pass;
			do
			if(n >= 0) {
				display(psz,0);
				--n;
			} else {
				moveback(psz);
				n++;
			}
			while(n);
pass:			space();
			display(psz,1);
			continue;
	case 020:
			*buf = '>';
			n = getnum(0);
			if(n<0 || n > gfilesz()) continue;
			moveit(++n);
			backbuf();
			moveback(psz);
			goto dsply;
	case 0177:
	case 04:
	case 07:
	case ':':
scexit:			tty[2] = ttysv;
			stty(0,tty);
			type(2,"\n(leaving scroller)\n");
			signal(1,&getout);
			return;

	default:
			write(2,buf,1);
			type(2," ?unrecognized cmnd\n");
			continue;
		}

	}
}

moveit(n)
{
	register int x;
	x = n;
	seek(sfile,x,0);
	fcnt = x;
	inbuf = 0;
}

moveback(n)
{
	register char c;
	register int n2;
	n2 = 0;
	while(n2 < n) {
		if(!(c = backw())) {
			break;
		}
		if(c == '\n') n2++;
	}
}

space()
{
	type(2,"\013\014");
}

display(n,b)
{
	register int n2;
	char c;
	mvback = 0;
	n2 = 0;
	while(n2 < n) {
		if(!(c = forw())) {
			break;
		}
		if(b) putchar(c);
		if(c == '\n') {
			n2++;
			mvback++;
			flush();
			if (!empty(0)) break;
		}
	}
}

gfilesz()
{
	fstat(sfile,&inode);
	return(inode.fsize);
}

forw()
{
	char c;
	if((bptr == &sbuf[inbuf-1]) && !getbuf(0))
		return(0);
	return(*++bptr);
}

backw()
{
	if((bptr == sbuf) && !backbuf())
		return(0);
	return(*--bptr);
}

getbuf(x)
{
	register int n;
	if(!(n = read(sfile,sbuf,512)))
		return(0);
	fcnt =+ n;
	inbuf = n;
	bptr = &sbuf[x-1];
	return(1);
}

backbuf()
{
	int n;
	if(fcnt == inbuf)
		return(0);
	n = inbuf+256;
	if(fcnt < n) {
		seek(sfile,0,0);
		n = fcnt - inbuf;
		fcnt = 0;
		return(getbuf(n));
	}
	seek(sfile, -n, 1);
	fcnt =- n;
	return(getbuf(256));
}

/* move simply copies from buf to buf2, changeing cr's to lf's */
move(n)
{
	register char *c,*d;
	register int n2;

	if ((n2 = n) == 0) return;
	c=buf;
	d= sbuf;
	do {
		*d++ = *c == '\r'? '\n' : *c;
		c++;
	} while (--n2);
}



/* doit is given ap after being bumped once &
 * # of args. it must execute them!
 */

doit(argp,n)
char *argp[];
{
	register int *ap;
	register int n2;
	register char *cn;
	ap=argp;
	n2 = 0;
	type(file,"\n>>>>>>>");
	do typef(*ap++ = *(ap+1));
	while(++n2 < n);
	write(file,"\n",1);
	*ap = 0;
	ap = argp;
	if (*(cn = *ap) == 0) cn = "/bin/sh";
	signal(2,0);
	signal(3,0);
	execv(cn,ap);
	cpcmnd(cn);
	execv(&cmndbuf[4],ap);
	execv(cmndbuf,ap);
	type(2,"[can't exec program: ");
	type(2,cn);
	type(2,"]\n");
	exit();
}

cpcmnd(s)
char *s;
{
	register char *a,*b;
	a = &cmndbuf[8];
	b = s;
	do	* ++a = *b++;
	while(*a);
}

typef(s)
char *s;
{
	write(file," ",1);
	type(file,s);
}


/*
 * all the error handlers. they are passed a string.
 * 0: master process only, 2: 1 fork, 3: 2 forks
 * 4: from input process
 * 5: from middle process
 */

error(s)
char *s;
{
	type(2,"[");
	type(2,s);
	type(2,"]\n");
	exit();
}

err(s)
char *s;
{
	kill(proto2,9);
	error(s);
}

getnum(n)
{
	register char *p;
	register int n2;
	char c;

	c = *buf;
again:	p = buf+n;
	write(2,&c,1);
	do {
		read(0,p,1);
		*p =& 0177;
		if(*p == 025) {
			type(2,"^u\n");
			goto again;
		}
		write(2,p,1);
	} while(*p++ != '\n');
	n2 = atoi(buf+n);
	return(c == '-'? -n2:n2);
}

scrout()
{
	type(2,"(warning! scroller exit.)\n");
	tty[2] = ttysv;
	stty(0,tty);
	type(2,"[ending protocol]\n");
	exit();
}

getout()
{
	type(2,"[ending  protocol]\n");
	exit();
}




type(port,s)
char *s;
{
	register int n;
	register char *p;
	n = 0;
	p = s;
	while(*p++) n++;
	write(port,s,n);
}

prndec(port,x)
{
	if(x < 0) {
		type(port,"(negative!)");
		return;
	}
	if(x/10) prndec(port,x/10);
	x = x%10 + '0';
	write(port,&x,1);
}

atoi(s)
char *s;
{
	register int n;
	n = 0;
	while(*s <= '9' && *s >= '0') n = 10*n + *s++ - '0';
	return(n);
}
