#

/*
 *      News program developed by Peter S. Langston @ Harv-UNIX
 *      Changes for regular UNIX by Joseph S. D. Yao @ SAI-Rosslyn
 */

#define REVFLG  01
#define MORFLG  02
#define STOPF   04

/*
 * requires the following files or their equivalents, initialised as follows:
 * index should have a 1 followed by 7 0's in it (8 ints, 16 chars);
 * items should exist;
 * /u1/lock, on the same disk, should exist: lockf should  n o t;
 * nips should have as many ints as you have users, all 1's.
 */
char *indexfile "/u1/other/kent/index";
char *itemf     "/u1/other/kent/items";
char *lockf     "/u1/other/kent/lock";
char *nipfile   "/u1/other/kent/nips";
char *pending   "pending.news";

struct index {
	int addr;
	int date;
	int byline;
	char maxage;
	char flags;
} ndex[64], *p;

int dp[] {
	"peruse",
	"include",
	"review",
	"duration",
	"morgue",
	"censor",
	0
};

int (*funcs[])() {
	&renews,
	&wrnews,
	&revnews,
	&durnews,
	&mornews,
	&cennews,
};

char txtbuf[600], ttyin[600], *txtp, *arg, gid, flag;
int indxf, inf, nipf, txtf, pendf, uid, nip;
int current -123, ndleng, in, today, expire 14, maxnip;
double now;
struct {
	int highint;
	int lowint;
};

main(argc,argv)
char **argv;
{
	char *swtchp;
	register n;
	long timeno;

	uid = getuid();
	if(uid == -1) exit();
	else uid =& 0377;
	gid = getgid();
	if(getnip() == 0) exit();
	time(&timeno);
	srand(timeno.lowint);
	now = timeno/600.;
	n = now/28800.;
	today = now - 28800. * n;
	getind(0);
	maxnip = p->addr;
	if(argc == 1) {
		renews();
		exit();
	}
	while(--argc) {
		arg = *++argv;
		if(*arg++ != '-') {
			printf("bad switch '%s'\n",--arg);
			exit();
		}
		swtchp = arg;
		while(*arg)
			if(*arg++ == ':') {
				arg[-1] = '\0';
				break;
			}
		n = swmtch(swtchp,dp);
		if(n < 0) {
			printf("%s switch '%s'\n",
				n<-1 ? "ambiguous" : "unknown",
				swtchp);
			exit();
		}
		(*funcs[n])();
	}
}

swmtch(string, switches)
char *string;
char **switches;
{
	register char *s, *t;
	int n, sav;

	sav = -1;
	n = 0;
	while(*switches) {
		s = string;
		t = *switches;
		for(;;) {
			if(*s != '\0') {
				if(*t == '\0' || *s != *t++) break;
				s++;
			}
			else {
				if(sav != -1) return(-2);
				sav = n;
				break;
			}
		}
		n++;
		switches++;
	}
	return(sav);
}

renews()
{
	char *clark(), *date();
	register n;

	if((flag & REVFLG) == 0) {
		n = maxnip - nip;
		if(n == 0) printf("no new news now.\n");
		if(n < 0) nip = maxnip;
	}

	while(getind(nip)) {
		nip++;
		if(p->date == 1) continue;
		n = (p->date + p->maxage*144. - today)/144.;
		if((flag & MORFLG) == 0 && n < 0) {
			if(n < -7) continue;
			printf("=== Item #%d out of date.\n",nip-1);
			continue;
		}
		printf("\n <*> Item %d from %s %s exp %c%d\n",
			nip-1,
			clark(p->byline),
			date(p->date),
			n>0?'+':'\0',
			n);
		getxt(p->addr);
		while(*txtp) if(*txtp++ == '\n') break;
		txtp[-1] = '\0';
		printf("%s\n",txtbuf);
		if(*txtp == '\0') continue;
		printf(" ... <more?>");
		if(read(0,ttyin,80) > 1)
			switch(*ttyin) {
				case 'n':
				case 'p':
					continue;

				case 'x':
					--nip;
					goto out;
			}
		printf("%s", txtp);
	}
out:
	if((flag & REVFLG) == 0) putnip();
}

wrnews()
{
	int q,n,taddr;
	struct {
		int dev;
		int inumber;
		int fflags;
		char nlinks;
		char uid;
		char gid;
		char size0;
		int size1;
		long junk[6];
	} buffer[];

	if(*arg) {
		stat(arg,buffer);
		if((uid == buffer->uid && (buffer->fflags & 0400)) ||
		   (gid == buffer->gid && (buffer->fflags & 0040)) ||
		   (uid == 0) || (buffer->fflags & 0004))
			inf = chkopen(arg,0);
		else {
			printf("%s isn't available to you: naughty, naughty.\n",
				arg);
			exit(-1);
		}
	}
	else {
		inf = 0;
		printf("Enter news item, end with ^d.\n");
	}
	resig();
	in = 0;
	while(q = read(inf,&ttyin[in],80)) {
		if(in || blank(ttyin,q) == 0) {
			in =+ q;
			if(in > 512) {
				printf("Max news item length is 512 chars.\n");
				brk();
			}
		}
	}
	if(inf != 0) close(inf);
	if(in == 0) return;
	ttyin[++in] = 0;
	while(link("/u1/lock",lockf) < 0) sleep(5);
	flag =| STOPF;
	getind(0);
	n = ndex[0].addr++;
	maxnip = ndex[0].addr;
	putind(0);
	getind(n);
	taddr = p->addr;
	p->byline = uid | gid<<8;
	p->date = today;
	p->maxage = expire;
	putind(n++);
	getind(n);
	p->addr = taddr + (in+1)/2;
	p->byline = 0;
	p->date = 0;
	ndleng =+ 8;
	putind(n);
	putxt(in,ttyin,taddr);
	unlink(lockf);
	flag =& ~STOPF;
}

revnews()
{
	if(*arg) nip = getinum(arg);
	else nip = 1;
	flag =| REVFLG;
	renews();
}

durnews()
{
	if(*arg) expire = atoi(arg);
	else expire = 14;
}

mornews()
{
	flag =| MORFLG;
	revnews();
}

cennews()
{
	register n;

	while(*arg) {
		n = getinum(arg);
		getind(n);
		while(*arg) if(*arg++ == ',') break;
		if(uid && uid != (p->byline&0377)) {
			printf("News item %d not submitted by you\n",n);
			continue;
		}
		p->date = 1;
		printf("News item %d [* C e* n s* o r* e d*]\n",n);
		putind(n);
	}
}

brk()
{
	if(flag & STOPF) {
		resig();
		return;
	}
	if(in) {
		pendf = creat(pending,0600);
		chown(pending,uid|gid<<8);
		write(pendf,ttyin,in);
		printf("Partial news item saved in 'pending.news'\n");
	}
	exit();
}

resig()
{
	signal(1,&brk);
	signal(2,&brk);
	signal(3,&brk);
}

getnip()
{
	if(nipf == 0) nipf = chkopen(nipfile,2);
	seek(nipf,uid<<1,0);
	read(nipf,&nip,2);
	return(nip);
}

putnip()
{
	if(nipf == 0) nipf = chkopen(nipfile,2);
	seek(nipf,uid<<1,0);
	write(nipf,&nip,2);
}

getind(ni)
{
	if(indxf == 0) indxf = chkopen(indexfile,2);
	if(ni < current || ni > current + 63) {
		seek(indxf,ni>>6,3);
		ndleng = read(indxf,ndex,512);
		current = ni & ~077;
	}
	p = &ndex[ni & 077];
	return(p->byline);
}

putind(ni)
{
	if(current != (ni & ~077)) printf("index error");
	seek(indxf,ni>>6,3);
	write(indxf,ndex,ndleng);
}

getxt(from)
{
	if(txtf == 0) txtf = chkopen(itemf,2);
	seek(txtf,from>>8,3);
	seek(txtf,from<<1&0776,1);
	read(txtf,txtbuf,512);
	txtp = txtbuf;
}

putxt(num,from,to)
char *from;
{
	if(txtf == 0) txtf = chkopen(itemf,2);
	seek(txtf,to>>8,3);
	seek(txtf,to<<1&0776,1);
	write(txtf,from,num);
}

chkopen(file,mode)
char *file;
{
	register handle;

	handle = open(file, mode);
	if(handle < 0) {
		printf("Unable to open %s in mode %d\n",file,mode);
		exit(-1);
	}
	return(handle);
}

getinum(cp)
char *cp;
{
	register n;

	n = atoi(cp);
	if(n < 0) n =+ maxnip;
	if(0 < n && n < maxnip) return(n);
	printf("Item %d?? Only items 1 - %d exist!\n",n,maxnip-1);
	exit(-1);
}

blank(buf,n)
char *buf;
{
	register m;
	register char *cp;

	m = n;
	cp = buf;
	while(--m >= 0) if(*cp++ > ' ') return(0);
	return(1);
}

char *date(day)
{
	char *cp;
	register i;
	double then;
	long timeno;

	then = day;
	i = (now - then) / 28800.;
	then =+ i*28800.;
	timeno = then * 600.;
	cp = ctime(&timeno);
	cp[16] = 0;
	return(cp);
}

char *clark(id)
{
	char i[80];
	register char *j;

	if(getpw(id, i) == 0) {
		for(j = i;*j;j++) {
			if(*j == '\n') break;
			if(*j == ':') {
				*j = '\0';
				break;
			}
		}
		return(i);
	}
	return(rand()>16384 ? "Lois Lane" : "Clark Kent");
}
