#define live 1560
#define si 017
#define ff 014
#define bs 010
#define ht 011
#define lf 012
#define so 016
#define SORT 0  /* default: don't sort the points */

/* LIFE */

int col[live],row[live],sym[live],change[live],nn;
int srt[live];
int curx,cury; /* current cursor location */
int ttyset[3],tty2;


cursor(x,y) /* x=column, y=row */
int x,y;
{	register int xx,yy;
	putchar(si);
	xx=x;
	yy=y;
	curx=xx;
	cury=yy;
	putchar((xx/10)*16+xx%10); /* column */
	putchar(yy<20 ? yy+0100 : yy+0140-20);
}

cmp(s,t)	/* for qsort routine */
int *s,*t;
{	register int *i,*j;
	i=s;
	j=t;
	if (*i<*j) return (-1);
	if (*i>*j) return (1);
	if (*i<*j) return (-1);
	return(1);
}


action(ch)    /* interpret the input and act accordingly */
char ch;
{
register int i,j,t;
switch (ch)    /* get a character from tty */
	{
	case 'q' : return(0); /* quit */
	case '.' : putchar('.'); putchar(bs);       /* clear */
			for (i=0; i<=nn; i++)
				if (curx==col[i] && cury==row[i])
					{for (j=i; j<nn; j++)
						{col[j]=col[j+1];
						row[j]=row[j+1];
						sym[j]=sym[j+1];
						change[j]=change[j+1];}
					nn--;
					break;	/* out of the i-loop */
					}
			return(1); /* end of clearing */
	case 'x' : putchar('X'); putchar(bs);
			for (i=0; i<=nn; i++)
				if (curx==col[i] && cury== row[i])
					return(1); /* x already there */
			nn++;
			col[nn]=curx;
			row[nn]=cury;
			sym[nn]='X';
			change[nn]=0;
			return(1);  /* end of live on */
	case so : if (cury-1>=0) cursor(curx,cury-1); return(1); /* up 1 */
	case lf : if (cury+1<=38) cursor(curx,cury+1); return(1); /* down 1 */
	case bs : if (curx-2>=0) cursor(curx-2,cury); return(1); /* left 2 */
	case 037 : if (curx+2<=79) cursor(curx+2,cury); return(1); /* right 2*/
	case 'z' : for (i=0; i<=nn; i++)
			{cursor(col[i],row[i]);
			putchar('.'); putchar(bs);
			}
			nn = -1;
			return(1);
	case 'd' : for (i=0; i<=nn; i++)
			{cursor(1,i);
			printf("%d of %d:(%d,%d):%c %d",i,nn,col[i],row[i],sym[i],change[i]);
			for (j=0; j<10; j++)
				{cursor(col[i],row[i]);
				putchar('.');
				putchar(bs);
				putchar(sym[i]);
				putchar(bs);}
			}
			return(1);
	case 'g' : melt();
			if (SORT)       /* from upper l to lower r */
			{       for (i=0; i<=nn; i++) srt[i]=row[i]+col[i]; /* init */
				qsort(&srt[0],nn+1,2,cmp);
				for (i=0; i<=nn; i++)
					{for (j=i; j<=nn; j++)
					   if (row[j]+col[j]==srt[i]) break;
					t=col[i]; col[i]=col[j]; col[j]=t;
					t=row[i]; row[i]=row[j]; row[j]=t;
					t=sym[i]; sym[i]=sym[j]; sym[j]=t;
					t=change[i]; change[i]=change[j];
						change[j]=t;
					}
			}
			j = -1;	/* rewrite ptr */
			for (i=0; i<=nn; i++)
			{
			if (change[i])
				{cursor(col[i],row[i]);
				putchar(sym[i]);
				putchar(bs);
				if (sym[i]=='+') sym[i]='X';
					else change[i]=0;
				}
			if (sym[i] != '.')
				{col[++j]=col[i];
				row[j]=row[i];
				sym[j]=sym[i];
				change[j]=change[i];
				}
			}
			nn=j;
			cursor(39,19);	/* center the cursor when done */
			return(1);
	}
} /* end of action */


main()
{
register int x,y;
char buf[3120];
nn = -1; /* nothing alive yet */
gtty(0,ttyset);
tty2=ttyset[2];
ttyset[2]=010341; /* no echo, raw mode, even or odd parity */
stty(0,ttyset);
putchar(ff); /* erase screen */

for (x=0; x<3120; x =+ 2) {buf[x]=' '; buf[x+1]='.';}
write(0,&buf[0],3120);
cursor(39,19);  /* start in middle */
while (action(getchar())); /* returns 0 when given a 'q' */

ttyset[2]=tty2;
stty(0,ttyset);
putchar(ff);
}
