#
/*
 *	motd -- show new message of the day
 *
 */

#define NLOG 64
#define NTIMES 3
#include "/usr/sys/sbuf.h"

struct{
	int uid;
	int pos1;
	char pos0;
	char cnt;
	int junk;
}  log[NLOG];

int count;
char buf[512];
char *banner	"/usr/news/banner";
char *logfile	"/etc/banner-log";
char *motd	"/etc/motd";

int fd1, fd2;

struct inode sbuf;

main(argc, argp)
char**argp;
{
	signal(2,0);
	fd1 = opn(motd, 0);
	display(fd1);
	close(fd1);
	fd1 = opn(banner, 0);
	fd2 = opn(logfile, 2);
	fstat(fd1, &sbuf);
	position(getuid()&0377);
	display(fd1);
	write(fd2, &log[0], count);
	exit(0);
}

position(user)
{
	register int i, j, k;

	while((count = read(fd2, &log[0], 512)) > 0){
		for(i=0; i<count/8; i++)
			if(log[i].uid == user)
				goto found;
	}

	/*
	 *	not in log file -- add him
	 */

	count = 8;
	log[0].uid = user;
	log[0].pos1 = sbuf.i_size1;
	log[0].pos0 = sbuf.i_size0;
	log[0].cnt = 0;
	return;

	/*
	 *	already in log file:
	 *
	 *	1)  update his entry
	 *	2)  position banner file for latest message
	 *	3)  setup log buf so that it can be simply
	 *	    written out to record his new position
	 */

found:

	if(log[i].pos1 == sbuf.i_size1 && log[i].pos0 == sbuf.i_size0)
		exit(0);
	k = (log[i].pos1 >> 9) &0177;
	k =| (log[i].pos0 <<7);
	if(k != 0)
		seek(fd1, k, 3);
	seek(fd1, log[i].pos1&0777, 1);
	seek(fd2, -count, 1);
	log[i].pos1 = sbuf.i_size1;
	log[i].pos0 = sbuf.i_size0;
	log[i].cnt++;
	return;
}

opn(file, rw)
{
	register fd;

	if((fd = open(file,rw)) < 0){
		printf("can't open file %s\n", file);
		exit(1);
	}
	return(fd);
}

display(fd)
{
	register cnt;
	char buff[512];

	while((cnt = read(fd, buff, 512)) > 0)
		write(1, buff, cnt);
}
