/ C library-- versions of long *, /, % for floating point hardware
/  also =* =% =/
/	Modified for use on machines with just fis.

.globl	lmul, ldiv, lrem, almul, aldiv, alrem

/
/ called: 2(sp):LHS 6(sp):RHS
lmul:
	mov	r3,-(sp)
LH=	4.
LL=	6.
RH=	8.
RL=	10.
	mov	LH(sp),r3
	mov	RL(sp),r0
	mul	r0,r3
	mov	LL(sp),r1
	jpl	0f
	add	r0,r3
0:
	tst	r0
	jpl	0f
	add	r1,r3
0:
	mul	RH(sp),r1
	add	r1,r3
	mul	LL(sp),r0
	add	r3,r0
	mov	(sp)+,r3
	rts	pc

lrem:
	mov	pc,remflag
	jbr	0f

ldiv:
	clr	remflag
0:
	mov	r5,-(sp)
	mov	sp,r5
	cmp	(r5)+,(r5)+	/Skip over saved r5 and return address.
	mov	(r5)+,r0
	mov	(r5)+,r1
	jsr	pc,do
	mov	(sp)+,r5
	rts	pc

/
/ called: 2(sp):ptr to LHS  4(sp):RHS
almul:
	mov	r2,-(sp)
	mov	r3,-(sp)
LP=	6.
RH=	8.
RL=	10.
	mov	LP(sp),r2
	mov	(r2)+,r3		/r3 = LH
	mov	RL(sp),r0		/r0 = RL
	mul	r0,r3
	mov	(r2),r1			/r1 = LL
	jpl	0f
	add	r0,r3
0:
	tst	r0
	jpl	0f
	add	r1,r3
0:
	mul	RH(sp),r1
	add	r1,r3
	mul	(r2),r0		/(r2) = LL; r0 = RL
	add	r3,r0		/r0 & r1 = the result
	mov	r1,(r2)
	mov	r0,-(r2)
	mov	(sp)+,r3
	mov	(sp)+,r2
	rts	pc

alrem:
	mov	pc,remflag
	jbr	0f

aldiv:
	clr	remflag
0:
	mov	r5,-(sp)
	mov	sp,r5
	cmp	(r5)+,(r5)+	/Skip over saved r5 and return address.
	mov	(r5)+,r1
	mov	(r1)+,r0
	mov	(r1),r1
	jsr	pc,do
	mov	r0,*4(sp)
	add	$2,4(sp)
	mov	r1,*4(sp)
	mov	(sp)+,r5
	rts	pc

do:
/Entered via
/	jsr	pc,do
/with
/	r0:	high dividend
/	r1:	low dividend
/	r5->	divisor
/
/On exit:
/	r0:	high quotient (or remainder, if remflag is nonzero)
/	r1:	low quotient (or remainder, if remflag is nonzero)
/	r5:	undefined
/	other registers unchanged

	mov	r4,-(sp)
	mov	r3,-(sp)
	mov	r2,-(sp)
	mov	(r5)+,r2
	mov	(r5),r3
	jne	0f
	tst	r2
	jeq	9f		/Like fpu, return dividend unconditionally.
0:

/	Magnitudinalize the divisor and dividend and set the flag word.
	clr	-(sp)
	tst	r0
	jpl	0f
	neg	r0
	neg	r1
	sbc	r0
	com	(sp)
0:
	tst	r2
	jpl	0f
	neg	r2
	neg	r3
	sbc	r2
	comb	(sp)
0:

/	Clear result; initialize number of bits left; loop.
	clr	r4
	clr	r5
	mov	$32.,-(sp)
0:
	asl	r1
	rol	r0
	rol	r5
	rol	r4
	cmp	r4,r2
	jlt	2f
	jgt	1f
	cmp	r5,r3
	jlt	2f
1:
	sub	r3,r5
	sbc	r4
	sub	r2,r4
	inc	r1
2:
	dec	(sp)
	jne	0b
	cmp	(sp)+,remflag		/Pop stack;test remflag
	jeq	0f

/	Remainder wanted.  Move to r0 and r1 and set up flag word.
	mov	r4,r0
	mov	r5,r1
	swab	(sp)

/	Make the result negative if need be.
0:
	tstb	(sp)+
	jeq	9f
	neg	r0
	neg	r1
	sbc	r0
9:
	mov	(sp)+,r2
	mov	(sp)+,r3
	mov	(sp)+,r4
	rts	pc

.bss
.even
remflag:	.=.+2
.text
