fsub=		075010^rts

/ fisitod is called with an integer on the stack.
/ It pops the integer off the stack,
/ and pushes the double-precision floating-point representation
/ of its value onto the stack.
.globl		fisitod
fisitod:
		mov		2(sp),-(sp)
		jpl		0f
		neg		(sp)
		mov		$0146000,-(sp)
		jbr		1f
0:
		mov		$0046000,-(sp)
1:
		clr		-(sp)
		mov		2(sp),-(sp)
		fsub		sp
		mov		4(sp),-(sp)
		clr		6(sp)
		clr		010(sp)
		rts		pc

/ fisdtoi is called with a double-precision floating-point number on the stack.
/ It pops the number off the stack,
/ and pushes the integer representation
/ of its value onto the stack.
.globl		fisdtoi
fisdtoi:
		mov		(sp)+,0f
		jsr		pc,fisdtol
		tst		(sp)+
		jmp		*0f
.bss
.even
0:		.=.+2
.text

/ fisltod is called with a long integer on the stack.
/ It pops the long integer off the stack,
/ and pushes the double-precision floating-point representation
/ of its value onto the stack.
.globl		fisltod
fisltod:
		mov		(sp)+,return

/	Align the long int on the stack;
/	take its absolute value and initialize the exponent part.
		mov		2(sp),-(sp)
		mov		2(sp),-(sp)
		jpl		0f
		neg		(sp)
		neg		2(sp)
		sbc		(sp)
		mov		$0146000,4(sp)
		jbr		1f
0:
		mov		$0046000,4(sp)
1:

/	Shift until there are 23 or fewer bits.
0:
		bit		$0177600,(sp)
		jeq		0f
		clc
		ror		(sp)
		ror		2(sp)
		add		$000200,4(sp)	/increment the exponent field
		jbr		0b
0:

/	Put the exponent part, then subtract to eliminate the implicit bit.
		bis		4(sp),(sp)
		clr		-(sp)
		mov		6(sp),-(sp)
		fsub		sp

/	Wrap up.
		clr		4(sp)
		clr		6(sp)
		jmp		*return

/ fisdtol is called with a double-precision floating-point number on the stack.
/ It pops the number off the stack,
/ and pushes the long integer representation
/ of its value onto the stack.
.globl		fisdtol
fisdtol:
		mov		(sp)+,return
		mov		r1,4(sp)

/	Generate the shift count for later
		mov		(sp),r1
		bic		$0100177,r1	/isolate the exponent field
		ash		$-7,r1
		sub		$128.+24.,r1	/128 is excess,24 is mant. length
		mov		r1,-(sp)

/	Load up r0&r1 with der number
		mov		4(sp),r1
		mov		r0,4(sp)
		mov		2(sp),r0
		bic		$0177600,r0	/clear out sign and exponent
		bis		$0200,r0	/set implicit bit

/	Normalize the beatie!
		ashc		(sp)+,r0

/	Signify the result
		tst		(sp)+
		jpl		0f
		neg		r0
		neg		r1
		sbc		r0
0:
		mov		r1,4(sp)
		mov		2(sp),r1
		mov		r0,2(sp)
		mov		(sp)+,r0
		jmp		*return

/ fiscmpf is called with 2 double-precision floating-point numbers on the stack.
/ 'A' was put on the stack first; 'B' was put on second.
/ Both are popped off the stack and the condition codes set such that
/ tests of the form
/	A > B
/ can be made (where > is, in actuality, any relational operator).
.globl		fiscmpf
fiscmpf:
		mov		(sp)+,016(sp)
		mov		(sp)+,2(sp)
		mov		(sp)+,2(sp)
		fsub		sp
		jeq		0f
		jmi		1f
		add		$6,sp
		tst		$-1
		rts		pc
0:
		add		$6,sp
		tst		$0
		rts		pc
1:
		add		$6,sp
		tst		$1
		rts		pc

/ fiststf is called with a double-precision floating-point number on the stack.
/ The number is popped off the stack,
/ and the condition codes are set to reflect its value.
.globl		fiststf
fiststf:
		mov		(sp)+,return
		tst		(sp)
		jpl		0f
		add		$10,sp
		tst		$-1
		jmp		*return
0:
		bis		(sp)+,(sp)
		bis		(sp)+,(sp)
		bis		(sp)+,(sp)
		jeq		0f
		mov		$1,(sp)+
		jmp		*return
0:
		tst		(sp)+	/Since it's zero, codes get set right.
		jmp		*return

/ fisnegf is called with a double-precision floating-point number on the stack.
/ It negates the number, leaving it on the stack.

.globl		fisnegf
fisnegf:
		tst		2(sp)
		jeq		0f		/Do nothing for zero.
		mov		r0,-(sp)
		mov		$0100000,r0
		xor		r0,4(sp)
		mov		(sp)+,r0
0:
		rts		pc

.bss
.even
return:		.=.+2
.text
