#
/* Interactive draugths playing program */

#define	VERSION	"1.11"
#define	DATE	"770426"

#include	"damdefs.h"

#define	MSIZE	3000
#define	GSIZE	1000

/*
   Numbering of the board:

	  00  01  02  03  04  05
	05  06  07  08  09  10
	  11  12  13  14  15  16
	16  17  18  19  20  21
	  22  23  24  25  26  27
	27  28  29  30  31  32
	  33  34  35  36  37  38
	38  39  40  41  42  43
	  44  45  46  47  48  49
	49  50  51  52  53  54
	  55  56  57  58  59  60
	60  61  62  63  64  65

   where the fields 0-5, 16, 27, 38, 49, 60-65
   constitute the edge of the board.
   Note: the fields with numbers divisible by 5
   form the main diagonal (see 'value(c)').
   Conversion tables:
 */

int conv[51]{ 0,
	 6, 7, 8, 9,10,
	11,12,13,14,15,
	17,18,19,20,21,
	22,23,24,25,26,
	28,29,30,31,32,
	33,34,35,36,37,
	39,40,41,42,43,
	44,45,46,47,48,
	50,51,52,53,54,
	55,56,57,58,59
};
int reconv[66]{
	 0,  0,  0,  0,  0,  0,
	   1,  2,  3,  4,  5,
	 6,  7,  8,  9, 10,  0,
	  11, 12, 13, 14, 15,
	16, 17, 18, 19, 20,  0,
	  21, 22, 23, 24, 25,
	26, 27, 28, 29, 30,  0,
	  31, 32, 33, 34, 35,
	36, 37, 38, 39, 40,  0,
	  41, 42, 43, 44, 45,
	46, 47, 48, 49, 50,  0,
	   0,  0,  0,  0,  0
};

int bord[66];
int game[GSIZE];
int *gp 	&game[0];
int moves[MSIZE];
int playb,playw,player;
int mvnr	1;	/* odd means black's move */
int lasthap	1;	/* draw if nothing happens for too long */
int drawdel	DRAWWT;	/* 3 or 10 or DRAWWT */
int me  	WHITE;	/* player to move */
int optp	1;	/* frequency of prbord() */
int rdif	100;	/* cannot be much larger */
int captct,captmax, *mpf,*mp0,*mp,possct;
int debug,crownmv;
int wpct,bpct,wkct,bkct;
int timeb,timew;	/* time used by b/w (in seconds) */

extern int pb,disp,dirt,prall,prbwait,userand;
extern int line[],rdbord[];

/* HP should get the same value as it has in ttytyp.c */
#define	HP	2

intrup(){
	signal(2,1);	/* no more interrupts */
	if(disp) delay();
	pmesg("?");
	rdlin();
	rdcomd(line);
	signal(2,intrup);
	if(!mpf){
		pmesg("you cannot change the board during an interrupt\n");
		reset();
	}
}

main(argc,argv) int argc; char **argv;{
int p;
char *ac;
	printf("dam %s version %s\n",VERSION,DATE);
	if(argc == 1){
		printf("do you want info? (y/n)\n");
		if(answer()) prinfo();
	}
	if(ttytype(1) == HP) disp++;
	if(signal(2,intrup) & 1) signal(2,1);
	setexit();
	if(mvnr > 1){
		prbord();
		if(!disp)
			printf("time used: W %d sec, B %d sec\n",
				timew,timeb);
		printf("another game?\n");
		if(!answer()) exit();
	}
	init();
	/* 2nd time here argc will be one */
	while(--argc) {
		ac = *++argv;
		if(*ac == '-') ac++;
		switch(*ac){
		case 'b':
		case 'z':
			playb = PDP;
			player++;
			break;
		case 'w':
			playw = PDP;
			player++;
			break;
		case 'd':
			disp++;
			break;
		case 'n':
			/* normal output even if terminal is a HP */
			disp = 0;
			break;
		case ':':
			debug++;
			break;
		case '\0':
			/* do not use random generator */
			userand = 0;
			break;
		default:
			rdcomd(ac);
		}
	}
	argc++;
	init2();
	for(me = WHITE; ; me = COL-me){
		mvnr++;
		timebeg();

		p = ((me == WHITE) ? playw : playb);
		if(p == USER) domove(readmove(me));
		else domove(findmove(me));

		if(me == WHITE) timew =+ timedif();
		else timeb =+ timedif();

		if((mvnr/optp)*optp == mvnr)prbord();
	}
}

init(){
register int i;
	/* check correctness of conv and reconv */
	for(i=1; i<=50; i++)
		if(reconv[conv[i]] != i)
			error("conv error");
	/* fill edge of the board */
	for(i=0; i<66; i++)
		if(reconv[i] == 0) bord[i] = EDGE;
	/* initial board position */
	for(i=1; i<=20; i++)
		bord[conv[i]] = BLACK;
	for(i=21; i<=30; i++)
		bord[conv[i]] = EMPTY;
	for(i=31; i<=50; i++)
		bord[conv[i]] = WHITE;
	timew = timeb = 0;
	lasthap = mvnr =1;
	crownmv = 0;
	mpf = &moves[0];
	gp = &game[0];
	prall++;
}

init2(){
	if(!player){
		printf("do you want me to play black? (y/n)\n");
		playb = answer()+1;
		printf("do you want me to play white? (y/n)\n");
		playw = answer()+1;
		dirt++;
	} else {
		if(!playb) playb = USER;
		if(!playw) playw = USER;
	}

	if(!mpf) mpf = moves; else
	if(optp)prbord();
}

prmove(mvpt) int *mvpt; {
int fin,ct,inh;
	prmvnr();
	prnum(*mvpt++);
	fin = *mvpt++;
	ct = *mvpt++;
	inh = (ct>1 ? 1 : 0);
	if(!ct){
		putchar('-');
		prnum(fin);
	} else {
		putchar('x');
		prnum(fin);
		putchar('(');
		while(--ct){
			prnum(*mvpt++);
			putchar(',');
		}
		prnum(*mvpt++);
		putchar(')');
	}
	pb = mvnr&1;
	pb =| inh;
	putchar(pb ? '\n' : '\t');
}

prnum(num) int num; {
	printf("%2d",reconv[num.lpart]);
}

/* fatal error routine */
error(s) char *s; {
	printf("%s\n",s);
	exit();
}

/* create list of all possible moves */

move(c) int c; {
register int i;
int c0;

	possct = 0;
	captmax = captct = 0;
	mp = mp0 = mpf;
	for(i=6; i<60; i++) if(((c0 = bord[i]) & COL) == c) {
		bord[i] = EMPTY;
		mp =+ 3;
		*mp0 = i+c0;
		capt(c0,i);
		mp =- 3;
		bord[i] = c0;
	}
	if(!captmax)
	for(i=6; i<60; i++) if(((c0 = bord[i]) & COL) == c) {
		if(c0 == WHITE) {
			hmove(c0,i,-6);
			hmove(c0,i,-5);
		} else if(c0 == BLACK) {
			hmove(c0,i,5);
			hmove(c0,i,6);
		} else {
			dmove(c0,i,-6);
			dmove(c0,i,-5);
			dmove(c0,i,5);
			dmove(c0,i,6);
		}
	}
}

/* king move in specified direction */
dmove(c,pos,dir) int c,pos,dir; {
register int i;
	for(i = pos+dir; bord[i] == EMPTY; i =+ dir){
		*mp++ = pos+c;
		*mp++ = i+c;
		*mp++ = 0;
		possct++;
	}
}

/* piece move */
hmove(c,pos,dir) int c,pos,dir; {
register int i;
	if(bord[i = pos+dir] == EMPTY){
		*mp++ = pos + c;
		*mp++ = prom(c,i);
		*mp++ = 0;
		possct++;
	}
}

/* partial capture in specified direction */
hcapt(c,pos,dir) int c,pos,dir; {
register int i,j;
int c1;
	if(c&DAM){
		for(i=pos+dir; (c1=bord[i]) == EMPTY; i =+ dir);
		if((c1 & MASK) != DAM+COL-c) return;
		j = i;
		bord[i] =| CAPT;
		captct++;
		*mp++ = i+c1;
		while(bord[j =+ dir] == EMPTY)
			capt(c,j);
		bord[i] = c1;
		captct--;
		mp--;
	} else {
		c1 = bord[i = pos+dir];
		if((c1 & MASK) != COL-c) return;
		if(bord[j=i+dir] != EMPTY) return;
		bord[i] =| CAPT;
		captct++;
		*mp++ = i+c1;
		capt(c,j);
		bord[i] = c1;
		captct--;
		mp--;
	}
}

capt(c,pos) int c,pos; {
register int *mp1;
int c1;
	hcapt(c,pos,-6);
	hcapt(c,pos,-5);
	hcapt(c,pos,5);
	hcapt(c,pos,6);
	if(captct == captmax){
		if(!captct) return;
		possct++;
		*++mp0 = prom(c,pos);
		*++mp0 = captct;
		mp0 =- 2;
		mp1 = mp;
		do { *mp++ = *mp0++; } while (mp0 != mp1);
		return;
	} else if(captct > captmax){
		captmax = captct;
		possct = 1;
		mp1 = mpf;
		*mp1++ = *mp0;
		*mp1++ = prom(c,pos);
		*mp1++ = captct;
		mp0 =+ 3;
		do { *mp1++ = *mp0++; } while(mp0 != mp);
		mp0 = mpf;
		mp = mp1;
		do { *mp1++ = *mp0++; } while(mp0 != mp);
		mp = mp1;
		return;
	}
}

prom(c,pos) int c,pos; {
	if(c&WHITE) {
		if(pos < 11) c =| DAM;
	} else	if(pos > 54) c =| DAM;
	return(pos+c);
}

/* execute actual move */
domove(mvpt) int *mvpt; {
register int i,*mp1;
int ct,ctd,cte;
int difflist[66];
	/* store move in array game */
	mp1 = mvpt;
	*gp++ = *mp1++;
	*gp++ = *mp1++;
	*gp++ = ct = *mp1++;
	while(ct--) *gp++ = *mp1++;
	if(gp+4 > &game[GSIZE]) error("overflow game array");

	/* change board position */
	mp1 = mvpt;
	bord[mp1++->lpart] = EMPTY;
	i = *mp1 & VAL;
	bord[mp1++->lpart] = i;
	ct = *mp1++;
	if(ct || !(*mvpt & DAM)) lasthap = mvnr;
	while(ct--) bord[mp1++->lpart] = EMPTY;

	/* check for repetition of moves */
	ct = cte = 0;
	ctd = mvnr-lasthap;
	if(ctd > 3){
		for(i=0; i<66; i++) difflist[i]=0;
		mp1 = gp;
		while(ctd--){	/* go back one move */
			if(*--mp1) error("capture after lasthap");
			i = *--mp1;
			if(i & (difflist[i.lpart] =^ (i&COL)))
				ct++;
			else	ct--;
			i = *--mp1;
			if(i & (difflist[i.lpart] =^ (i&COL)))
				ct++;
			else	ct--;
			if(difflist[0] =^ 1) ct++;
			else ct--;
			if(!ct) cte++;
		}
		if(cte == 2){
			pmesg("\nDraw by repetition of moves\n");
			reset();
		} else if(cte == 1) {
			pmesg("\nThis is the 2nd occurrence\
 of this position\n");
			pb = 1;
		}
	}
	/* check for three kings against one */
	pdistr();
	if((!wpct) && (!bpct) && (wkct+bkct == 4) && ((wkct&bkct) == 1)){
		drawdel = 10;
		ct = (wkct==1 ? WHITE : BLACK);
		/* single king on main diagonal? */
		for(i=10; i<60; i =+ 5)
			if(bord[i] & ct){
				drawdel = 3;
				break;
			}
	}
	if(mvnr-lasthap > drawdel*2){
		pmesg("\nDraw since nothing happened for %d moves\n",
			drawdel);
		reset();
	}
	/* %% */ if(debug) printf("FP %d\n",freepath());
}

pdistr(){	/* find distribution of white and black pieces */
register int i;
	wpct = wkct = bpct = bkct = 0;
	for(i=6; i<60; i++) switch(bord[i] & VAL){
	case WHITE:
		wpct++;
		break;
	case BLACK:
		bpct++;
		break;
	case WHITE|DAM:
		wkct++;
		break;
	case BLACK|DAM:
		bkct++;
		break;
	default:
		break;
	}
}

crown() {
register int i,v;
int pct,kct,kseen,save_i[2],sk;
	pct = kct = kseen = 0;
	for(i=1; i<=50; i++){
		v = bord[conv[i]] & VAL;
		if(v & me){
			if(kseen++ || (!(v & DAM))) goto err;
			else sk = i;
		} else {
			if(v & DAM) kct++;
			else if(pct == 2) goto err;
			else save_i[pct++] = i;
		}
	}
	if((kct + pct == 3) && pct){
		drawdel = ((sk/5)*5 == sk ? 3 : 10);
		lasthap = crownmv = mvnr;
		pmesg("%d pieces crowned to king\n",pct);
		pmesg("it will be a draw in %d moves\n",drawdel);
		while(pct--){
			bord[conv[save_i[pct]]] =| DAM;
		}
	} else {
	err:
		pmesg("crowning my pieces to a king is allowed only\n");
		pmesg("if I have 3 pieces among which 1 or 2 kings\n");
	}
}

findmove(c) int c; {
register int *mp1;
int	r,res,*mpg;
	move(c);
	if(!possct){
		pmesg("I lost\n");
		reset();
	}
	mpg = mpf;
	if(possct > 1) {
		res = -10000;
		for(mp1 = mpf; mp1<mp; ){
			r = result(mp1,res,10000);
			if(r > res) {
				mpg = mp1;
				res = r;
			} else if(r == res) {
				if((rand() & 070) == 0) mpg = mp1;
			}
			mp1 =+ 2;
			mp1 =+ (*mp1++);
		}
	}
	prmove(mpg);
	return(mpg);
}

result(mvpt,a,b) int *mvpt,a,b; {
register int i,*mp1;
int c,ct,r,res,*mpf0;
	mp1 = mvpt;
	c = *mp1 & COL;
	bord[mp1++->lpart] = EMPTY;
	i = *mp1 & VAL;
	bord[mp1++->lpart] = i;
	ct = *mp1++;
	while(ct--) bord[mp1++->lpart] = EMPTY;

	if(mp - moves > rdif){
		res = value(c);
		goto unmove;
	}

	mpf0 = mpf;
	mpf = mp;
	move(COL-c);
	res = b+1;
	for(mp1=mpf; mp1<mp; ){
		r = -result(mp1,-res,-a);
		if(r < res){
			res = r;
			if(res < a) break;
		}
		mp1 =+ 2;
		mp1 =+ (*mp1++);
	}
	mp = mpf;
	mpf = mpf0;

unmove:
	mp1 = mvpt;
	i = *mp1++;		/* be careful; perhaps start and
				   final position are the same! */
	bord[mp1++->lpart] = EMPTY;
	bord[i.lpart] = i & VAL;
	ct = *mp1++;
	while(ct--){
		i = *mp1 & VAL;
		bord[mp1++->lpart] = i;
	}

	return(res);
}

/* evaluation of position after recursion */
int info[66] {
	 0,  0,  0,  0,  0,  0,
	   1,  1,  1,  1,  1,
	 2,  2,  2,  2,  2,  0,
	   3,  3,  3,  3,  3,
	 4,  4,  4,  4,  4,  0,
	   5,  5,  5,  5,  5,
	 6,  6,  6,  6,  6,  0,
	   7,  7,  7,  7,  7,
	 8,  8,  8,  8,  8,  0,
	   9,  9,  9,  9,  9,
	10, 10, 10, 10, 10,  0,
	   0,  0,  0,  0,  0
};

value(c){
int sum,v,oc;
register int d,*bp,*ip;
	oc = COL - c;
	sum = 0;
	ip = &info[6];
	for(bp = &bord[6]; bp < &bord[60]; ){
		d = *bp++ & VAL;
		v = *ip++;
		if(d == EMPTY) continue;
		if(d == EDGE) continue;
		if(d&DAM){
			v = DVAL;
			/* increase value if on main diagonal */
			if(((bp-bord)/5)*5 == bp-bord) v =+ DMVAL;
		} else {
			if(d == WHITE) v = 11-v;
			v =+ PVAL;
		}
		if(d & oc) v = -v;
		sum =+ v;
	}
	return(sum);
}

/* check for free path (for oc) to a king */
int freect;

freepath(c) int c; {
register int *bp,*nbp,i;
int nbord[66],oc;

	oc = COL-c;

	/* copy */
	bp = bord;
	nbp = nbord;
	while(bp < &bord[66]) *nbp++ = *bp++;

	/* swell */
	for(nbp = &nbord[6]; nbp < &nbord[60]; nbp++){
		if((*nbp & COL) == c){
			if(*nbp & DAM) {
				dmark(nbp, -6);
				dmark(nbp, -5);
				dmark(nbp, 5);
				dmark(nbp, 6);
			} else {
				nbp[-6] =| FLAG;
				nbp[-5] =| FLAG;
				nbp[5] =| FLAG;
				nbp[6] =| FLAG;
			}
			*nbp = EDGE;
		}
	}

	/* but note: points on the border are always safe */
	nbp = nbord;
	for(i = 6; i<10; i++) nbp[i] =& VAL;
	for( ; i<65; i =+ 10){
		nbp[i++] =& VAL;
		nbp[i] =& VAL;
	}
	for(i = 56; i<60; i++) nbp[i] =& VAL;

	/* determine strong component of last line */
	freect = 0;
	if(c == WHITE){
		for(nbp = &nbord[55]; nbp < &nbord[60]; nbp++)
			reach(oc,nbp,-6);
	} else	for(nbp = &nbord[6]; nbp < &nbord[11]; nbp++)
			reach(oc,nbp,5);

	/* return number of pieces of opponent that can walk
	   freely to a king */
	return(freect);
}

dmark(nbp,d) int *nbp,d; {
register int *bp;
	bp = nbp + d;
	while((*bp & COL) == EMPTY){
		*bp = FLAG;
		bp =+ d;
	}
}

reach(oc,nbp,d) int oc,*nbp,d; {
register int *bp,v;
	bp = nbp;
	v = *bp & VAL;
	if(v == EDGE) return;
	if(v == oc) freect++;
	if(!(*bp & FLAG)){
		reach(oc,bp+d,d);
		reach(oc,bp+d+1,d);
	}
	/* prevent visiting this place twice */
	*bp = EDGE;
}

/* construct position after move k */
backup(k) int k; {
register int i,*gp0;
int mvno,c,ct;
	/* the validity of k was checked by the caller */
	if(rdbord[0])
		for(i=6; i<60; i++){
			if(bord[i] != EDGE) bord[i] = rdbord[i];
		}
	else {
		for(i=1; i<=20; i++) bord[conv[i]] = BLACK;
		for(i=21;i<=30; i++) bord[conv[i]] = EMPTY;
		for(i=31;i<=50; i++) bord[conv[i]] = WHITE;
	}
	gp0 = game;
	mvno = 1;
	while(k--){
		mvno++;
		if(mvno == crownmv) crown(); /* yields output %% */
		c = *gp0 & COL;
		bord[gp0++->lpart] = EMPTY;
		i = *gp0 & VAL;
		bord[gp0++->lpart] = i;
		ct = *gp0++;
		while(ct--) bord[gp0++->lpart] = EMPTY;
	}
	mvno++;
	if((mvno+mvnr) & 1) me = COL-me;
	mpf = 0;	/* the position has changed */
	gp = gp0;
	mvnr = mvno;
	if(lasthap > mvno) lasthap = mvno;
	if(crownmv > mvno) crownmv = 0;
}

/*
 * Implemented rules:
 *
 * a) If the same position occurs thrice (with the same
 *    player to move) it is a draw.
 * b) If a player has 3 pieces among which at least one
 *    king and his opponent has one king only, his opponent
 *    may crown all these pieces (which action does not
 *    count for a move). Immediately rule c) becomes applicable.
 * c) If the position is 3 kings against 1 king then after
 *	(single king on main diagonal ? 3 : 10)
 *    moves the game ends in a draw.
 *
 * In addition to these we use for PDP against PDP play the rule:
 *
 * z) If during DRAWWT moves no piece has been captured and only
 *    kings have moved it is a draw.
 *
 */
