#
/*	REMIND command -- Steve Zucker, April, 1975	*/
/*  Compile sharable, as super user and set mode 04555	*/

#define ABSOLUTE 0100000
#define MAXRCVRS 50
#define MAXMSG	 1000
#define DIRSIZE  254    /* No bigger than 254 */
int year, month, day, hour, minute;
char *loginfile {"/etc/utmp"};
char *usrfile	{"/etc/passwd"};
char *ttname	{"/dev/ttyx"};

char *rmdlock   {"/tmp/rmdlock"};       /* exists while proc is busy */
char *reminders {"/tmp/rmdfile"};
char *rmdproc   {"/tmp/rmdproc"};       /* contains proc id */
char *rmdtemp   {"/tmp/rmdtemp"};

char *dummy     {"/dev/null"};
char *nofile	{"Unable to open %s\n"};
char *invalid   {"Invalid argument ... %s\n"};

struct rmdblock
{	int	tdeliver[2];
	int	nobytes;
	int	tsent[2];
	char	sender[8];
	char	bits;
	char    dirsize;
	char	nrcvrs;
	int	msgbytes;
} m;

#define PRIORITY 01	/* bits */

char	rcvrlist[MAXRCVRS][8];
char	exdir[DIRSIZE];
char	msg[MAXMSG];

struct bfr
{	int	fd;
	int	nleft;
	char	*nextp;
	char	iobuffer[512];
} bf;

struct
{	char	*unsgnd1;	/* Unsigned dp integer */
	char	*unsgnd2;
}

main(argc, argv)
int argc;
char **argv;
{       register int i;
	register char *p;
	char c;
	int errflg;

	signal  (1,1);          /* Ignore Hangups */

	m.nrcvrs = m.msgbytes = m.bits = m.dirsize = errflg = 0;

	for (i = 1; i++ < argc;)
	{	p = *++argv;
		if (*p>='a' && *p<='z')
			puserid(p);	/* Alphabetic -- Receiver id */
		else if (*p == '-')
			pflags(&p[1]);	/* -flags */
		else if (getdt(p))	    /* Anything else - date or time */
			{       printf (invalid, p);
				errflg = -1;
			}
	}

	/* Get sender's name if from tty */
	if ((c = ttyn(0)) == 'x')
		strxfer("??",m.sender,3);
	else
		nametty(1,&c,m.sender);
	if (m.nrcvrs == 0)
		puserid(m.sender);
	if (checkusers() || errflg) exit();

	if (m.msgbytes == 0 && argc != 1) getmsg();

	m.nobytes = m.msgbytes + 8*m.nrcvrs + m.dirsize;

	while ((i = fork()) == -1) sleep(5);
	if (i) exit();  /* The rest will be done in background mode */

	if (dtime() && argc!=1)
		deliver();
	else
		enqueue();

}

char *notemp	{"Unable to create /tmp/rmdtemp. Remind is dead."};

enqueue()
{	register int slptime, i, fd;
	int fdlock, procid, newproc, fdrem, now[2];
	char endrem, written;
	struct rmdblock mm, *p;
	char rmddata[8*MAXRCVRS + MAXMSG + DIRSIZE];
	extern fout;

	signal(2,1);    /* Ignore interrupt */
	signal(3,1);    /* and quit */

	/* Wait for file to be usable */
	lock();

	/* Kill any existing reminder process that may be "sleeping" */
	if ((fd = open(rmdproc,2)) != -1)
	{	if (read(fd, &procid, 2) != 2)
			error("/tmp/rmdproc unreadable");
		kill (procid,9);
		seek(fd, 0, 0);
	}
	else
		fd = creat(rmdproc,0644);

	procid = getpid();
	write (fd, &procid, 2);
	close(fd);

	/* Put new reminder into reminder file (temp) in delivery order */
	if ((fdrem = open(reminders,0)) == -1)
		mm.tdeliver[0] = mm.tdeliver[1] = endrem = -1;
	else
		endrem = (read(fdrem, &mm, sizeof mm) <= 0);
	if ((slptime = tdiff(m.tdeliver,m.tsent))
		> (i = tdiff(mm.tdeliver,m.tsent)))
			slptime = i;
	if ((fd = creat(rmdtemp,0600)) == -1)
		error (notemp);

	for (written = 0;;)
	{       if (!endrem &&
			(written||(tdiff(mm.tdeliver, m.tdeliver) <= 0)))
		{	write (fd, &mm, sizeof mm);
			read (fdrem, &rmddata, mm.nobytes);
			write (fd, rmddata, mm.nobytes);
			endrem = (read(fdrem, &mm, sizeof mm) <= 0);
		}
		else if (!written)
		{	write (fd, &m, sizeof m);
			write (fd, rcvrlist, 8*m.nrcvrs);
			if (m.dirsize) write (fd, exdir, m.dirsize&0377);
			write (fd, msg, m.msgbytes);
			written++;
		}
		else break;
	}
	close (fd);
	close (fdrem);
	close (0);      /* dummy all standard files */
	open (dummy, 2);
	close (1);
	dup (0);
	close (2);
	dup (0);
	cleanup();

	for (;;)
	{	if (slptime > 0)
			sleep(slptime);
		lock();
		time(now);
		if ((fdrem = open(reminders,0)) == -1) bye();
		do
		{       if (read(fdrem, &m, sizeof m) <= 0) bye();
			if ((slptime = tdiff(m.tdeliver, now)) <= 0)
			{	read (fdrem, rcvrlist, 8*m.nrcvrs);
				if (m.dirsize)
				    read(fdrem, exdir, m.dirsize&0377);
				read (fdrem, msg, m.msgbytes);
				if (spawn() == 0)
				{	close(fdrem);
					deliver(); /* Child delivers */
				}
			}
		} while (slptime <= 0);

		/* Copy, removing delivered messages */
		if ((fd = creat(rmdtemp,0600)) == -1) bye();
		do
		{	read (fdrem, rmddata, m.nobytes);
			write (fd, &m, sizeof m);
			write (fd, rmddata, m.nobytes);
		} while (read(fdrem, &m, sizeof m) > 0);
		close (fdrem);
		close (fd);
		cleanup();
	}
}

bye()
{	unlink(rmdproc);
	unlink(rmdlock);
	unlink(reminders);
	exit();
}

cleanup()
{
	unlink (reminders);
	link (rmdtemp, reminders);
	unlink (rmdtemp);
	unlink(rmdlock);
}

struct
{	int x1[2];
	int ttflags;
	int x2[15];
} ttstat;

deliver()       /* Never returns */
{	register int i,j, ntts;
	char ttlist[32];
	int fd[2];

	if (m.dirsize)
	{	pipe(fd);
		if (spawn())
		{	/* Parent - write commands to shell */
			write (fd[1],"chdir ",6);
			write (fd[1],&exdir[1], (m.dirsize&0377)-1);
			write (fd[1], msg, m.msgbytes);
			close (fd[1]);
			close (fd[0]);
		}
		else
		{       /* Child - exec a shell */
			close (0);
			dup (fd[0]);
			close (fd[0]);
			close (1);		/* Dummy output files */
			open (dummy, 2);
			close (2);
			dup (1);
			close (fd[1]);
			setuid(*exdir);
			execl("/bin/sh","remindsh",0);
			exit();
		}
	}

	for (i = m.nrcvrs; i--; )
	{       if (ntts = nametty(0, ttlist, rcvrlist[i]))
		{	/* logged on the ntts ttys in ttlist */
			for (j = 0; j < ntts; j++)
			{	if (trysend(rcvrlist[i], ttlist[j]))
					continue;
				else  /* Spawn a proc to try every so often */
				{       if (spawn() != 0) continue;
					while(!trysend(rcvrlist[i],ttlist[j]))
						sleep(30);
					exit();
				}
			}
		}
		sendmail(rcvrlist[i]);  /* Whether logged in or not */
	}
	exit();
}

trysend(rcvr,tty) /* Returns 0 if can't send */
char *rcvr, tty;
{       register int fd;
	register int i;
	char ttnm[10];

	strxfer(ttname,ttnm,10);
	ttnm[8] = tty;

	if ((fd = open(ttnm,1)) == -1)
		return(0);

	if ((m.bits&PRIORITY)==0)
	{       if (fstat(fd,&ttstat) == -1)
		{       close(fd); return(1);}/* Treat no stat as delivered */
		if ((ttstat.ttflags&02) == 0)
		{       close(fd); return(0);}/* No write permission */
	}

	write(fd,"\7",1); /* Bell */
	send(fd,rcvr);  /* Closes fd */
	write(fd,"\7",1); /* Bell */
	close(fd);
	return(1);
}

sendmail(rcvr)
char *rcvr;
{       register int f, tries;
	char ch, rec[9];
	int fd[2], fdin[2];

	for (f = 0; (rec[f] = rcvr[f]) && ++f < 8; ) ;
	rec[f] = '\0';  /* Terminator for 8 char receiver name */
	tries = 5;
	do
	{       pipe(fd);
		pipe(fdin);
		if (spawn())
		{       close (fd[0]);
			close (fdin[1]);
			send(fd[1],rcvr);
			close(fd[1]);
			f = read(fdin[0], &ch, 1);
			close (fdin[0]);
		}
		else
		{       close (fd[1]);
			close (fdin[0]);
			if (fd[0])
			{       close(0);
				dup(fd[0]);
				close(fd[0]);
			}
			if (fdin[1] != 1)
			{       close(1);
				dup(fdin[1]);
				close(fdin[1]);
			}
			execl("/bin/mail","remindmail",rec,0);
			exit();
		}
	} while (f && tries--);
	return;
}

send(fd,rcvr)
int fd;
char *rcvr;
{       register char *p;
	register int i, t;
	int tt[3];
	char c;
	extern struct bfr *fout;
#define CRBIT 020 /* Print \n as CR LF */

	fout = fd;
	if (c = (ttyn(fout) != 'x'))
	{       gtty(fout,tt);
		if (((t = tt[2]) & CRBIT) == 0)
		{       tt[2] = t|CRBIT;
			stty(fout,tt);
		}
	}
	printf ("\n\n******************* MESSAGE *******************\n\n");
	printf (" From %.8s to %.8s\n", m.sender, rcvr);
	if (m.nrcvrs > 1)
	{       printf ("   List: ");
		for (i = 0; i < m.nrcvrs; )
		{       if (i%4 == 0 && i)
				printf ("\n         ");
			printf ("%-9.8s ", rcvrlist[i++]);
		}
		putchar('\n');
	}
	printf ("  Sent ........... %.24s\n", ctime(m.tsent));
	printf ("  For delivery ... %.24s\n\n", ctime(m.tdeliver));
	if (m.dirsize)
		printf("   The following was started as requested...\n\n");
	p = msg;
	for (i = m.msgbytes; i--; ) putchar(*p++);
	printf ("\n***********************************************\n\n");
	flush();
	if (c && t != tt[2])
	{       tt[2] = t;
		stty(fout,tt);
	}
	return(1);
}

/*	Forking is complicated by the fact that a process
 *	that exits becomes a "ZOMBIE".	It does not leave
 *	UNIX until it is waited for by its parent.  Thus,
 *	when remind spawns a process, it actually spawns
 *	a child and a grandchild, so that the grandchild,
 *	which actually does the work, will be adopted by
 *	the init process when the child exits.
 */
spawn()
{	register int k, l;
	int pstat;

	while ((k = fork()) == -1) sleep(10);
	if (k)
	{	wait(&pstat);	/* Wait for k below to exit */
		return (1);	/* Returns non-zero in parent */
	}
	else
	{	while ((l = fork()) == -1) sleep(10);
		if (l) exit();	/* After creating l, exit. */
		return(0);
	}
}

/* Use lock file as semaphore.  Can't run as superuser, so forks. */
lock()
{       register int i;
	int x;
	if (fork())
		wait(&x);
	else
	{       setuid(1);      /* 1 is bin, NOT root */
		while ((i = creat(rmdlock,0444)) == -1)
			sleep(5);
		close(i);
		exit();
	}
}

puserid(p)
char *p;
{	if (m.nrcvrs < MAXRCVRS)
		strxfer(p,rcvrlist[m.nrcvrs++],8);
	else
		printf ("Receiver list too long. '%.8s truncated\n", p);
}

puidfil(p)
char *p;
{	char username[8];
	register int c, i;

	if ((bf.fd = open(p,0)) == -1)
	{	printf (nofile,p);
		exit();
	}
	bf.nleft = 0;
	bf.nextp = bf.iobuffer;
	do
	{       while ((c=getc(&bf)) == '\n' || c==' ' || c=='\0' || c=='\t') ;
		for (i = 0;
			i<8 && (c!='\n' && c!=' ' && c!='\t'
			&& c!= -1 && c!='\0') ;
			c = getc(&bf))
				username[i++] = c;
		if (i < 8) username[i] = '\0';
		if (i > 0) puserid(username);
	} while (c != -1);
	close(bf.fd);
}

pflags(pp)
char *pp;
{	register char *p;
	register int i;
	p = pp;
	switch (*p++)
	{
	  case 'p':
		m.bits =| PRIORITY;
		return;
	  case 'x':
	  case 'e':
		*exdir = getuid(); /* Real user id */
		getwdir();              /* Working directory */
		return;
	  case 'm':
	  case 'r':
		for (i = 0; i<MAXMSG && (msg[i++] = *p++); ) ;
		m.msgbytes = --i;
		return;
	  case 'f':
		puidfile(p);	/* filename of receivers */
		return;
	  default:
		printf (invalid, p-2);
	}
}

getmsg()
{	register int i,c;
	register char *cp;
	bf.nleft = bf.fd = 0;
	bf.nextp = bf.iobuffer;
	cp = msg;
	for (i = 0; i++<MAXMSG && ((c = getc(&bf)) != -1); )
		*cp++  = c;
	if (i==MAXMSG) printf("...Message truncated\n");
	m.msgbytes = --i;
}

/* Get name of working directory to exdir[1]..., its length+1 to m.dirsize */
getwdir()
{       register int i;
	int fd[2], x;

	pipe(fd);
	while ((i = fork()) == -1) sleep(5);
	if (i)
	{	wait(&x);      /* Any address */
		exdir[1] = '/';
		i = read (fd[0], &exdir[2], DIRSIZE-2);
		if (i>0 && exdir[i+1] == '\n')
		{	m.dirsize = i+2;	/* uid, /, (name, \n) */
			close (fd[0]);
			close (fd[1]);
			return;
		}
	}
	else
	{       close (1);
		dup (fd[1]);
		execl("/usr/bin/pwd","remindpwd",0);
	}
	error("Bad working directory");
}

strxfer(pp,qq,nn)
/* Transfer string pp to qq, null padding to nn chars */
char *pp, *qq;
int nn;
{	register char *p, *q;
	register int n;
	p = pp;
	q = qq;
	for (n = nn; n && *p && *p!=' '; n--)
		*q++ = *p++;
	while (n--)
		*q++ = '\0';
}

nametty(flag, tt, nm)
int flag;	/* 1 to get name, 0 to get tty(s).
		 * If name or tty not found in login file (/etc/utmp),
		 * returns 0.  If flag is 1, returns name in nm and 1 as
		 * value.  If flag is 0, returns number of ttys at which
		 * user specified in nm is logged in, filling in the
		 * array tt with the tty names.
		 */
char *tt, *nm;
{	register int fd,i;
	register char *ttp;
	struct
	{	char	uname[8];
		char	utty;
		char	udummy[7];
	} logins;

	ttp = tt;
	if ((fd = open(loginfile,0)) == -1)
		return(0);
	while (read(fd,&logins,16) == 16)
	{	if (flag)
		{	if (logins.utty == *ttp)
			{	strxfer(logins.uname,nm,8);
				close(fd);
				return(1);
			}
		}
		else
		{	for (i = 0; i<8 &&
				logins.uname[i] == nm[i];
				i++ ) ;
			if (i >= 8 || (nm[i]=='\0' && logins.uname[i]==' '))
				*ttp++ = logins.utty;
		}
	}
	close(fd);
	return(ttp - tt);
}

checkusers()
/* Verify that all receivers exist (are in password file) */
{	register int i,c;
	register int found;
	char name[8];
	char foundflg[MAXRCVRS];
	if ((bf.fd = open(usrfile,0)) == -1)
	{	printf (nofile, usrfile);
		exit();
	}
	bf.nleft = 0;
	bf.nextp = bf.iobuffer;
	for (i = found = m.nrcvrs; i--; ) foundflg[i] = 0;

	do
	{	/* Get a name */
		for (i = 0; (c=getc(&bf)) != ':' && i < 8 && c != -1 ; )
			name[i++] = c;
		if (c == ':')
		{	while (i<8) name[i++] = '\0';
			for (i=0; i<m.nrcvrs; i++)
			{       if (foundflg[i]==0 && equal(name,rcvrlist[i]))
					if (--found <= 0)
					{       close(bf.fd);
						return(0);
					}
					else foundflg[i] = 1;
			}
			while ((c=getc(&bf)) != '\n' && c != -1) ;
		}
	} while (c != -1);
	for (i = 0; i<m.nrcvrs; i++)
		if (foundflg[i] == 0)
			printf("'%.8s' is not a UNIX user\n",rcvrlist[i]);

	close(bf.fd);
	return(1);
}

equal(pp,qq)
char *pp, *qq;
{	register char *p, *q;
	register int i;
	p = pp;
	q = qq;
	for (i = 8; i--; )
	{	if (*p != *q++) return(0);
		if (*p++ ==  '\0') break;
	}
	return(1);
}

dtime()
/* Compute delivery time.  Return 1 if NOW else 0. */
{	struct tunits
	{	int secs;
		int mins;
		int hrs;
		int dy;
		int mos;
		int yrs;
	};
	/* Externs from ctime */
	extern int dmsize[], timezone, *localtime();

	register struct tunits *p;
	register int f;
	register char *q;
	char datespec; /* Date specified flag */
	time(m.tsent);
	p = localtime(m.tsent);
	/* If some other day and no time spec, make 12:00 am. */
	if ( (datespec = (month|day|year) != 0) && (hour|minute) == 0)
		hour = minute = ABSOLUTE;

	/* Compute delivery time */

	f = fix(minute, p->mins);
	p->hrs =+ f/60;
	minute = f%60;

	f = fix(hour, p->hrs);
	p->dy =+ f/24;
	hour = f%24;

	day = fix(day, p->dy);
	while (day > (f = (p->mos==1 && p->yrs%4 ? 29 : dmsize[p->mos])))
	{	day =- f;
		if (++p->mos >= 12)
		{	p->mos = 0;
			++p->yrs;
		}
	}

	if (month&ABSOLUTE)
		month = (f = month&~ABSOLUTE) ? --f : f;
	else
		month =+ p->mos;
	p->yrs =+ month/12;
	month =% 12;
	++month;

	year = fix(year, p->yrs);
	if (year < 10) year =+ 70;

	/* Convert to seconds past 0000 1 Jan 1970 GMT using
	 * algorithm in date.c
	 */
	gtime();

	if ((f = tdiff(m.tdeliver,m.tsent)) > 0)
		return(0);
	else if (datespec == 0  && f < -60)  /* Try tomorrow, same time */
	{       for (f = 3; f--; )  /* Add 8 hours 3 times */
		{       q = m.tdeliver[1];
			if ((m.tdeliver[1] =+ 28800) < q)
				m.tdeliver[0]++;
		}
		if (tdiff(m.tdeliver,m.tsent) > 0)
			return(0);
	}
	return(1);
}

fix(x,y)
int x,y;
{	return(x&ABSOLUTE ? x&~ABSOLUTE : y + x);
}

tdiff(tim1,tim2)
int tim1[2], tim2[2];
{	/* Returns min(tim1-tim2, sgn(tim1-tim2)*32767) */
	register char *i, *j;
	register int k;
	if (tim1->unsgnd1 < tim2->unsgnd1)
		return (-32767);
	if (tim1->unsgnd1 > tim2->unsgnd1)
		return (32767);
	if ((i = tim1->unsgnd2) >= (j = tim2->unsgnd2))
	{       k = i - j;
		return (k&0100000 ? 32767 : k);
	}
	else
	{       k = j - i;
		return (k&0100000 ? -32767 : -k);
	}
}

/* Get date or time. */
getdt(pp)
char *pp;
{	char *p;
	register int i;
	p = pp;
	switch (*p++)
	{
	  case ':':
		minute = getinteg(&p);
		return(*p);
	  case '/':
		return(getdayr(&p));
	}
	p--;
	i = getinteg(&p);
	if (p==pp) return(1);
	switch (*p++)
	{
	  case '/':
		month = i;
		return(getdayr(&p));
	  case 'a':
	  case 'p':
	  case '\0':
		p--;
		hour = i;
		minute = hour&ABSOLUTE; /* If hr is relative, */
		break;			/* so is assumed mins */
	  case ':':
		hour = i;
		minute = getinteg(&p);
		if ((hour&ABSOLUTE) == 0 && (minute&ABSOLUTE))
			minute =& ~ABSOLUTE;
	}
	if (hour&ABSOLUTE)
		if (*p == 'p')
		{	if (p[1] == 'm')
			{	if ((hour&~ABSOLUTE) < 12)
					hour =+ 12;
				p =+ 2;
			}
		}
		else if (*p == 'a')
		{	if (p[1] == 'm')
			{	if ((hour&~ABSOLUTE) == 12)
					hour =- 12;
				p =+ 2;
			}
		}
	return(*p);
}

getdayr(pp)
char **pp;
{	char *p;
	day = getinteg(pp);
	if (*(*pp) == '/')
	{	(*pp)++;
		year = getinteg(pp);
	}
	return (*(*pp));
}

getinteg(pp)
char **pp;
{	register char *p;
	register int i;
	register int d;
	int flag;

	p = *pp;
	i = 0;
	if (*p == '+')
	{	flag = 0;
		p++;
	}
	else flag = ABSOLUTE;
	while ((d=digit(*p++)) >= 0)
	{	i =* 10;
		i =+ d;
	}
	if (--p == *pp) flag = 0; /* Treat null field as incremental 0 */
	*pp = p;
	return (flag|i);
}

digit(c)
char c;
{	return (c>='0' && c<='9' ? c - '0' : -1);
}
gtime()
{
	register int i;
	/* Externs from ctime */
	extern int dmsize[], timezone, *localtime();

	m.tdeliver[0] = m.tdeliver[1] = 0;
	year =+ 1900;
	for(i=1970; i<year; i++)
		gdadd(dysize(i));
	gdadd((year%4==0 && month>2 ? day : day-1));
	while(--month)
		gdadd(dmsize[month-1]);
	gmdadd(24, hour);
	gmdadd(60, minute);
	gmdadd(60, 0);
	/* convert to Greenwich time, on assumption of Standard time. */
		dpadd(m.tdeliver, timezone);
	/* Now fix up to local daylight time. */
		if (localtime(m.tdeliver)[8])
			dpadd(m.tdeliver, -1*60*60);
	return(0);
}

gdadd(n)
{
	register char *t;

	t = m.tdeliver[1] + n;
	if(t < m.tdeliver[1])
		m.tdeliver[0]++;
	m.tdeliver[1] = t;
}

gmdadd(k, n)
{	/* 0<m<127 (maybe more, but 127 is safe) */
	register int sc;  /* sum/carry */
	register char *c;
	c = m.tdeliver;
	c[2] = sc = k * (c[2]&0377);
	sc = sc>>8 & 0377;
	c[3] = sc =+ k * (c[3]&0377);
	sc = sc>>8 & 0377;
	c[0] = sc =+ k * (c[0]&0377);
	sc = sc>>8 & 0377;
	c[1] = sc + k * (c[1]&0377);
	gdadd(n);
}
error(s)
char *s;
{       extern fout;
	flush();
	fout = 2;
	printf ("%s\n",s);
	flush();
	exit();
}
