#define CLEARPAGE write(2,"\014\020",2);

int page 37;
int first 0;
int numop 0;
int vtunix 1;   /* assume we have virtual terminal unix */

int fi; /* file descriptor for the terminal input device */
int envir;

struct
{       int fildes;
	int nleft;
	char *nextp;
	char buffer[512];
} finput,fout;

struct window
{   char firstcol, firstrow;
    char lastcol,lastrow;
};

struct
{   struct window curw;
    struct window echow;
    struct window maxw;
    int flags[2];
} args;

intrap()                /* got a  bad system call                           */
{       vtunix=0;       /* flag it for later                                */
}                       /* and return to after the gvty                     */

main(argc, argv)
int argc;
char *argv[];
{       register char c;
	register int i,k;
	int j,int2(),exit(),err;

	signal(12,&intrap);     /* bad arg to sys call? */
	err=gvty(2,&args,8);    /* virtual terminal params */
	if (vtunix && err != -1)/* running off a virtual terminal */
		page=args.curw.lastrow-args.curw.firstrow-3;
	else if (vtunix) printf("gvty error\n");
	if (page<=0) page=1;    /* rather small window */
	k=0;
	for( i=1; i<argc; i++ )  /* look for - args */
	{	if( (c=argv[i][0]) == '-' )
		{	switch( argv[i][1] )
			{	case 'f': first=num(&argv[i][2]); /* set first line */
					  break;
				case 'n': numop=1; /* set number option */
					  break;
				case 'l':
				case 'p': page =num(&argv[i][2]); /* set page size */
					  if(page<=0) page=30000;
					  page--;
		}	}
		else argv[k++] = argv[i];
	}

	fout.fildes = dup(1);   /* JJG: for buffered tty output */
	signal(2,&int2); signal(3,&exit);
	if(k == 0) /* filter */
	{       if (envsave(&envir)) pfile();
		exit();
	}
	j = 0;
	envsave(&envir);
	while((i=j++) < k)
	{       if (finput.fildes) close(finput.fildes);
		if (k>1)
		{       puts("\014\020\n\n\npress <RETURN> to list ");
			puts(argv[i]);
			nextpage(1);
		}
		if (fopen(argv[i],&finput) == -1)
			puts("\n\ncannot open for reading!");
		pfile();
	}
}

pfile()
{       register char c;
	register int line,ct;
	CLEARPAGE;
	line = 1;
	if (numop) prtnum(first+1);  ct = page;
	while ((c = getc(&finput)) != -1)
	{	if(line>first) putchar(c);	/* JJG */
		if (c=='\n')
		{	if(line++ > first)
			{       if(--ct == 0)
				{       nextpage(1);
					ct = page;
				}
				if(numop) prtnum(line);
			}
		}
	}
	nextpage(0);
}

num(s)	 /* computes the internal form of a number */
char *s; /* are bad chars are ignored */
{	register int c,i,sign;
	sign=1;  i=0;
	while(c = *s++)
	{	if(c=='-' && sign==1) sign = -1;
		c =- '0';
		if(c>=0 && c<=9) i=i*10+c;
	}
	return(i*sign);
}

char ds[] "00000 | ";
prtnum(line)       /* prints the line number */
int line;
{	register char *s;
	register int d,n;   n=line;
	d=n%10; ds[4]=(n?d+'0':' '); n=/10;
	d=n%10; ds[3]=(n?d+'0':' '); n=/10;
	d=n%10; ds[2]=(n?d+'0':' '); n=/10;
	d=n%10; ds[1]=(n?d+'0':' '); n=/10;
	d=n%10; ds[0]=(n?d+'0':' '); n=/10;
	for(s=ds;*s;) putchar(*s++);
}

nextpage (clearpage)
{       char c;
	flush();
	do read(2,&c,1); while (c!='\n');
	if (clearpage) CLEARPAGE;
	return;
}

int2()
{       signal(2,&int2);
	fout.nleft = fout.nextp = 0;
	envrestore(&envir);
}

puts(ss) char *ss;
{       register char *s, *t;
	s = t = ss;
	while (*t++);
	write(2,s,t-s);
}
