#

/*****************************************************************

	VERSATEC printer/plotter driver
		Bill Allen (May 1975)
		Gerry Barksdale (June 1975)
			Naval Postgraduate School

*****************************************************************/

#include "/usr/sys/param.h"
#include "/usr/sys/conf.h"
#include "/usr/sys/user.h"
#include "/usr/sys/buf.h"

#define	VLADDR	0177424
#define	PLOTADR	0177420		//versatec plotter
#define	DMA 0177500
#define	DMABUSY	020000

#define	IENABLE	0100
#define	DONE	0200
#define	RLT		040	//remote line terminate

#define	VPPRI	10
#define	VPLWAT	50
#define	VPHWAT	100
#define	EJLINE	60
#define	MAXCOL	132

struct {
	int vpsr;
	int vpbuf;
};

struct	{
	int	plotbytes;
	int	addrext;
	int	printbytes;
	int	addr;
};

struct  {
	int	cc;
	int	cf;
	int	cl;
	int	flag;
	int	count;
	int	mcc;
	int	ccc;
	int	mlc;
} vp11;

int	vpstat;
struct	devtab	vptab;
struct	buf	rvpbuf;

#define	SPP	01	//simultaneous print plot
#define	EJECT	02
#define	OPEN	04
#define	RESET 02
#define	REOT	010		//remote eot for plotter
#define	EOT	004
#define	FORM	014

vlopen(dev, flag)
{

	if(vp11.flag & OPEN || VLADDR->vpsr < 0) {
		u.u_error = EIO;
		return;
	}
	vp11.flag = (OPEN) | (dev.d_minor ? SPP : 0);	//nonzero minor => SPP
	VLADDR->vpsr = IENABLE;
	vp11.count++;
}

vlclose(dev, flag)
{
	if(--vp11.count > 0)
		return;
	vlcanon(EOT);
//	sleep(&vp11,VPPRI);			//wait for eot to take
	vp11.flag = 0;
	vp11.count = 0;
}

vlwrite()
{
	register int c;

	while ((c=cpass())>=0)
		vlcanon(c);
}

vlcanon(c)
{
	register c1, c2;

	c1 = c&0177;
	switch(c1) {

	case '\t':
		vp11.ccc = (vp11.ccc+8) & ~7;
		return;

	case FORM:
	case '\n':
			vp11.mcc = 0;
			vloutput(c1);

	case '\r':
		vp11.ccc = 0;
		return;

	case 010:	//backspace
		vloutput('B');
		vloutput('S');

	case ' ':
		vp11.ccc++;
		return;

	default:
		if(vp11.ccc < vp11.mcc) {
			vloutput('\n');	//newline
			vp11.mcc = 0;
		}
		if(vp11.ccc < MAXCOL) {
			while(vp11.ccc > vp11.mcc) {
				vloutput(' ');
				vp11.mcc++;
			}
			vloutput(c1);
			vp11.mcc++;
		}
		vp11.ccc++;
	}
}

vlstart()
{
	register int c;

	while(((VLADDR->vpsr&DONE)||vpstat)&&(c=getc(&vp11))>=0)
		VLADDR->vpbuf = c;
}

vlint(dev)
{
	if (VLADDR->vpsr < 0) {		/* error bit */
		prdev("Versatec Print Error",dev);
		wakeup(&vp11);
		return;
	}
	vlstart();
	if (vp11.cc == VPLWAT || vp11.cc == 0)
		wakeup(&vp11);
}

vloutput(c)
{
	if (vp11.cc >= VPHWAT)
		sleep(&vp11, VPPRI);
	putc(c, &vp11);
	spl4();
	vlstart();
	spl0();
}

vpctl()
{
	while((PLOTADR->vpsr & DONE) == 0)
		sleep(&vp11,VPPRI);
	vpstat = PLOTADR->vpsr = u.u_arg[0]&077 | IENABLE;	//control bits
	vpstat =& SPP;
}

// routines for versatec plotter in DMA mode
vpopen(dev, flag)
{

	if(((vp11.flag & OPEN ) && !(vp11.flag & SPP)) || PLOTADR->vpsr < 0) {
		u.u_error = EIO;
		return;
	}
	vp11.flag =| (OPEN);
	vpstat=PLOTADR->vpsr=(IENABLE)|((vp11.flag&SPP)?SPP:0);
	vpstat =& SPP;
	vp11.count++;
}

vpclose(dev, flag)
{
	if(--vp11.count > 0)
		return;
//	while ((PLOTADR->vpsr&DONE) == 0)
//		sleep(&vp11,VPPRI);
//	PLOTADR->vpsr = REOT;	//end of plotting
	vp11.flag = 0;
	vp11.count = 0;
	vpstat = 0;
}

vpstrategy(abp)
struct buf *abp;
{
	register struct buf *bp;

	bp = abp;
	bp->av_forw = 0;
	spl4();
	if (vptab.d_actf==0)
		vptab.d_actf = bp;
	else
		vptab.d_actl->av_forw = bp;
	vptab.d_actl = bp;
	if (vptab.d_active==0)
		vpstart();
	spl0();
}

vpstart()
{
	register struct buf *bp;

	if ((bp = vptab.d_actf) && !(PLOTADR->vpsr & DMABUSY)) {
		vptab.d_active++;
		DMA->addr = bp->b_addr;	//clears addrext
		DMA->addrext = ((bp->b_xmem & 03) << 4);	//order important
		DMA->plotbytes = u.u_count;  //positive! & GO
		bp->b_resid = 0;
	}
}

vpint(dev)
{
	register struct buf *bp;
	if (PLOTADR->vpsr < 0) {		/* error bit */
		prdev("Versatec Plot Error",dev);
		wakeup(&vp11);
		return;
	}

	if (vptab.d_active == 0) {
		wakeup(&vp11);
		return;
	}
	vptab.d_active = 0;
	bp = vptab.d_actf;
	vptab.d_actf = bp->av_forw;
	iodone(bp);
	vpstart();
}

vpwrite(dev)
{
	if( !vpstat && !(VLADDR->vpsr & DONE) )
		sleep(&vp11,VPPRI);
	physio(vpstrategy, &rvpbuf, dev, B_WRITE);
	while(PLOTADR->vpsr & DMABUSY)
		sleep(&vp11,VPPRI);
	PLOTADR->vpsr = RLT | IENABLE | vpstat;	//remote line terminate
}
