#include	"pop.h"


/* Screen control functions which
 * are (or maybe) dependant of the vdu used.
 */


/* This is the function which sends the character
 * codes to position the cursor at character
 * position h and line position v.
 * h is 1 thru NCHARS, v is 1 thru NLINES.
 *
 * On our self-modified ITT 3210, the positioning
 * codes necessary are as follows:
 *
 * 1) send CONTROL+K
 * 2) send line position + 32
 * 3) send character position + 32
 */
s_cursor(h,v)
{
	do_push(11);
	do_push(v+32);
	do_push(h+32);
}


/* Clears the screen.
 * Only called once in the
 * initialization function do_init.
 *
 * On ITT 3210, a CONTROL+L clears it.
 */
s_clear()
{
	do_push(CLEAR);
}
