#include	"pop.h"


/* These functions operate in
 * RARE -ECHO -TBAS -ITT mode.
 *
 *
 * s_* routines are those which are dependant
 *     on the particular vdu used.
 * m_* routines are for the screen character map.
 * do_* routines do the io and are NON-USER.
 * p*  routines are USER and are for 'popout' 
 *     unless basic opening or close type routines.
 * pf*	routines are USER and are for 'popid' pop.
 */



pop popdesc[NPOPS];
int popout;

/* size of output buffer allows
 * for a character to be positioned and written
 * at all frames on the screen.
 * It is unnecessary for it to
 * be so large, but a large number
 * of write system calls are avoided
 * this way.
 */
#define SCRMAX	NLINES*NCHARS*4


/* output buffer structure */
struct {
	char *nextc;
	int nchar;
	char buf[SCRMAX];
} ttybuf;


/* Ctab defines the POP character
 * class of each character.
 *
 * To change the local edit characters
 * which these POP functions
 * interpret to move the cursor
 * forward or back by one position
 * without replacing a character,
 * insert the POP char classes
 * LEFT and RIGHT into the relevant
 * position in the array.
 * We use 'backspace' for back one
 * and 'control+a' for forward one.
 *
 * The entries in ctab not of any
 * POP class but referring to another
 * character c, are those that our ITT
 * terminals cannot display.
 * Instead they are represented by \c
 * (as for LCASE mode in the UNIX 6 tty.c).
 */
char ctab[] {
	IGN, RIGHT, IGN, IGN, IGN, IGN, IGN, BELL,
	LEFT, TAB,  NL, IGN, IGN,  CR, IGN, IGN,
	IGN, IGN, IGN, IGN, IGN, IGN, IGN, IGN,
	IGN, IGN, IGN, IGN, IGN, IGN, IGN, IGN,
	ONE, ONE, ONE, ONE, ONE, ONE, ONE, ONE,
	ONE, ONE, ONE, ONE, ONE, ONE, ONE, ONE,
	ONE, ONE, ONE, ONE, ONE, ONE, ONE, ONE,
	ONE, ONE, ONE, ONE, ONE, ONE, ONE, ONE,
	ONE, ONE, ONE, ONE, ONE, ONE, ONE, ONE,
	ONE, ONE, ONE, ONE, ONE, ONE, ONE, ONE,
	ONE, ONE, ONE, ONE, ONE, ONE, ONE, ONE,
	ONE, ONE, ONE, ONE, ONE, ONE, ONE, ONE,
	'\'', ONE, ONE, ONE, ONE, ONE, ONE, ONE,
	ONE, ONE, ONE, ONE, ONE, ONE, ONE, ONE,
	ONE, ONE, ONE, ONE, ONE, ONE, ONE, ONE,
	ONE, ONE, ONE, '(', '!', ')', '^', IGN,
};



/* All output must go through this routine.
 * If the char. written causes overflow in the pop popout,
 * it is not written and -1 is returned.
 *
 */
do_putc(rc)
char rc;
{
register pop *p;
register char ctype, c;
int tabs, n;

	p = &popdesc[popout];
	c = rc;
	switch (ctype = ctab[c&0177]) {
	case ONE:		/* chars that move cursor one to right */
		if (p->ch <= p->hmax) {
			do_push(c);
			m_store(c,p);
			p->ch++;
			return(c);
		}
		/* LBREAK mode not yet implemented */
		return(-1);

	case NL:
		if (p->cv < p->vmax) {
			p->cv++;
			p->ch = p->hmin;
			if ((p->mode&ROLL) && ((n = p->cv+1)<=p->vmax))
				do_cline(popout,n);
			s_cursor(p->ch,p->cv);
			return(c);
		}

		/* have line overflow here */

		if (p->mode & PAGE) {
			/* to home position */
			s_cursor(p->ch=p->hmin, p->cv=p->vmin);
			pflush();
			read(0,&rc,1);		/* wait for user response */
			do_break(p,rc);		/* break checked even here */
			pclear(popout);
			return(CLEAR);
		}
		if (p->mode & ROLL) {
			/* home, and clear top 2 lines */
			s_cursor(p->ch=p->hmin, p->cv=p->vmin);
			do_cline(popout,p->cv);
			do_cline(popout,p->cv+1);
			s_cursor(p->ch,p->cv);
			return(c);
		}
		return(-1);

	case CR:
		p->ch = p->hmin;
		s_cursor(p->ch,p->cv);
		return(c);

	case RIGHT:
		if (p->ch <= p->hmax) {
			p->ch++;
			s_cursor(p->ch,p->cv);
			return(c);
		}
		return(-1);

	case LEFT:
		if (p->ch > p->hmin) {
			p->ch--;
			s_cursor(p->ch,p->cv);
			return(c);
		}
		return(-1);

	case TAB:
		if (p->tabset) {
			tabs = p->ch - p->hmin;
			tabs =% p->tabset;
			tabs = -tabs;
			tabs =+ p->tabset;
			while (tabs--)
				if ((c = do_putc(SPACE)) != SPACE)
					break;
			return(c);
		}

	/* character output since people like
	 * bells, but treated as IGN otherwise
	 */
	case BELL:
		do_push(c);
	case IGN:
		return(0);

	default:
		if (p->mode & ITT) {
			do_putc('\\');
			if (p->ch <= p->hmax) {
				do_push(ctype);
				m_store(ctype,p);
				p->ch++;
				return(ctype);
			}
			return(-1);
		}
		return(0);
	}
}


/* This actually adds chars to the buffer after verification
 */
do_push(c)
char c;
{
	*ttybuf.nextc++ = c;
	if (++ttybuf.nchar >= SCRMAX)
		pflush();
}





/* forces output to the screen.
 * Called in many of these pop routines, and
 * may be called anywhere in other functions.
 */
pflush()
{
	write(2,ttybuf.buf,ttybuf.nchar);
	ttybuf.nextc = ttybuf.buf;
	ttybuf.nchar = 0;
}


/* clears pop popid and leaves the pop cursor at the top-left
 * if popid is popout.
 * Else re-addresses popout.
 */
pclear(popid)
{
register pop *p;
register v;

	if ((p = do_get(popid)) == -1)
		return(-1);
	p->ch = p->hmin;
	v = p->cv = p->vmin;
	while (v <= p->vmax)
		do_cline(popid,v++);
	pselect(popout);
	return(0);
}


/* Clears the POP line at screen line v.
 * As it stands, the function first checks
 * to see if its already clear and returns
 * if it is.  This is not necessary but
 * does save time if the line is clear.
 *
 * This is not a clean output
 * function, since ch and cv are not
 * correct while the output takes place.
 * Thus, cstore used.
 *
 * Called from pclear, pcline and
 * to clear lines when in ROLL mode.
 */

do_cline(popid,v)
{
register char c, *s1;
register h;
int n;
char *s2;
pop *p;
extern char screenmap[NLINES+1][NCHARS+1];

	p = &popdesc[popid];	/* no need to check popid */
	h = p->hmin;
	n = p->hmax;
	s1 = &screenmap[v][h];
	s2 = &screenmap[v][n];
	c = SPACE;
	while (*s1++ == c)
		if (s1 > s2)
			return;
	s_cursor(h,v);
	while (h <= n) {
		do_push(c);
		m_cstore(c,h++,v);
	}
}




/* Checks that popid is a valid and
 * open POP and returns a pointer to
 * the relevant pop structure.
 * If it is an invalid or unused
 * descriptor, then returns
 * (-1 * sizeof pop structure)
 * to correspond with comparisons
 * of pop structure pointers against
 * -1.
 * It must therefore always be assigned
 * to a pointer of type struct _pop.
 */
pop *do_get(popid)
{
register pop *p;

	if ((popid >= 0) && (popid < NPOPS)) {
		p = &popdesc[popid];
		if (p->ch)
			return(p);
	}
	return(-(sizeof popdesc[0]));
}



/* to open a new pop.
 * Returns pop descriptor (0-15) if good call.
 * (A pop descriptor is an index into the array
 *  of pop structures named 'popdesc'.)
 * If no pops left, then returns -1.
 *
 * Overlapping of pops is not checked.
 */
popen(sp)
struct {
	int h1, h2, v1, v2;
} *sp;
{
register pop *p;
register i,j;

	/* initialize output buffer if this is
	 * the first open call.
	 */
	if (ttybuf.nextc == 0)
		do_init();

	/* check screen positions given by arguments
	 * are sensible.  If not then fail.
	 */
	if ((sp->h1<1) || (sp->v1<1) || (sp->h2>NCHARS) || (sp->v2>NLINES)
				|| (sp->h2<sp->h1) || (sp->v2<sp->v1))
		return(-1);

	/* look for a free (unallocated) pop structure:
	 * this is indicated by 'ch' equal to zero
	 * (impossible otherwise)
	 */
	for (i = 0,p = &popdesc[i]; i<NPOPS; i++, p++)
		if (p->ch == 0) {
			p->ch = p->hmin = sp->h1;
			p->cv = p->vmin = sp->v1;
			p->hmax = sp->h2;
			p->vmax = sp->v2;
			p->mode = ECHO|ROLL|ITT;	/* default mode */
			p->tabset = 8;			/* default tab setting */
			for (j=0; j<NBREAKS; j++)
				p->brk[j].brkch = 0;	/* clear breaks */
			return(i);
		}
	return(-1);
}



int tmode[3], savetty;

/* Initialization function.
 *
 * Clears screen, sets up buffers
 * and tty mode and initializes screen
 * map to spaces.
 *
 * RARE mode is precisely the same
 * as RAW mode except interrupt and
 * quit signals are sent to process.
 */
#define T_ITT	0100000
#define T_RARE	040000
#define T_ECHO	010
#define T_TABS	02


do_init()
{

	ttybuf.nextc = ttybuf.buf;
	ttybuf.nchar = 0;
	gtty(0,tmode);
	savetty = tmode[2];
	tmode[2] =& ~T_ITT;
	tmode[2] =& ~T_ECHO;
	tmode[2] =& ~T_TABS;
	tmode[2] =| T_RARE;
	stty(0,tmode);
	popout = -1;
	s_clear();		/* clear screen */
	m_init();		/* initialize screen map */
}


/* exit function
 *
 */
pexit()
{

	s_cursor(1,NLINES);
	pflush();	/* force output at end */
	tmode[2] = savetty;
	stty(0,tmode);
	exit();
}



/* Change current pop to popid.
 * Called from all pf* fns to
 * move the screen cursor to the
 * FT for popid and also
 * for reselection of popout.
 *
 */
pselect(popid)
{
register pop *p;

	if ((p = do_get(popid)) == -1)
		return(-1);
	s_cursor(p->ch,p->cv);
	popout = popid;
	return(0);
}
