#
/*  A program for manipulating the Mailing List.
 *  Calling sequence:
 *       format -len +seq =key Filename Outfilename
 *
 *  where len is the maximum line length
 *        seq is the sequence order of fields with 0
 *            denoting a blank line
 *	  key is the separation character
 */

#define NFIELDS 10
char	sepchar '?';
int	length	32;

int	line[10]		{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1};
int	ibuf[259],obuf[259];
int	oversw;
int	n;
char	field [NFIELDS][133];

main(argc,av)
char **av;
{
	register char *p;
	register i,j;

	while (++av)  {
		p= *av;
		switch (*p) {
			case '=':	/* separation character */
				sepchar = *++p;
				continue;
			case '-':	/* length  */
				p++;
				length=0;
				while (*p != 0)
					length=10*length + (*p++ - '0');
				continue;
			case '+':	/* SEQUENCE   */
				p++;
				for ( i=0; i <10; i++ )  {
					if (*p == 0) break;
					line[i] = *p++ - '0';
				}
				continue;
		}
		break;
	}
	if (fopen(*av,ibuf) < 0) {
		printf ("Cannot read %s\n", *av);
		exit ();
	}
	av++;
	if (fcreat(*av,obuf) < 0){
		printf ("Cannot create %s\n", *av);
		exit ();
	}
	for ( n=1; getrec() == 0; n++)  {
		for (i=0; i<10; i++)  {
			j=line[i];
			if (j < 0) break;
			if( j == 0) {
				putc('\n',obuf);
				continue;
			}
			p = field[j-1];
			while (putc(*p++,obuf) != '\n');
		}
		if (oversw) printf ("Overflow in Record Number %d\n",n);
	}
	fflush(obuf);
}

getrec()
{
	register char c, *p, *pend;
	int i;

	oversw=0;
	for ( i=0; i < NFIELDS ; i++) {
		p=field [i];
		pend = p + length;
loop:		if ((c = getc(ibuf)) < 0) return (-1);
		if (c == sepchar) {
			*p++ = '\n';
			if (p > pend) oversw++;
			continue;
		}
		if (c == '\n') {
			*p++ = c;
			if (p > pend) oversw++;
			break;
		}
		*p++ = c;
		if (p > pend) --p;
		goto loop;
	}
	for ( ++i; i < NFIELDS ; i++) field [i][0] = '\n';
	return (0);
}
