#
#include "common.h"
/*
 *  mini-explor.  by ken knowlton, bell labs, murray hill, n.j. 2/21/75
 *  especially for minicomputers with at least 8k of 16 bit words
 *
 *  a 140x140 image, consisting of numbers 0-3, is packed 7 to a word
 *  as powers of 4 (20 words wide) and addressed as a 1-d array.
 *  an additional array /sngls/  holds up to 4 lines of unpacked numbers
 *  used by locop, where 3 unpacked lines are used to compute the new
 *  line into the 4th, and by show, which unpacks one line and composes
 *  in the other 3 the line images for overprinted output.
 *
 *  percentages not 100, in change, locop and combin, treated as follows.
 *  each routine takes numbers 0-198 directly from random table /rand/
 *  and compares with iprob = (percent*2-percent/51). if latter is .gt.
 *  table value, treat this cell.  the sequence taken from table is
 *  determined by random selection of a starting point (ipoint), a skip-
 *  ping distance (iskip), and a change in iskip (idlskp) between rows.
 *
 * store 16 numbers in a horizontal string, starting at ix,iy
 *
 *	converted to C by Lou Katz
 *	Columbia University, College of Physicians & Surgeons
 *	January 1976
 */
put16(ix,iy,n1,n2,n3,n4)
{

	if (iy<0 || iy>=nperl ||
	    ix< -15 || ix>=nperl)
		return;
	put4(ix   ,iy,n1);
	put4(ix+ 4,iy,n2);
	put4(ix+ 8,iy,n3);
	put4(ix+12,iy,n4);
}
/* store 4 numbers in a horizontal string, starting at ix,iy */

put4(ix,iy,n)
{
           if(iy<0 || iy>=nperl || n<0 ||
              ix<(-3) || ix>=nperl)
			return;
	put(ix  ,iy,(n/1000) % 10);
	put(ix+1,iy,(n/ 100) % 10);
	put(ix+2,iy,(n/  10) % 10);
	put(ix+3,iy,(n     ) % 10);
}
/* store one number on the map */

put(ix,iy,n)
{
	register int shift,index;

	if (frzzt)
		klear(&frzzt);

	if(n>3 || n<0)
		return;
	if(ix<0 || ix>=nperl ||
	   iy<0 || iy>=nperl)
		return;

        index = nperw * iy + ix/7;
	shift = 12 - (ix%7) * 2;

	LINE[index] =& ~(03<<shift);
	LINE[index] =| (n<<shift);
}
