
// Segment TE3

GET "te.hdr"

LET CHANGEIN(TYP) = VALOF
$( LET FILE = VEC 40
   AND COUNT = 0
   AND EC = ?

   UNLESS TYP = 0 DO COMM := RDCH()
   WHILE COMM = '*S' DO COMM := RDCH()

   IF COMM = '**' DO
   $( COMM := RDCH()
      TEST ISAV = 0 THEN
      $( WRITES("No alternate*N")
         RESULTIS FALSE
      $)
      OR
      $( TEST ISAV = ITXT THEN
         $( SELECTINPUT(TEXTIN)
            UNLESS NEWIN DO
               CURRTMP, EXHTMP, PARTMP, NEWIN :=
                  CURRENT, EXHAUSTED, PART, TRUE
               TEXTIN, CURRENT, EXHAUSTED, PART :=
                  ISAV, CURRSAV, EXHSAV, PARTSAV
         $)
         OR
            SELECTINPUT(ISAV)
         ENDREAD()
         WRITES("Closed*N")
         ISAV := 0
         SELECTINPUT(EDITS)
      $)
      RESULTIS TRUE
   $)

   UNTIL COMM = '*N' \/ COMM = '*S' DO
   $( COUNT := COUNT + 1
      PUTBYTE(FILE, COUNT, COMM)
      COMM := RDCH()
   $)
   PUTBYTE(FILE, 0, COUNT)

   TEST COUNT = 0 THEN
   $( IF TYP = 0 DO
      $( WRITES("Missing filename*N")
         RESULTIS FALSE
      $)
      IF ISAV = 0 THEN
      $( WRITES("No alternate*N")
         RESULTIS FALSE
      $)
      WRITES(ISAV = ITXT -> "Selected*N", "Alt selected*N")
      $( LET X = CURRSAV
         CURRSAV := CURRENT
         CURRENT := X
      $)
      $( LET X = EXHSAV
         EXHSAV := EXHAUSTED
         EXHAUSTED := X
      $)
      $( LET X = PARTSAV
         PARTSAV := PART
         PART := X
      $)
      UNLESS NEWIN DO
      $( PARTMP := PARTSAV
         CURRTMP := CURRSAV
         EXHTMP := EXHSAV
         NEWIN := TRUE
      $)
      $( LET X = ISAV
         ISAV := TEXTIN
         TEXTIN := X
      $)
   $)
   OR
   $( EC := FINDFASTINPUT(FILE)
      IF EC < 0 THEN
      $( IOERROR(-EC, FILE)
         RESULTIS FALSE
      $)

      TEST TYP NE 0 THEN
      $( WRITES("Opened*N")
         TEST ITXT = TEXTIN THEN
         $( SELECTINPUT(ISAV)
            CURRSAV := CURRENT
            EXHSAV := EXHAUSTED
            PARTSAV := PART
         $)
         OR
            SELECTINPUT(TEXTIN)
         IF ISAV NE 0 ENDREAD()
         ISAV := ITXT
         TEXTIN := EC
         UNLESS NEWIN DO
         $( CURRTMP := CURRENT
            EXHTMP := EXHAUSTED
            PARTMP := PART
            NEWIN := TRUE
         $)
         CURRENT := 0
         EXHAUSTED, PART := FALSE, FALSE
      $)
      OR
      $( LET J = ZCH
         ZCH := BIGNUM
         SELECTINPUT(EC)
         INSERT()
         ZCH := J
         ENDREAD()
         SELECTOUTPUT(VEROUT)
         NEWLINE()
      $)
   $)

   SELECTINPUT(EDITS)
   RESULTIS TRUE
$)



// Substitute string from REPLV for line positions P+1 to Q
// RSIZE is length of replacement string (less truncation)

LET SUBST(P, Q) BE
$( LET RSIZE = REPLSIZE
   AND TSIZE = LINEL - Q

   IF P + RSIZE + TSIZE > OLINEMAX THEN
      WRITEF("Line %N truncated*N", CURRENT)

   IF P + RSIZE > OLINEMAX DO RSIZE := OLINEMAX - P

   $( LET T = P + RSIZE
      IF T + TSIZE > OLINEMAX DO TSIZE := OLINEMAX - T
      LINEL := T + TSIZE

      UNLESS T = Q DO
         TEST T > Q
            THEN FOR I = TSIZE TO 1 BY -1 DO LINEV!(T + I) := LINEV!(Q + I)
            OR FOR I = 1 TO TSIZE DO LINEV!(T + I) := LINEV!(Q + I)

      FOR I = 1 TO RSIZE DO LINEV!(P + I) := REPLV!I
   $)
$)


// Returns index of first occurrence of string C
// after position P in current line
// Q = last possible slot
// N = length of sought context

AND INDEX(P, Q, C, N) = VALOF
$( IF EMPTY THEN RESULTIS -1

   UNTIL P > Q DO
   $( LET R = LINEV + P
      FOR I = 1 TO N UNLESS R!I = C!I GOTO L
      RESULTIS P

   L:
      P := P + 1
   $)

   RESULTIS -1
$)


// Read to V a context arg, up to 'DELIM' or EOL, & return length

AND READCONTEXT(V) = VALOF
$( FOR I = 1 TO CTXMAX DO
   $( COMM := RDCH()
      IF ((COMM = '*N') & NOTK) \/ COMM = DELIM RESULTIS I - 1
      V!I := COMM
   $)

   WRITES("Context too long*N")
   COMM := RDCH() REPEATUNTIL ((COMM = '*N') & NOTK) \/
                                  COMM = DELIM

   RESULTIS CTXMAX

$)

// Read 2 context args

AND ABEG.ARGS() BE
$( UNLESS REPEATING DO
   $( ABE.COMM := COMM
      DELIM := RDCH()
      ABEG.SIZE := READCONTEXT(ABEG.CON)
      REPLSIZE := (COMM = DELIM) -> READCONTEXT(REPLV), 0
   $)
   UNLESS COMM = '*N' DO COMM := RDCH()
$)


// Read 1 context arg

AND LF.ARG() BE
$( UNLESS REPEATING DO
   $( IF DELETING DO COMM := -COMM
      FL.COMM := COMM
      DELIM := RDCH()
      LF.SIZE := READCONTEXT(LF.CON)
   $)
   UNLESS COMM = '*N' DO COMM := RDCH()
$)


// Read numeric argument(s)
// '*' => end of source
// '.' => current line

AND NUMARGS(N) BE
$( COMM := RDCH()
   $( IF (SW.COMM NE 'H') & ('a' LE COMM LE 'z') THEN
         COMM := COMM + 'A' - 'a'
      SWITCHON COMM INTO
      $( DEFAULT:    RETURN

         CASE '*S':  COMM := RDCH()
                     LOOP

         CASE '**':  A0 := BIGNUM
                     COMM := RDCH()
                     ENDCASE

         CASE '.':   A0 := CURRENT
                     COMM := RDCH()
                     ENDCASE

         CASE '0': CASE '1': CASE '2': CASE '3': CASE '4':
         CASE '5': CASE '6': CASE '7': CASE '8': CASE '9':
            A0 := 0
            WHILE '0' LE COMM LE '9' DO
            $( A0 := A0 * 10 + COMM - '0'
               COMM := RDCH()
            $)
      $)

      A2 := A1
      A1 := A0
      IF STATE = N THEN WRITES("Too many args*N")
      STATE := STATE + 1
   $) REPEAT
$)

// Verify current line

AND OUT(TYP) BE
$( LET LAST.LINE = NEWIN -> EXHTMP, EXHAUSTED

   WRITEF("%N%C", (NEWIN -> CURRTMP, CURRENT), (LAST.LINE -> '**', '.'))
   IF (NEWIN -> PARTMP, PART) DO
      WRCH('P')
   NEWLINE()
   IF CND THEN CONDENSE()
   UNLESS EMPTY DO
   $( VERLINE()
      IF TYP NE 0 THEN
      $( STATIC $( SPCNT = 0 $)
         LET WCH(CH) BE
         $( FOR I = 1 TO SPCNT DO WRCH('*S')
            SPCNT := 0
            WRCH(CH)
         $)

         SPCNT := 0
         FOR P = 1 TO LINEL DO
         $( LET J = LINEV!P
            TEST 'a' LE J LE 'z' THEN WCH('$')
            OR TEST 'A' LE J LE 'Z' THEN WCH('%')
            OR TEST J = '*T' THEN WCH('T')
            OR TEST J = 0 THEN WCH('.')
            OR SPCNT := SPCNT + 1

            IF P REM VERMAX = 0 THEN
            $( NEWLINE()
               SPCNT := 0
            $)
         $)
         NEWLINE()
      $)
      IF POINTER = 0 RETURN
      FOR I = 1 TO (POINTER - 1)/VERMAX DO NEWLINE()
      FOR I = 1 TO (POINTER - 1) REM VERMAX DO WRCH('*S')
      WRITES("^*V")
   $)
$)

AND VERLINE() BE
$( FOR P = 1 TO LINEL DO
   $( UNLESS LINEV!P = 0 DO WRCH(LINEV!P)
      IF P REM VERMAX = 0 DO NEWLINE()
   $)
   NEWLINE()
   IF TCH = FMFD DO NEWLINE()
$)


// Insert material from EDITS before current line

AND INSERT() BE
$( MANIFEST $( ADIFF = 'a' - 'A' $)

   SELECTOUTPUT(TEXTOUT)
   UNTIL COMM = '*N' DO COMM := RDCH()

   $( CH := RDCH()
      IF CH = ENDSTREAMCH BREAK
      IF CH = ZCH \/ 'a' LE ZCH LE 'z' & (CH + ADIFF = ZCH) \/
                     'A' LE ZCH LE 'Z' & (CH - ADIFF = ZCH)
      $( CH := RDCH()
         IF CH = '*N' \/ CH = ENDSTREAMCH THEN
         $( SELECTOUTPUT(VEROUT)
            COMM := '*N'
            RETURN
         $)
         WRCH(ZCH)
      $)
      WRCH(CH)  
      UNTIL CH = '*N' DO
      $( CH := RDCH()
         IF CH = ENDSTREAMCH BREAK
         WRCH(CH)
      $)
   $) REPEAT
   SELECTOUTPUT(VEROUT)
$)


// Get new current line

AND READLINE() BE
$( LINEL, POINTER, EMPTY := 0, 0, FALSE
   UNLESS EXHAUSTED DO
   $( UNLESS PART DO CURRENT := CURRENT + 1
      PART := FALSE
      IF CURRENT = BIGNUM THEN
      $( WRITES("Line number overflow*N")
         CURRENT := -BIGNUM
      $)
      UNTIL LINEL = ILINEMAX DO
      $( TCH := RDCH()
         SWITCHON TCH INTO
         $( CASE RUBOUT:
               LOOP

            CASE '*N':
            CASE '*P':
            CASE '*V':
               RETURN

            CASE ENDSTREAMCH:
               BREAK
         $)

         LINEL := LINEL + 1
         LINEV!LINEL := TCH
	 IF TCH = '*T' THEN UNTIL LINEL REM TABSIZE = 0 DO
         $( LINEL := LINEL + 1
            LINEV!LINEL := 0
         $)
      $)
   $)
   TEST LINEL = 0 THEN
       EXHAUSTED, EMPTY := TRUE, TRUE
   OR  
      PART:=TRUE
$)

// Write out current line

AND WRITELINE() BE
   UNLESS EMPTY \/ DELETING DO
   $( IF CND THEN CONDENSE()
      SELECTOUTPUT(TEXTOUT)
      FOR P = 1 TO LINEL DO
         UNLESS LINEV!P = 0 DO WRCH(LINEV!P)
      IF TCH = '*N' \/ TCH = '*P' \/ TCH = '*V' THEN WRCH(TCH)
      SELECTOUTPUT(VEROUT)
      EMPTY := TRUE
   $)


AND NEXTLINE() BE
$( SELECTINPUT(TEXTIN)
   POINTER, UNCHANGED, NEWIN := 0, FALSE, FALSE
   WRITELINE(); READLINE()
   SELECTINPUT(EDITS)
$)


// Make line N current line

AND CHANGE(N) BE
$( IF N < CURRENT THEN
   $( WRITES("Number too small*N")
      RETURN
   $)

   IF N = CURRENT RETURN

   SELECTINPUT(TEXTIN)

   $( POINTER, UNCHANGED := 0, FALSE
      WRITELINE(); READLINE()
   $) REPEATUNTIL EXHAUSTED \/ (N = CURRENT)

   NEWIN := FALSE
   SELECTINPUT(EDITS)

$)


AND CONDENSE() BE
$( LET I, J, K = 0, 0, 0

   UNTIL I GE LINEL DO
   $( I := I + 1
      IF POINTER = I THEN
         POINTER := J + (LINEV!I > 0 -> 1, 0)
      IF LINEV!I > 0 THEN 
      $( J, K := J + 1, K + 1
         LINEV!J := LINEV!I
	 IF LINEV!I = '*N' THEN K := 0
	 IF LINEV!I = '*T' THEN
            UNTIL K REM TABSIZE = 0 DO
            $( J, K := J + 1, K + 1
               LINEV!J := 0
            $)
      $)
   $)
   LINEL := J
   CND := FALSE
$)


AND COMPRESS() BE
$( LET I, J = 0, 0

   UNTIL I GE LINEL DO
   $( I := I + 1
      IF POINTER = I THEN
         POINTER := J + (LINEV!I > 0 -> 1, 0)
      IF LINEV!I > 0 THEN
      $( J := J + 1
         LINEV!J := LINEV!I
      $)
   $)
   LINEL, CND := J, FALSE
$)


AND WIDEN() BE
$( LET TBUF = VEC OLINEMAX
   AND I, J, K, P = 0, 0, 0, 0

   FOR L = 1 TO LINEL DO
      TBUF!L := LINEV!L
   UNTIL (I GE LINEL) \/ (J > OLINEMAX) DO
   $( I := I + 1
      IF POINTER = I DO P := J + 1
      J, K := J + 1, K + 1
      LINEV!J := TBUF!I
      IF TBUF!I = '*N' DO K := 0
      IF TBUF!I = '*T' THEN
         UNTIL K REM TABSIZE = 0 DO
         $( J, K := J + 1, K + 1
            LINEV!J := 0
         $)
   $)

   IF J > OLINEMAX THEN
   $( J := OLINEMAX
      WRITEF("Line %N truncated*N", CURRENT)
      UNCHANGED := FALSE
   $)

   LINEL := J
   POINTER := P
$)
 .
