.pl 51
.po +10
.de FO
'bp
..
.de it
.tr __
.ul
.li
\\$1
..
.de HD
'sp
'tl 'TITAN Editor'- % -'Users Manual'
'sp 2
..
.nr p 6
.de PG
.sp
.ne 2
.ti +\\np
..
.de MH
.ne 8
.sp 4
.ul
\\$1
.br
..
.de ST
.ne 6
.sp 2
.ul
\\$1
..
.nr tl -17
.ta 15,25,33
.de TL
.sp
.ti \\n(tl
\\&\\$1	-\ 
..
.hy 14
.wh 0
.wh -7
.sp 18
.ce
A version of the Cambridge TITAN
.sp
.ce
editing system
.sp 2
.ce 1
R.D. Eager
.sp 2
.ce 1
May 1977
.pn 1
.wh 0 HD
.bp
.wh -7 FO
.MH "1.  Introduction"
.PG
This manual describes the general features of the editor. It does not
describe features which are implementation-dependent, e.g.
operating instructions, character set, etc. Instead, there is an Appendix
which describes the implementation-dependent features for each
implementation. These Appendices are available separately.
.PG
A few features of the editor as described in this manual may not be
present in some implementations. In addition, some implementations
may include extra features. See the relevant Appendix for details.
.MH "2.  General overview"
.PG
When called, the editor responds with the message:
.sp
	Ready
.sp
The user may then type his editing commands in the forms specified
below. These commands operate on a
.it "source file;"
they produce an edited
.it "output file."
The way these files are set up is implementation dependent.
.PG
At any time, there is a
.it "current line"
which is being pointed at; initially, the pointer is positioned before
the first line of the source file, and as editing proceeds, it
is moved 'down' the file under control of the user's editing
commands. Commands usually refer to the current line, or to lines
following the current line. One or more commands may be typed on a
single line, and after executing these commands the editor responds with
a copy of the current line, preceded by its line number. The line is
not displayed if it has already been typed out on the current pass through
the input file, and no significant change to it has been made.
.PG
In a command, a line number may be typed as an integer, as an asterisk
(*), or as a fullstop (.); a fullstop denotes the current line and an
asterisk denotes the end of the source file.
.PG
There is a maximum input line length, which is implementation
dependent, and lines longer
than this are automatically broken into part lines. When a command is
given to find a particular line, the line itself is typed out preceded
by its line number; if this is a part line, the line number is followed by a P;
if it is the last line of the source file, it is followed by an asterisk
(*). The exact definition of a line is given in Section 4.
.MH "3.  Editing commands"
.PG
In the following definitions, the symbol / (solidus) is used to denote
any delimiter character (including the space character) which may
be chosen by the user to delimit strings of characters in commands. Any
character, including newline, may be chosen as a delimiter, provided
that it is not contained in the string that it delimits. As an alternative,
a newline may be used as the closing delimiter of a command, or as
the middle delimiter in commands which contain two character strings.
.in +17
.ti -17
.ST "3.1.  To establish a line as the current line"
.sp
.TL Mn
.it move
the pointer to line n
of the source file.
.TL N
move the pointer to the
.it next
line or part line of the source file.
.TL "F/s/"
.it find
the next line
.it beginning
with the string s, and make it the current line.
.TL "L/s/"
.it locate
the next line
.it containing
the string s, and make it the current line.
.TL "+n"
move the pointer forward n
lines. If n
is omitted, it is assumed to be 1.
.TL "-n"
delete the next n lines.
If n is omitted, it is assumed to be 1.
.TL Tn
.it type
the next n lines,
and move the pointer to the last of these.
.TL U
set or reset no-verify mode. In this mode, the current line is
not automatically typed when a change is made. Repeated
use of this command sets and resets verification
alternately.
.TL V
type out the current line. This command is particularly useful
when in no-verify mode (but see also the
? command in Section 3.6.2).
.in -17
.ST "3.2.  To change the characters of the current line"
.PG
These commands operate on the current line or part line. Before any
editing is done, the length of the line or part line will not exceed
the implementation-defined maximum input line length;
in editing the line, it is not permitted
to extend the line or part line to greater than
an implementation-defined maximum output line length.
.in +17
.sp
.TL "A/s/t/"
insert string t
.it after
string s
in the current line. If s
is null, t
is inserted after the last character in the line.
.TL "B/s/t/"
insert string t
.it before
string s
in the current line. If s
is null, t
is inserted before the first character in the line (but see below).
.TL "E/s/t/"
.it extract
string s
and replace it with string t
in the current line. If t
is null, or absent together with the third delimiter, the effect
is to erase string s
from the current line.
.TL "G/s/t/"
.it globally
replace string s
by string t
wherever string s
appears in the current line and in succeeding lines of the source
file. Each line that is changed by this command is typed out, unless
no-verify mode is set. When this command is complete, the
pointer is repositioned at the beginning of the source file (this action
is equivalent to the * command, see Section 3.4).
.in -17
.PG
If a line contains several strings which are similar in form, then the
above commands can sometimes be inconvenient to use, since it is
then not easy to identify the particular string to be edited. This difficulty
can be overcome by use of the
.it "character pointer."
Whenever a new current line is selected, the character pointer is
always reset to point to a position
.it before
the first character of the line. The following commands enable the
pointer to be moved, with the effect that subsequent editing
commands will operate only on that part of the line
.it following
the character pointer.
.in +17
.sp
.TL "^ or >"
move the character pointer one character position to the right along the current line;
^^ or >> moves the pointer two positions, etc. Note that whenever the editor
verifies a line in which the character pointer has been moved to
the right, then the line is typed out with a ^ symbol
beneath the appropriate character.
.TL #
erase the next character to the right of the character pointer.
.TL "_ or <"
reset the character pointer to the beginning of the current line. Note that
the character pointer is automatically reset whenever a new
current line is selected.
.in -17
.PG
The first two of these commands may optionally be followed by an
integer, specifying how many times they are to be executed. It is,
however, often more useful simply to type the command the appropriate
number of times, since in normal use the character affected in the
current line will be immediately above the corresponding command.
This is particularly useful for selectively deleting parts of a line.
.ST "3.3.  Commands that operate on whole lines"
.in +17
.sp
.TL In
.it "insert,"
before line number
n, the line or lines of information which follow; the character 'Z'
on a line by itself terminates the information. The user may
choose an alternative character to use instead of 'Z', by use
of the
Z command (see below).
.TL "R m n"
.it replace
lines m to n inclusive with the line or lines of information which follow;
termination is as for the I command.
.TL "D m n"
.it delete
lines m to n inclusive.
.in -17
.PG
If n is the same as m
in the R and D commands, then
n may be omitted. If m and n are both omitted, the number of the current line is used.
.PG
The D command may also be combined with the
F and L commands, to delete from the current line up to, but not
including, a line specified by the F or L command:
.in +17
.sp
.TL "DF/s/"
delete up to next line
.it beginning
with the string s.
.TL "DL/s/"
delete up to next line
.it containing
the string s.
.in -17
.ST "3.4.  Other commands"
.PG
The following miscellaneous commands are also
available:
.in +17
.sp
.TL K
causes a newline character to be treated like any other character,
and not to act as a delimiter if it occurs within a character string in an
A, B, E, G, F, L, DF or DL command. Subsequent use of this command causes
the option to be reset and set alternately. It is always reset when processing
of a command line has been completed.
.TL Zc
use the character
c in place of 'Z' as the terminator for the I and R commands. If
c is a newline, the terminator is reset to 'Z'.
.TL "=n"
alter the editor's idea of the current line number to n. The position
within the source file is not altered.
This command is useful when continuing an interrupted
edit, or after use of the * command. It allows a user with a line-
numbered listing to get back 'in phase' with the editor.
.TL *
re-position the line pointer to the beginning of the source file. The
precise way in which this is done is implementation-dependent;
the output file may be renamed as a temporary file, then used as a source
file, or a new generation of  the output file may be created,
with the previous generation being used as the source file.
See the relevant Appendix for details.
.TL W
finish editing. This is the normal way to terminate an edit. Any remaining
material in the source file is copied to the output file, and any
temporary files are deleted after any necessary renaming.
Some implementations may write a backup copy of the original source
file. Again, see the relevant Appendix for details.
.TL Q
quit execution of edit, and exit immediately. Note that, in
this case, none of the copying, renaming or deleting descibed under W
above will take place. This command should be used whenever it is
required to abandon whatever one is editing.
.in -17
.ST "3.5.  Commands for experienced users"
.PG
The following commands are not essential to the use of the editor,
but are provided as as editing 'shortcuts' for the more experienced user.
.in +17
.sp
.TL '
repeat the last A, B or E command; if there has been
no previous command of any of these types, then the effect is
as if a V command had been given.
.    the next few lines are an effort to get a double quote
.    into the output, because poxy NROFF doesn't seem to
.    provide any method of giving a double quote as the
.    argument to a macro.
.tr ~"
.TL ~
.tr
advance the pointer by one line, then perform the same action
as for the ' command
\&.
.TL &
repeat the last F, L, DF or DL command; if there has been no
previous command of any of these types, then the effect is as if
a V command had been given.
.TL ,
advance the pointer by one line, then perform the same action
as for the & command.
.in -17
.ST "3.6.  Lower case characters"
.ST "3.6.1.  Editing commands"
.PG
The editor will accept editing commands in upper or lower case;
in addition, if the terminator to the I and R commands is a
letter, it will be accepted in either upper or lower case, regardless
of which is set.
.ST "3.6.2.  Edited text"
.PG
The following commands are provided to ease editing of lower
case text, particularly on terminals not supporting lower case.
.in +17
.TL $
if the character immediately to the right of the character pointer
is an upper case letter, convert it to lower case and advance
the character pointer. Otherwise, just advance the character pointer.
.TL %
similar to the $ command, but converts lower case letters
to upper case.
.TL ?
perform the same action as the
V command, then print a flag line underneath, marking upper case letters
by % and lower case letters by $. An indication is also given of
the position of any tabulate characters in the line (see Section 5).
.in -17
.PG
The $ and % commands may optionally be followed by an integer, which
is interpreted as for the ^, > and # commands.
.ST "3.7.  File manipulation"
.PG
In the descriptions of these commands, the term
.it filespec
means an implementation-defined way of specifying a file.
This may take several forms; e.g., the actual name of the file,
a channel or stream number, a logical or local name, etc. See the
relevant Appendix for details.
.in +17
.sp
.TL "C filespec________"
cause subsequent editing commands to be taken from the specified file;
if this file is subsequently exhausted, revert to the original input
medium for editing commands. Another C command in the specified
file causes that file to be closed, and the new one to be opened in its
place; thus only one auxiliary command file may be open at once.
If the original input medium is exhausted, the effect is as if
the W command had been given.
.TL "S filespec________"
select and open the specified file as an alternate source file.
Any previous alternate source file is closed. Subsequent
lines being edited are then read from the newly selected file.
.TL S
swop selection of source file. Repeated use of this command selects the
main source file and the alternate source file in turn.
.TL S*
close the alternate source file, reselecting the main source file if
necessary.
.TL "O filespec________"
select and open the specified file as an alternate output file.
Any previous alternate output file is closed. Lines subsequently
edited will be sent to the newly selected file.
.TL O
swop selection of output file. Repeated use of this command selects
the main output file and the alternate output file in turn.
.TL O*
close the alternate output file, reselecting the main output
file if necessary.
.TL "Hn filespec________"
insert a copy of the specified file before line
n of the source file. If n
is omitted, the insertion is made before the current line.
.in -17
.MH "4.  Line terminators"
.PG
Depending on the particular implementation, lines are normally
terminated by a newline character, or perhaps the logical
end-of-record. Some implementations may support form-feed and
vertical tabulate characters as alternatives. In this case,
any lines terminated by these characters have them temporarily replaced
by newline whilst the line is being processed by the editor.
This eases verification of the line. The terminator is restored when the
current line is written to the output file.
.PG
The stored character may be checked by means of the
colon (:) command. This causes output of one of
the following messages:
.in +17
.sp
.TL P
the line is a part line, and has no terminator.
.TL NL
the line is terminated by a newline character.
.TL FF
the line is terminated by a formfeed character.
.TL VT
the line is terminated by a vertcal tabulate character.
.in -17
.PG
The stored character may be altered by means of the semicolon
(;) command. This takes a single character as a parameter:
.in +17
.sp
.TL P
remove the terminator, thus changing the line into a part line. On
output, the line will be merged with the following line.
.TL N
alter the line terminator to a newline character.
.TL F
alter the line terminator to a formfeed character.
.TL V
alter the line terminator to a vertical tabulate character.
.in -17
.MH "5.  Treatment of tab characters"
.PG
The "width" of a tab character is implementation-dependent, but will
usually be 8 characters. On input, tabs are expanded into one tab
character followed by enough null characters to reach the next tab
stop. These null characters are included in any calculation of line
width, but are otherwise ignored. They cannot be directly deleted, but they disappear when
the tab preceding them is deleted, or the line is written to the
output file.
.PG
When the ? command is used to verify lines containing
tabs, the tab character itself is indicated by the letter
T in the flag line, and the null characters by a fullstop (.).
.MH "6.  Error messages"
.PG
All error messages output by the editor are
self-explanatory. Any error causes the rest of the current command line to
be ignored, and a copy of the current line to be typed
out. A new command may then be entered.
.MH "7.  Non-interactive use"
.PG
The editor will normally be run interactively, but some implementations
may allow offline editing. As mentioned in Section 6, errors normally
cause editing to continue with the next line of editing commands. Although this
is natural for on-line use, it may not be convenient off-line; the following
command is therefore available:
.in +17
.sp
.TL X
abandon editing if any errors are detected.
Subsequent use of this command causes the option to
be reset and set alternately.
.in -17
