#

/*
 *  mkdir - sets up a directory, with the "." and ".." entries
 */


#define	DIRECTORY	040000
#define	SUPERUSER	0

#define	EXECUTE	0
#define	WRITE	1
#define	READ	2

struct	stat  {
	int	dev;
	int	inumber;
	int	flags;
	char	nlinks;
	char	uid;
	char	gid;
	char	size0;
	int	size1;
	int	addr[8];
	int	actime[2];
	int	modtime[2];
	}  status;

struct	{
	char	u_uid;
	char	u_gid;
	};


char	area1[200], area2[200];
char	*name1	area1;
char	*name2	area2;
char	*n1, *n2, *slash, *c;
int	user, failure;


main( argc, argv )
int	argc;
char	**argv;
	{
	char	chr;

	/* Fish out the 'real' user id from getuid/gid */
	user.u_uid = getuid();
	user.u_gid = getgid();
	while(--argc > 0)  {
		argv++;
	/* Check the pathname for existence and access permission */
	slash = 0;
	n1 = name1 = area1;    n2 = name2 = area2;
	c = *argv;
	if ( (*n1++= *n2++= *c++) == '/' )
		slash = n1;
	while ( *c != '\0' )
		if ( (*n1++= *n2++= *c++) =='/')  {
			slash = n1 -1;
			*slash = '\0';
			if ( access( name1, EXECUTE) )
				exit(-1);
			*slash = '/';
			}
	*n1 = *n2 = '\0';

	/* Check for write permission in the parent */
	if ( slash != 0 )  {
		chr = *slash;
		*slash = '\0';
		if ( access( name1, WRITE) )
			exit(-1);
		*slash = chr;
		}
	else	if ( access( ".", WRITE) )
			exit(-1);

	/* Does file of the same name already exist ? */
	if ( stat( name1, &status) >=0 )  {
		printf(" %s  already exists\n", name1 );
		exit(-1);
		}


	if ( mknod( name1, DIRECTORY|0775, 0) <0 )  {
		failure = 4;
		goto fail;
		}
	*n2++ = '/';    *n2++ = '.';    *n2 = '\0';
	if ( link( name1, name2) < 0 )  {
		failure = 3;
		goto fail;
		}
	*n2++ = '.';    *n2 = '\0';
	/* Set name1 to parent of newdir */
	if ( slash != 0 )
		*slash = '\0';
	else	name1 = ".";
	if ( link( name1, name2) < 0 )  {
		failure = 2;
		goto fail;
		}
	/* Change the ownerships */
	*(n2=- 3) = '\0';
	if ( chown( name2, user) < 0 )  {
		failure = 1;
		goto fail;
		}
	continue;


fail:	switch ( failure )  {
	case 1:	*n2++ = '/';    *n2++ = '.';
		*n2++ = '.';    *n2 = '\0';
		unlink( name2);		/* remove newdir/.. */
	case 2:	*--n2 = '\0';
		unlink( name2);		/* remove newdir/.  */
	case 3:	*(n2 =- 2) = '\0';
		unlink( name2);		/* remove newdir */
	case 4:	printf("Failed to create  %s\n", name2 );
		exit(-1);
		}
	}
	}



#define	OWNER	0100
#define	GROUP	010
#define	WORLD	01

access( pathname, rwe )
char	*pathname;
int	rwe;
	{

	if ( stat( pathname, &status) < 0 )  {
		printf(" %s  does not exist\n", pathname);
		return(-1);
		}
	if( (status.flags &DIRECTORY) == 0 )  {
		printf(" %s  is not a directory\n", pathname);
		return(-1);
		}
	if ( (status.uid==user.u_uid  &&  status.flags&(OWNER<<rwe) )
	   ||  ( status.gid==user.u_gid  &&  status.flags&(GROUP<<rwe) )
	   ||  ( status.flags&(WORLD<<rwe))  ||  user.u_uid==SUPERUSER )
		return(0);
	printf(" %s  no permission\n", pathname );
	return(-1);
	}
