#
/*
 * rmdir - removes directories, if -r is given, then the empty
 *	parts of the the subtree of directory is removed
 */

#define	USAGE	"Usage is :  rmdir (-r) (-f) {directory}\n"

#define	DIRECTORY	040000
#define	SUPERUSER	0
#define	EXECUTE		0
#define	WRITE		1
#define	READ		2


struct {
	int	dev;
	int	inum;
	int	flags;
	char	nlink;
	char	uid;
	char	gid;
	char	siz0;
	char	siz1;
	int	addr[8];
	int	adate[2];
	int	mdate[2];
	}  status;

struct	{
	int	ino;
	char	name[16];
	}  entry;

struct	{
	char	u_uid;
	char	u_gid;
	}  user;


main(argc, argv)
char	*argv[];
	{
	char	*arg;
	int	i, qflag, rflag;

	argv++;    argc--;
	if ( argc == 0)  {
		printf( USAGE );
		exit();
		}

	qflag = 0;
	rflag = 0;
	for ( i=0; i<2; i++ )  {
		arg = *argv;
		if ( *arg++ == '-')
			if ( *arg == 'q')  {
				qflag++;
				argv++;    argc--;
				}
			else  if ( *arg == 'r')  {
				rflag++;
				argv++;    argc--;
				}
		}
	if ( argc == 0)  {
		printf( USAGE );
		exit();
		}

	/* Fish out the 'real' user id from getuid/gid */
	user.u_uid = getuid();
	user.u_gid = getgid();

	while ( argc-- > 0)
		rmdir( *argv++, qflag, rflag);
	}


rmdir(arg, qflag, rflag)
char	arg[];
int	qflag, rflag;
	{
	char	*chr, *letter, *slash;
	char	fname[200];
	int	b, i, entries, dirf, ccode, pid, newpid;

	if ( stat(arg, &status))  {
		printf("%s: non existent\n", arg);
		return;
		}
	if ((status.flags & 060000) != DIRECTORY)  {
		if ( qflag ==0  && rflag ==0)
			printf("%s: not a directory\n", arg);
		return;
		}

	if ( rflag )  {
		pid = getpid();
		if ( (newpid =fork()) == -1 )  {
			printf("%s: try again\n", arg);
			return;
			}
		if ( pid !=getpid() )  {
			if ( chdir(arg))  {
				printf("%s: cannot chdir\n", arg);
				exit(-1);
				}
			execl("/etc/glob", "glob", "-q", "/bin/rmdir", "-r",
				qflag? "-q": "*", qflag? "*": 0, 0);
			printf("%s: no glob\n", arg);
			exit(-1);
			}
		while ( wait(&ccode) !=newpid );
		}

	/* Check the pathname for existence and access permission */
	slash = 0;
	letter = fname;
	if ( (*letter++= *arg++) == '/' )
		slash = letter;
	while ( *arg != '\0' )
		if ( (*letter++= *arg++) == '/')  {
			slash = letter -1;
			*slash = '\0';
			if ( access( fname, EXECUTE) )
				exit(-1);
			*slash = '/';
			}
	*letter = '\0';

	/* Check for write permission in the parent */
	if ( slash != 0 )  {
		chr = *slash;
		*slash = '\0';
		if ( access( fname, WRITE) )
			exit(-1);
		*slash = chr;
		}
	else	if ( access( ".", WRITE) )
			exit(-1);

	if ( (dirf= open( fname, 0)) <0 )  {
		printf(" %s  cannot read\n", fname );
		exit();
		}
	entries = 0;
	while ( read( dirf, &entry, 16) == 16)
		if ( entry.ino != 0 )
			entries++;
	if ( entries >2 )  {
		if ( !qflag )
			printf("%s: not empty\n", fname);
		return;
		}

	/* unlink arg/.. arg/. and arg (in that order) */
	*letter++ = '/';	*letter++ = '.';
	*letter++ = '.';	*letter = '\0';
	unlink( fname);
	letter[-1] = '\0';
	unlink( fname);
	letter[-3] = '\0';
	unlink( fname);
	return;
	}



#define	OWNER	0100
#define	GROUP	010
#define	WORLD	01

access( pathname, rwe )
char	*pathname;
int	rwe;
	{

	if ( stat( pathname, &status) < 0 )  {
		printf(" %s  does not exist\n", pathname);
		return(-1);
		}
	if( (status.flags &DIRECTORY) == 0 )  {
		printf(" %s  is not a directory\n", pathname);
		return(-1);
		}
	if ( (status.uid==user.u_uid  &&  status.flags&(OWNER<<rwe) )
	   ||  ( status.gid==user.u_gid  &&  status.flags&(GROUP<<rwe) )
	   ||  ( status.flags&(WORLD<<rwe))  ||  user.u_uid==SUPERUSER )
		return(0);
	printf(" %s  no permission\n", pathname );
	return(-1);
	}
