#
/*
 * labeldisk - puts a GUCS Unix label on block 0 of a disk.
 */

#define	MAIN ;
#include	"label.h"


char	device[20];
int	filedes, flag, limit, i;
char	*labelp, *arg, *p, c;



main( argc,argv )
int	argc;
char	**argv;

	{

	argv++;    argc--;

	flag = false;
	arg = *argv;
	if ( *arg == '-' )  {
		if ( *++arg != 'a' )  {
			printf("Unknown flag:  %s\n", *argv );
			exit(-1);
			}
		flag = true;
		argc--;    argv++;
		}

	/* Check that it was called with 1 device argument */
	if ( argc != 1 )  {
		printf("Usage is:  labeldisk (-a) {device}\n");
		exit(-1);
		}

	/* Look at the existing label */
	switch ( check_label( *argv) )  {

	/* Block 0 carries a bootstap program */
	case BOOTPROGRAM:
		printf( "Disk has a bootstrap program, overwrite it ? ");
		if ( (c= getchar()) !='y' )
			exit(0);
		while ( c != '\n' )
			c = getchar();
		flag = true;
		break;
	/* Not currently labelled */
	case UNRECOGNIZED:
		flag = true;
		break;
	/* Disk already has a label */
	case VALIDLABEL:
		break;
		}

	/* Make up the label */
	limit =  flag ? label+512: label->serial;
	labelp = label;
	while ( labelp <limit )
		*labelp++ = '\0';

	/* Fill in the header */
	labelp = label->header;
	p = label_header;
	while ( *p !='\0' )
		*labelp++ = *p++;

	field( DISK_NAME, label->disk_name, label->mount_name );
	field( MOUNT_NAME, label->mount_name, label->devices );
	field( DEVICES, label->devices, label->description );
	field( DESCRIPTION, label->description, label->serial );
	if ( flag ==1 )
		field( SERIAL, label->serial, label+512 );

	/* Write out the label */
	filedes =  open( device, 1 );
	if ( write( filedes, label, 512) != 512 )  {
		printf("Failed to write label on disk\n");
		exit(-1);
		}
	exit(0);
	}


/* Read a field from the user, check its length, and fill it in */

field( name, data, data_end )
char	*name, *data, *data_end;
	{

	printf( "%s", name );
	while ( (c =getchar()) !='\n' )  {
		if ( data >=data_end -1)  {  /* makes sure string has a terminator */
			printf("Data too long\n");
			exit(-1);
			}
		*data++ = c;
		}
	}
