
/*
 *   M.out structure generation.
 */

struct	out	{
	int	ou_nseg;		/* segment no or SYMBOLS or RELOCATION */
	int	ou_start;		/* start addr of segment */
	int	ou_length;		/* seg len in bytes */
	}	out;

struct	aout	{
	int	ao_mword;		/* header - magic word */
	int	ao_bu_len;		/* byte width in bits */
	int	ao_startad;		/* execution start addr */
	}	aout;

struct	g_sym	{			/* symbol & literal table */
	char	gs_name[8];		/* symbol name */
	int	gs_value;		/* actual value */
	int	gs_mode;			/* symbol mode */
	int	gs_lcntr;		/* segment containing sym */
	};

struct	relocate  { /* Relocation info for a location if relocatable or
			relative to an undefined global */
	int	rel_type;	/* relocation type */
	int	rel_mask;	/* relocation bit mask */
	int	rel_addr;	/* address of item to be relocated */
	/* Other interesting info. which depends on the relocation type */
	union {
	 	int	rel_lcntr;	/* which locn cntr if not global ref */
		int	rel_gln;		/* index of global label */
	}rel_u;
};

#ifdef		PDP11

#define	MWORD	(011223)
#define MWORDR	(011222)

#endif


#ifdef		INTERDATA

#define	MWORD	(0371242)
#define MWORDR	(0371241)	/* magic wd for r-files */

#endif

#define	SYMBOLS		(-1)
#define RELOCATION	(-2)

#define	AOUT	(sizeof (struct aout))
#define	OUT	(sizeof (struct out))

/*
	Relocation types
*/
#define	RSTOR	0x0000	/* block storage - not used at the moment */
#define	RABS	0x4000	/* absolute - should never get into reloc info */
#define	RREL	0x8000	/* relocatable */
#define	RLBL	0xc000	/* relative to global label */
#define RPMOD	0x2000	/* pc-relative modifier */
