
.TH kb 1 "HFVR"
.SH NAME
.\" name \- one-line description for in permuted index
kba, kbc, kbk, kbq, kbu \- to work on knowhow database
.SH SYNOPSIS
.\" bnf on command syntax
kba [-e]
.br
kbc [-d] <query>
.br
kbk [-d] <query>
.br
kbq [-d] <query>
.br
kbu [-d] <query>
.SH DESCRIPTION
.\" semantics
kb (Knowledge Base) is a simple database to store items of
information under certain key words. The items can then be
retrieved from this database via the key words.
.sp
kba [-e] will prompt for info which is then stored into the knowhow
database. When the -e option is given the $EDITOR is used to enter
the information.
.sp
kbc <query> will give count of items from knowhow database which
are specified by the <query> (see below).
.sp
kbk <query> will print out the keys of the items from the knowhow database
which are specified by the <query>. (See below).
.sp
kbq <query> will print all items from the knowhow database which 
are specified by the <query> (see below).
.sp
kbu <query> will present all items which are specified by <query> (see below)
to the editor one by one. After the edit session the items are updated in the
knowhow database.
.SH QUERY
The <query> can be described in BNF as follows:
.nf
<query> ::= <term> { OR <term> }*

<term> ::= <factor> { AND <factor> }*

<factor> ::=   <key>
                | NOT <factor>
                | ( <query> )

<key> ::= <anything alphanumeric>

STANDARD        ALTERNATIVES
--------        ------------
NOT             !       ~       not
AND             &       &&      and
OR              |       ||      or
(               [       {       <
)               ]       }       >
.fi
.SH OPTIONS
.tr ^
.in +6
.ti -6
-d^^^^turns on debug mode, to show internal KBCODE. (For experts only).
.in -6
.SH EXAMPLES
.nf
kba      # just follow the prompt
kba -e   # use $EDITOR to input information
kbq test # list all items with keyword 'test'
kbq 'test or trial' # list all item with keywords test or trial
kbq 'sh & not ksh'  # list all items about sh but not about ksh
kbu test # edit and update all items with keyword 'test'
.fi
.SH FILES
$HOME/.knowhow.*
.SH VARABLES
.nf
$EDITOR set to favorite editor (default is /bin/ed)
$KNOWHOW set to knowhow database
.fi
.SH SEE ALSO
dbadd, dbcreate, dblist, dbprint in $TOOLS/lib/gmacs/man
.SH ATTENTION
The knowhow database is compatible with the gmacs(1) database Mlisp
routines: fetch-database-entry, put-database-entry, 
extend-database-search-list, list-databases
