.TH PF 1 
.UC 4
.SH NAME
pf \- print file with automatic multi-columning
.SH SYNOPSIS
.B pf
[ option ] ...
[ file ] ...
.SH DESCRIPTION
.I Pf
produces a printed listing of one or more
.I files.
If there are no file arguments, or if a file name is '\-' 
.I pf
prints its standard input.
.PP
Options apply to all following files:
.TP
.BI \- F
Specify footer information \- see note which follows options.
.TP
.BI \- H
Specify header information \- see note which follows options.
.TP
.BI \- d
Don't break a page for each file \- continue in next column.
.TP
.BI \- e
Ensure all the columns on a page are of equal width.
.TP
.BI \- f
Produce true action for formfeeds, i.e. move to next page. The default
action is to move to the top of the next column.
.TP
.BI \- h
Produces a list of options.
.TP
.BI \- j
Causes the text to be justified to the right hand column (old behavior).
.TP
.BI \- l\fPn
Set the length of the page to '\fin\fP' (the default is 66 lines).
.TP
.BI \- m\fPn
Set the maximum number of columns to use to '\fin\fP' (default is the page
width).
.TP
.BI \- s\fPn
Set the minimum width to separate columns by to '\fin\fP' (the default is 1).
.TP
.BI \- t\fPn
Set the width to which tabs are expanded to '\fin\fP' (the default is 8).
.TP
.BI \- w\fPn
Set the width of the page to '\fin\fP' (the default is 132 positions).
.PP
The header and footer options \fBH\fP and \fBF\fP, respectively allow
specification as follows:
.LP
Mere inclusion indicates that headers and footers are required.
.LP
Either can be followed immediately by one of \fBl\fP, \fBc\fP or \fBr\fP
which mean that the next argument will be the \fIleft\fP, \fIcentre\fP or
\fIright\fP header or footer respectively. The \fBs\fP specification,
immediately followed by a number will give the vertical size of the header
or footer,
.br
e.g.
\fBFs3\fP indicates that footers are to be placed in three lines at the
bottom of the page.
.LP
The three headers or footers are placed on a single line in the middle of
the vertical space.
.SH NOTE
.I Pf
knows about control characters and escape sequences of length two:
it assumes these to print in zero width and will print them even if the line
has been truncated because it is longer than a page.
These means that bold will get turned off properly when the line is too long.
To prevent this behavior,
put the input through
.I colrm
first.
.SH AUTHOR
Crispin Goswell
.SH "SEE ALSO"
cat(1), colrm(1), pr(1)
