LESS(l)

NAME
     less - opposite of more

SYNOPSIS
     less [-cdepstwmMqQuU] [-h_n] [-b[fp]_n] [-x_n] [+_c_m_d] [_n_a_m_e] ...

DESCRIPTION
     _L_e_s_s is a program similar to _m_o_r_e (1), but which allows backwards
     movement in the file as well as forward movement.  Also, _l_e_s_s does not
     have to read the entire input file before starting, so with large
     input files it starts up faster than text editors like _v_i (1).  _L_e_s_s
     uses termcap, so it can run on a variety of terminals.  There is even
     limited support for hardcopy terminals.  (On a hardcopy terminal,
     lines which should be printed at the top of the screen are prefixed
     with an up-arrow.)

     Commands are based on both _m_o_r_e and _v_i. Commands may be preceeded by a
     decimal number, called N in the descriptions below.  The number is
     used by some commands, as indicated.


COMMANDS
     h    Help: display a summary of these commands.  If you forget all the
          other commands, remember this one.

     SPACE
          Scroll forward N lines, default one screen.  If N is more than
          the screen size, only one screenful is displayed.

     f    Same as SPACE.

     b    Scroll backward N lines, default one screen.  If N is more than
          the screen size, only one screenful is displayed.

     RETURN
          Scroll forward N lines, default 1.  If N is more than the screen
          size, the entire N lines are displayed.

     e    Same as RETURN.

     j    Also the same as RETURN.

     y    Scroll backward N lines, default 1.  If N is more than the screen
          size, the entire N lines are displayed.

     k    Same as y.

     d    Scroll forward N lines, default 10.  If N is specified, it
          becomes the new default for all d and u commands.

     u    Scroll backward N lines, default 10.  If N is specified, it
          becomes the new default for all d and u commands.

     r    Repaint the screen.

     R    Repaint the screen, discarding any buffered input.  Useful if the
          file is changing while it is being viewed.

     g    Go to line N in the file, default 1 (beginning of file).
          (Warning: this may be slow if N is large.)

     G    Go to line N in the file, default the end of the file.  (Warning:
          this may be slow if standard input, rather than a file, is being
          read.)
     p    Go to a position N percent into the file.  N should be between 0
          and 100.  (This is possible if standard input is being read, but
          only if _l_e_s_s has already read to the end of the file.  It is
          always fast, but not always useful.)

     %    Same as p.

     m    Followed by any lowercase letter, marks the current position with
          that letter.

     '    Followed by any lowercase letter, returns to the position which
          was previously marked with that letter.  All marks are lost when
          a new file is examined.

     /pattern
          Search forward in the file for the N-th occurence of the pattern.
          N defaults to 1.  The pattern is a regular expression, as
          recognized by _e_d. The search starts at the second line displayed
          (but see the -t option, which changes this).

     ?pattern
          Search backward in the file for the N-th occurence of the
          pattern.  The search starts at the line immediately before the
          top line displayed.

     n    Repeat previous search, for N-th occurence of the last pattern.

     E    Examine a new file.  If the filename is missing, the "current"
          file (see the N and P commands below) from the list of files in
          the command line is re-examined.

     N    Examine the next file (from the list of files given in the
          command line).  If a number N is specified (not to be confused
          with the command N), the N-th next file is examined.

     P    Examine the previous file.  If a number N is specified, the N-th
          previous file is examined.

     =    Prints the name of the file being viewed and the byte offset of
          the bottom line being displayed.  If possible, it also prints the
          length of the file and the percent of the file above the last
          displayed line.

     -    Followed by one of the command line option letters (see below),
          this will toggle the setting of that option and print a message
          describing the new setting.

     V    Prints the version number of _l_e_s_s being run.

     q    Exits _l_e_s_s.

     The following two commands may or may not be valid, depending on your
     particular installation.

     v    Invokes an editor to edit the current file being viewed.  The
          editor is taken from the environment variable EDITOR, or defaults
          to "vi".

     ! shell-command
          Invokes a shell to run the shell-command given.

OPTIONS
     Command line options are described below.  Options are also taken from
     the environment variable "LESS".  (The environment variable is parsed
     before the command line, so command line options override the LESS
     environment variable.  Options may be changed while _l_e_s_s is running
     via the "-" command.) For example, if you like more-style prompting,
     to avoid typing "less -m ..." each time _l_e_s_s is invoked, you might
     tell _c_s_h:

     setenv LESS m

     or if you use _s_h:

     LESS=m; export LESS

     -s   The -s flag causes consecutive blank lines to be squeezed into a
          single blank line.  This is useful when viewing _n_r_o_f_f output.

     -t   Normally, forward searches start just after the top displayed
          line (that is, at the second displayed line).  Thus forward
          searches include the currently displayed screen.  The -t command
          line option causes forward searches to start just after the
          bottom line displayed, thus skipping the currently displayed
          screen.

     -m   Normally, _l_e_s_s prompts with a colon.  The -m command line option
          causes _l_e_s_s to prompt verbosely like _m_o_r_e, printing the file name
          and percent into the file.

     -M   The -M command line option causes _l_e_s_s to prompt even more
          verbosely than _m_o_r_e.

     -q   Normally, if an attempt is made to scroll past the end of the
          file or before the beginning of the file, the terminal bell is
          rung to indicate this fact.  The -q command line option tells
          _l_e_s_s not to ring the bell at such times.  If the terminal has a
          "visual bell", it is used instead.

     -Q   Even if -q is given, _l_e_s_s will ring the bell on certain other
          errors, such as typing an invalid character.  The -Q command line
          option tells _l_e_s_s to be quiet all the time; that is, never ring
          the terminal bell.  If the terminal has a "visual bell", it is
          used instead.

     -e   Normally the only way to exit less is via the "q" command.  The
          -e command line option tells less to automatically exit the
          second time it reaches end-of-file.

     -u   If the -u command line option is given, backspaces are treated as
          printable characters; that is, they are sent to the terminal when
          they appear in the input.

     -U   If the -U command line option is given, backspaces are printed as
          the two character sequence "^H".  If neither -u nor -U is given,
          backspaces which appear adjacent to an underscore character are
          treated specially: the underlined text is displayed using the
          terminal's hardware underlining capability.

     -w   Normally, _l_e_s_s uses a tilde character to represent lines past the
          end of the file.  The -w option causes blank lines to be used
          instead.

     -d   Normally, _l_e_s_s will complain if the terminal is dumb; that is,
          lacks some important capability, such as the ability to clear the
          screen or scroll backwards.  The -d flag suppresses this
          complaint (but does not otherwise change the behavior of the
          program on a dumb terminal).

     -p   Normally, _l_e_s_s will repaint the screen by scrolling from the
          bottom of the screen.  If the -p flag is set, when _l_e_s_s needs to
          change the entire display, it will clear the screen and paint
          from the top line down.

     -h   Normally, _l_e_s_s will scroll backwards when backwards movement is
          necessary.  The -h option specifies a maximum number of lines to
          scroll backwards.  If it is necessary to move backwards more than
          this many lines, the screen is repainted in a forward direction.
          (If the terminal does not have the ability to scroll backwards,
          -h0 is implied.)

     -x   The -x_n command line option sets tab stops every _n positions.
          The default for _n is 8.

     -b   The -b_n command line option tells _l_e_s_s to use a non-standard
          buffer size.  There are two standard (default) buffer sizes, one
          is used when a file is being read and the other when a pipe
          (standard input) is being read.  The current defaults are 5
          buffers for files and 12 for pipes.  (Buffers are 1024 bytes.)
          The number _n specifies a different number of buffers to use.  The
          -b may be followed by "f", in which case only the file default is
          changed, or by "p" in which case only the pipe default is
          changed.  Otherwise, both are changed.

     -c   Normally, when data is read by _l_e_s_s, it is scanned to ensure that
          bit 7 (the high order bit) is turned off in each byte read, and
          to ensure that there are no null (zero) bytes in the data (null
          bytes are turned into "@" characters).  If the data is known to
          be "clean", the -c command line option will tell _l_e_s_s to skip
          this checking, causing an imperceptible speed improvement.
          (However, if the data is not "clean", unpredicatable results may
          occur.)

     +    If a command line option begins with +, the remainder of that
          option is taken to be an initial command to _l_e_s_s. For example, +G
          tells _l_e_s_s to start at the end of the file rather than the
          beginning, and +/xyz tells it to start at the first occurence of
          "xyz" in the file.  As a special case, +<number> acts like
          +<number>g; that is, it starts the display at the specified line
          number (however, see the caveat under the "g" command above).  If
          the option starts with ++, the initial command applies to every
          file being viewed, not just the first one.


BUGS
     When used on standard input (rather than a file), you can move
     backwards only a finite amount, corresponding to that portion of the
     file which is still buffered.
