/*	SCAME disptab.c				*/

/*	Revision 1.0.0  1985-02-09		*/

static char *cpyrid = "@(#)Copyright (C) 1985 by Leif Samuelsson";

/*	Command dispatch tables			*/

#include "scame.h"
#include "k_funcs.h"

extern int k_teco();

struct comstruct x_comtab[] = {
	{ "Ada Mode",		x_adamode },
	{ "Auto Fill Mode",	x_autofillmode },
	{ "C Mode",		x_cmode },
	{ "CBREAK Mode",	x_cbreakmode },
	{ "Change Directory",	changedir },
	{ "Check Mail",		x_checkmail },
	{ "Default Mode",	findmode },
	{ "Delete Matching Lines", x_flush_matching_lines },
	{ "Dired",		x_dired },
	{ "Find File",	k_findfile },
	{ "Fundamental Mode",	x_fundamentalmode },
	{ "Insert Character",	x_inschr },
	{ "Insert File",	x_insertfile },
	{ "Kill Buffer",	k_killbuffer },
	{ "Lisp Mode",		x_lispmode },
	{ "List Buffers",	k_listbuffers },
	{ "Load Kbd Macro",	x_loadkbdmac },
	{ "Overwrite Mode",	x_ovwrtmode },
	{ "Pascal Mode",	x_pascalmode },
	{ "Push to Shell",	push },
	{ "Read Mail",		k_readmail },
	{ "Replace String",	x_replace },
	{ "Revert File",	x_revert_file },
	{ "Rot 13 region",	x_rot13_region },
	{ "Save Kbd Macro",	x_savekbdmac },
	{ "Select Buffer",	k_selectbuffer },
	{ "Send Mail",		k_mailbuffer },
	{ "Set Key",		x_set_key },
	{ "Set Variable",	x_setvariable },
	{ "Sort Buffer",	x_sortbuf },
	{ "Stop",		stop },
	{ "Swedish Mode",	x_swedishmode },
	{ "Tabify",		x_tabify },
	{ "Undo",		undo },
	{ "View File",		x_viewfile },
	{ "View Variable",	viewvariable },
	{ "View Working Directory",viewworkingdir },
	{ "Wall Chart",		x_wallchart },
	{ "What Cursor Position",	k_whatcursorpos },
	{ "Write File",	k_writefile },
	{ "Write Region",	writeregion },
	{ "^R Append Next Kill",	k_appendnextkill },
	{ "^R Argument Digit",	k_digit },
	{ "^R Autoargument",	k_metadigit },
	{ "^R Back to Indentation",	k_backtoindent },
	{ "^R Backward Character",	k_backchar },
	{ "^R Backward Delete Character",	k_backdelchar },
	{ "^R Backward Kill Word",	k_backkillword },
	{ "^R Backward Sentence",	k_begse },
	{ "^R Backward Word",	k_backword },
	{ "^R Beginning of Line",	k_begli },
	{ "^R Buffer Not Modified",	k_notmodified },
	{ "^R Copy Region",	k_copyregion },
	{ "^R Count Lines Page",	k_cntlpg },
	{ "^R Count Lines Region",	k_countlregion },
	{ "^R Delete Blank Lines",	k_delblanklines },
	{ "^R Delete Character",	k_delchar },
	{ "^R Delete Horizontal space",	k_delhorizspace },
	{ "^R Delete Indentation",	k_delindent },
	{ "^R Directory Display",	k_listdir },
	{ "^R Dired",		k_dired },
	{ "^R Display Date",	k_dispdate },
	{ "^R Down Real Line",	k_downline },
	{ "^R End Defining Kbd Macro",	k_enddefkbdmac },
	{ "^R End of Line",	k_endli },
	{ "^R Exchange Point and Mark",	k_exchgdotmark },
	{ "^R Execute Kbd Macro",	k_executekbdmac },
	{ "^R Execute Teco Macro",	k_teco },
	{ "^R Exit",		k_exit },
	{ "^R Exit To Shell",	k_exit_to_shell },
	{ "^R Extended Command", k_extended },
	{ "^R Fill Region",	k_fillregion },
	{ "^R Forward Character",	k_forwchar },
	{ "^R Forward Sentence",	k_endse },
	{ "^R Forward Word",	k_forwword },
	{ "^R Goto Beginning",	k_begofbuf },
	{ "^R Goto End",	k_endofbuf },
	{ "^R Grow Window",	k_growwindow },
	{ "^R Help",		k_help },
	{ "^R Incremental Search",	k_isearch },
	{ "^R Indent According to Mode",	k_tab },
	{ "^R Indent New Line",	k_indnewline },
	{ "^R Indent Rigidly",	k_indentregion },
	{ "^R Indent for Comment",	k_comment },
	{ "^R Invoke Inferior Shell",	k_push },
	{ "^R Kill Line",	k_killline },
	{ "^R Kill Region",	k_killregion },
	{ "^R Kill Sentence",	k_killsentence },
	{ "^R Kill Word",	k_killword },
	{ "^R Log Out",	k_logout },
	{ "^R Lowercase Region",	k_lowcaseregion },
	{ "^R Lowercase Word",	k_locasw },
	{ "^R Make ()",	k_makeparens },
	{ "^R Mark Whole Buffer",	k_markbuffer },
	{ "^R Mark Word",	k_markword },
	{ "^R Negative Argument",	k_negarg },
	{ "^R New Line",	k_newline },	/* self insert for formatting character ? */
	{ "^R New Window",	k_newwindow },
	{ "^R Next Screen",	k_nextscreen },
	{ "^R One Window",	k_onewindow },
	{ "^R Open Line",	k_openline },
	{ "^R Other Window",	k_otherwindow },
	{ "^R Prefix Control",	k_c_prefix },
	{ "^R Prefix Control-Meta",	k_c_m_prefix },
	{ "^R Prefix Meta",	k_m_prefix },
	{ "^R Previous Screen",	k_prevscreen },
	{ "^R Query Replace",	k_queryreplace },
	{ "^R Quit",		k_bell },
	{ "^R Quoted Insert",	k_quote },
	{ "^R Reverse Search",	k_risearch },
	{ "^R Save File",	k_savefile },
	{ "^R Scroll Other Window",	k_scrollotherwindow },
	{ "^R Self Insert",	k_insertc },
	{ "^R Set Comment Column",	k_setcommcol },
	{ "^R Set Fill Column",	k_setfcol },
	{ "^R Set Fill Prefix",	k_setfillprefix },
	{ "^R Set/Pop Mark",	k_pushpopmark },
	{ "^R Shell Command",	k_shellcmd },
	{ "^R Start Kbd Macro",	k_startdefkbdmac },
	{ "^R Tab to Tab Stop",	k_instab },
	{ "^R Transpose Characters",	k_transchar },
	{ "^R Transpose Words",	k_trnsword },
	{ "^R Two Windows",	k_twowindows },
	{ "^R Un-kill",		k_yank },
	{ "^R Universal Argument",	k_univarg },
	{ "^R Up Real Line",	k_upline },
	{ "^R Uppercase Initial",	k_capitalizeword },
	{ "^R Uppercase Region",	k_upcaseregion },
	{ "^R Uppercase Word",	k_upcwd },
	{ "^R Visit File",	k_visitfile },
	{ "pwd",		viewworkingdir },
		NIL
		};

funcp disptab[512] = {
/* 000 */	k_void,
/* 001 */	k_void,
/* 002 */	k_void,
/* 003 */	k_void,
/* 004 */	k_void,
/* 005 */	k_void,
/* 006 */	k_void,
/* 007 */	k_void,
/* 010 */	k_void,
/* 011 */	k_void,
/* 012 */	k_void,
/* 013 */	k_void,
/* 014 */	k_void,
/* 015 */	k_void,
/* 016 */	k_void,
/* 017 */	k_void,
/* 020 */	k_void,
/* 021 */	k_void,
/* 022 */	k_void,
/* 023 */	k_void,
/* 024 */	k_void,
/* 025 */	k_void,
/* 026 */	k_void,
/* 027 */	k_void,
/* 030 */	k_void,
/* 031 */	k_void,
/* 032 */	k_void,
/* 033 */	k_void,
/* 034 */	k_void,
/* 035 */	k_void,
/* 036 */	k_void,
/* 037 */	k_void,
/* 040 */	k_insertc,
/* 041 */	k_insertc,
/* 042 */	k_insertc,
/* 043 */	k_insertc,
/* 044 */	k_insertc,
/* 045 */	k_insertc,
/* 046 */	k_insertc,
/* 047 */	k_insertc,
/* 050 */	k_insertc,
/* 051 */	k_insertc,
/* 052 */	k_insertc,
/* 053 */	k_insertc,
/* 054 */	k_insertc,
/* 055 */	k_negarg,
/* 056 */	k_insertc,
/* 057 */	k_insertc,
/* 060 0 */	k_digit,
/* 061 */	k_digit,
/* 062 */	k_digit,
/* 063 */	k_digit,
/* 064 */	k_digit,
/* 065 */	k_digit,
/* 066 */	k_digit,
/* 067 */	k_digit,
/* 070 */	k_digit,
/* 071 9 */	k_digit,
/* 072 */	k_insertc,
/* 073 */	k_insertc,
/* 074 */	k_insertc,
/* 075 */	k_insertc,
/* 076 */	k_insertc,
/* 077 */	k_insertc,
/* 100 */	k_insertc,
/* 101 */	k_insertc,
/* 102 */	k_insertc,
/* 103 */	k_insertc,
/* 104 */	k_insertc,
/* 105 */	k_insertc,
/* 106 */	k_insertc,
/* 107 */	k_insertc,
/* 110 */	k_insertc,
/* 111 */	k_insertc,
/* 112 */	k_insertc,
/* 113 */	k_insertc,
/* 114 */	k_insertc,
/* 115 */	k_insertc,
/* 116 */	k_insertc,
/* 117 */	k_insertc,
/* 120 */	k_insertc,
/* 121 */	k_insertc,
/* 122 */	k_insertc,
/* 123 */	k_insertc,
/* 124 */	k_insertc,
/* 125 */	k_insertc,
/* 126 */	k_insertc,
/* 127 */	k_insertc,
/* 130 */	k_insertc,
/* 131 */	k_insertc,
/* 132 */	k_insertc,
/* 133 */	k_insertc,
/* 134 */	k_insertc,
/* 135 */	k_insertc,
/* 136 */	k_insertc,
/* 137 */	k_insertc,
/* 140 */	k_insertc,
/* 141 */	k_insertc,
/* 142 */	k_insertc,
/* 143 */	k_insertc,
/* 144 */	k_insertc,
/* 145 */	k_insertc,
/* 146 */	k_insertc,
/* 147 */	k_insertc,
/* 150 */	k_insertc,
/* 151 */	k_insertc,
/* 152 */	k_insertc,
/* 153 */	k_insertc,
/* 154 */	k_insertc,
/* 155 */	k_insertc,
/* 156 */	k_insertc,
/* 157 */	k_insertc,
/* 160 */	k_insertc,
/* 161 */	k_insertc,
/* 162 */	k_insertc,
/* 163 */	k_insertc,
/* 164 */	k_insertc,
/* 165 */	k_insertc,
/* 166 */	k_insertc,
/* 167 */	k_insertc,
/* 170 */	k_insertc,
/* 171 */	k_insertc,
/* 172 */	k_insertc,
/* 173 */	k_insertc,
/* 174 */	k_insertc,
/* 175 */	k_insertc,
/* 176 */	k_insertc,
/* 177 DEL */	k_backdelchar,
/* 200 M-^@ */	k_void,
/* 201 */	k_void,
/* 202 */	k_void,
/* 203 */	k_void,
/* 204 */	k_void,
/* 205 */	k_void,
/* 206 */	k_void,
/* 207 */	k_void,
/* 210 */	k_void,
/* 211 */	k_void,
/* 212 */	k_void,
/* 213 */	k_void,
/* 214 */	k_void,
/* 215 */	k_void,
/* 216 */	k_void,
/* 217 */	k_void,
/* 220 */	k_void,
/* 221 */	k_void,
/* 222 */	k_void,
/* 223 */	k_void,
/* 224 */	k_void,
/* 225 */	k_void,
/* 226 */	k_void,
/* 227 */	k_void,
/* 230 */	k_void,
/* 231 */	k_void,
/* 232 */	k_void,
/* 233 */	k_void,
/* 234 */	k_void,
/* 235 */	k_void,
/* 236 */	k_void,
/* 237 M-^_ */	k_void,
/* 240 M-sp */	k_ubk,
/* 241 M-!  */	k_shellcmd,
/* 242 */	k_ubk,
/* 243 */	k_ubk,
/* 244 */	k_ubk,
/* 245 */	k_queryreplace,
/* 246 */	k_ubk,
/* 247 */	k_ubk,
/* 250 */	k_makeparens,
/* 251 */	k_ubk,
/* 252 */	k_ubk,
/* 253 */	k_push,
/* 254 */	k_ubk,
/* 255 */	k_ubk,
/* 256 */	k_ubk,
/* 257 */	k_ubk,
/* 260 M-0 */	k_metadigit,
/* 261 */	k_metadigit,
/* 262 */	k_metadigit,
/* 263 */	k_metadigit,
/* 264 */	k_metadigit,
/* 265 */	k_metadigit,
/* 266 */	k_metadigit,
/* 267 */	k_metadigit,
/* 270 */	k_metadigit,
/* 271 */	k_metadigit,
/* 272 */	k_ubk,
/* 273 */	k_comment,
/* 274 */	k_begofbuf,
/* 275 */	k_countlregion,
/* 276 */	k_endofbuf,
/* 277 */	k_ubk,
/* 300 */	k_markword,
/* 301 */	k_begse,
/* 302 */	k_backword,
/* 303 */	k_capitalizeword,
/* 304 */	k_killword,
/* 305 */	k_endse,
/* 306 */	k_forwword,
/* 307 */	k_fillregion,
/* 310 */	k_ubk,
/* 311 */	k_instab,
/* 312 */	k_ubk,
/* 313 */	k_killsentence,
/* 314 */	k_locasw,
/* 315 */	k_backtoindent,
/* 316 */	k_ubk,
/* 317 */	k_m_o_dispatch,
/* 320 */	k_ubk,
/* 321 */	k_ubk,
/* 322 */	k_ubk,
/* 323 */	k_ubk,
/* 324 M-T */	k_trnsword,
/* 325 M-U */	k_upcwd,
/* 326 M-V */	k_prevscreen,
/* 327 */	k_copyregion,
/* 330 */	k_extended,
/* 331 */	k_ubk,
/* 332 */	k_ubk,
/* 333 */	k_ubk,
/* 334 */	k_delhorizspace,
/* 335 */	k_ubk,
/* 336 */	k_delindent,
/* 337 */	k_ubk,
/* 340 */	k_ubk,
/* 341 */	k_void,
/* 342 */	k_void,
/* 343 */	k_void,
/* 344 */	k_void,
/* 345 */	k_void,
/* 346 */	k_void,
/* 347 */	k_void,
/* 350 */	k_void,
/* 351 */	k_void,
/* 352 */	k_void,
/* 353 */	k_void,
/* 354 */	k_void,
/* 355 */	k_void,
/* 356 */	k_void,
/* 357 */	k_void,
/* 360 */	k_void,
/* 361 */	k_void,
/* 362 */	k_void,
/* 363 */	k_void,
/* 364 */	k_void,
/* 365 */	k_void,
/* 366 */	k_void,
/* 367 */	k_void,
/* 370 */	k_void,
/* 371 */	k_void,
/* 372 M-z  */	k_void,
/* 373 M- */	k_ubk,
/* 374 */	k_ubk,
/* 375 */	k_ubk,
/* 376 M-~   */	k_notmodified,
/* 377 M-DEL */	k_backkillword,
/* 400 C-^@  */	k_void,
/* 401 */	k_void,
/* 402 */	k_void,
/* 403 */	k_void,
/* 404 */	k_void,
/* 405 */	k_void,
/* 406 */	k_void,
/* 407 */	k_void,
/* 410 */	k_void,
/* 411 */	k_void,
/* 412 */	k_void,
/* 413 */	k_void,
/* 414 */	k_void,
/* 415 */	k_void,
/* 416 */	k_void,
/* 417 */	k_void,
/* 420 */	k_void,
/* 421 */	k_void,
/* 422 */	k_void,
/* 423 */	k_void,
/* 424 */	k_void,
/* 425 */	k_void,
/* 426 */	k_void,
/* 427 */	k_void,
/* 430 */	k_void,
/* 431 */	k_void,
/* 432 */	k_void,
/* 433 */	k_void,
/* 434 */	k_void,
/* 435 */	k_void,
/* 436 */	k_void,
/* 437 C-^_ */	k_void,
/* 440 C-sp */	k_ubk,
/* 441 */	k_ubk,
/* 442 */	k_ubk,
/* 443 */	k_ubk,
/* 444 */	k_ubk,
/* 445 */	k_ubk,
/* 446 */	k_ubk,
/* 447 */	k_ubk,
/* 450 */	k_ubk,
/* 451 */	k_ubk,
/* 452 */	k_ubk,
/* 453 */	k_ubk,
/* 454 */	k_ubk,
/* 455 */	k_ubk,
/* 456 */	k_ubk,
/* 457 */	k_ubk,
/* 460 */	k_ubk,
/* 461 */	k_ubk,
/* 462 */	k_ubk,
/* 463 */	k_ubk,
/* 464 */	k_ubk,
/* 465 */	k_ubk,
/* 466 */	k_ubk,
/* 467 */	k_ubk,
/* 470 */	k_ubk,
/* 471 */	k_ubk,
/* 472 */	k_ubk,
/* 473 */	k_ubk,
/* 474 */	k_ubk,
/* 475 */	k_ubk,
/* 476 */	k_ubk,
/* 477 */	k_ubk,
/* 500 */	k_pushpopmark,
/* 501 */	k_begli,
/* 502 */	k_backchar,
/* 503 C-C */	k_exit_to_shell,
/* 504 */	k_delchar,
/* 505 */	k_endli,
/* 506 */	k_forwchar,
/* 507 */	k_bell,
/* 510 */	k_backchar,
/* 511 */	k_tab,
/* 512 */	k_indnewline,
/* 513 */	k_killline,
/* 514 */	k_newwindow,
/* 515 */	k_newline,
/* 516 */	k_downline,
/* 517 */	k_openline,
/* 520 */	k_upline,
/* 521 */	k_quote,
/* 522 */	k_risearch,
/* 523 */	k_isearch,
/* 524 */	k_transchar,
/* 525 */	k_univarg,
/* 526 */	k_nextscreen,
/* 527 */	k_killregion,
/* 530 */	k_c_x_dispatch,
/* 531 */	k_yank,
/* 532 */	k_c_m_prefix,
/* 533 */	k_m_prefix,
/* 534 */	k_m_prefix,
/* 535 */	k_ubk,
/* 536 */	k_c_prefix,
/* 537 C-_  */	k_help,
/* 540 C-`  */	k_ubk,
/* 541 */	k_void,
/* 542 */	k_void,
/* 543 */	k_void,
/* 544 */	k_void,
/* 545 */	k_void,
/* 546 */	k_void,
/* 547 */	k_void,
/* 550 */	k_void,
/* 551 */	k_void,
/* 552 */	k_void,
/* 553 */	k_void,
/* 554 */	k_void,
/* 555 */	k_void,
/* 556 */	k_void,
/* 557 */	k_void,
/* 560 */	k_void,
/* 561 */	k_void,
/* 562 */	k_void,
/* 563 */	k_void,
/* 564 */	k_void,
/* 565 */	k_void,
/* 566 */	k_void,
/* 567 */	k_void,
/* 570 */	k_void,
/* 571 */	k_void,
/* 572 C-z */	k_void,
/* 573 C-*/	k_ubk,
/* 574 */	k_ubk,
/* 575 */	k_ubk,
/* 576 */	k_ubk,
/* 577 C-DEL */	k_ubk,
/* 600 C-M-^@ */k_void,
/* 601 */	k_void,
/* 602 */	k_void,
/* 603 */	k_void,
/* 604 */	k_void,
/* 605 */	k_void,
/* 606 */	k_void,
/* 607 */	k_void,
/* 610 */	k_void,
/* 611 */	k_void,
/* 612 */	k_void,
/* 613 */	k_void,
/* 614 */	k_void,
/* 615 */	k_void,
/* 616 */	k_void,
/* 617 */	k_void,
/* 620 */	k_void,
/* 621 */	k_void,
/* 622 */	k_void,
/* 623 */	k_void,
/* 624 */	k_void,
/* 625 */	k_void,
/* 626 */	k_void,
/* 627 */	k_void,
/* 630 */	k_void,
/* 631 */	k_void,
/* 632 */	k_void,
/* 633 */	k_void,
/* 634 */	k_void,
/* 635 */	k_void,
/* 636 */	k_void,
/* 637 C-M-^_ */k_void,
/* 640 C-M-sp */k_ubk,
/* 641 */	k_ubk,
/* 642 */	k_ubk,
/* 643 */	k_ubk,
/* 644 */	k_ubk,
/* 645 */	k_queryreplace,
/* 646 */	k_ubk,
/* 647 */	k_ubk,
/* 650 */	k_ubk,
/* 651 */	k_ubk,
/* 652 */	k_ubk,
/* 653 */	k_ubk,
/* 654 */	k_ubk,
/* 655 */	k_ubk,
/* 656 */	k_ubk,
/* 657 */	k_ubk,
/* 660 */	k_ubk,
/* 661 */	k_ubk,
/* 662 */	k_ubk,
/* 663 */	k_ubk,
/* 664 */	k_ubk,
/* 665 */	k_ubk,
/* 666 */	k_ubk,
/* 667 */	k_ubk,
/* 670 */	k_ubk,
/* 671 */	k_ubk,
/* 672 */	k_ubk,
/* 673 */	k_ubk,
/* 674 */	k_ubk,
/* 675 */	k_ubk,
/* 676 */	k_ubk,
/* 677 */	k_ubk,
/* 700 */	k_ubk,
/* 701 */	k_ubk,
/* 702 */	k_ubk,
/* 703 */	k_ubk,
/* 704 */	k_ubk,
/* 705 */	k_ubk,
/* 706 */	k_ubk,
/* 707 */	k_ubk,
/* 710 */	k_ubk,
/* 711 */	k_ubk,
/* 712 */	k_ubk,
/* 713 */	k_ubk,
/* 714 */	k_logout,
/* 715 */	k_backtoindent,
/* 716 */	k_ubk,
/* 717 */	k_ubk,
/* 720 */	k_ubk,
/* 721 */	k_ubk,
/* 722 */	k_ubk,
/* 723 */	k_ubk,
/* 724 */	k_dispdate,
/* 725 */	k_ubk,
/* 726 */	k_scrollotherwindow,
/* 727 */	k_appendnextkill,
/* 730 */	k_extended,
/* 731 */	k_ubk,
/* 732 C-M-Z */	k_exit,
/* 733 M-ESC */	k_teco,
/* 734 */	k_ubk,
/* 735 */	k_ubk,
/* 736 */	k_ubk,
/* 737 C-M-_ */	k_ubk,
/* 740 C-M-` */	k_ubk,
/* 741 C-M-a */	k_void,
/* 742 */	k_void,
/* 743 */	k_void,
/* 744 */	k_void,
/* 745 */	k_void,
/* 746 */	k_void,
/* 747 */	k_void,
/* 750 */	k_void,
/* 751 */	k_void,
/* 752 */	k_void,
/* 753 */	k_void,
/* 754 */	k_void,
/* 755 */	k_void,
/* 756 */	k_void,
/* 757 */	k_void,
/* 760 */	k_void,
/* 761 */	k_void,
/* 762 */	k_void,
/* 763 */	k_void,
/* 764 */	k_void,
/* 765 */	k_void,
/* 766 */	k_void,
/* 767 */	k_void,
/* 770 */	k_void,
/* 771 */	k_void,
/* 772 C-M-z */	k_void,
/* 773 C-M-*/	k_ubk,
/* 774 C-M-| */	k_ubk,
/* 775 C-M-} */	k_ubk,
/* 776 C-M-~ */	k_ubk,
/* 777 C-M-DEL*/k_ubk
};




funcp c_x_disptab[128] = {
/* 000 */	k_ubk,
/* 001 */	k_ubk,
/* 002 */	k_listbuffers,
/* 003 */	k_ubk,
/* 004 */	k_listdir,
/* 005 */	k_ubk,
/* 006 */	k_findfile,
/* 007 */	k_bell,
/* 010 */	k_ubk,
/* 011 */	k_indentregion,
/* 012 */	k_ubk,
/* 013 */	k_ubk,
/* 014 */	k_lowcaseregion,
/* 015 */	k_ubk,
/* 016 */	k_ubk,
/* 017 */	k_delblanklines,
/* 020 */	k_ubk,
/* 021 */	k_ubk,
/* 022 */	k_ubk,
/* 023 */	k_savefile,
/* 024 */	k_ubk,
/* 025 */	k_upcaseregion,
/* 026 */	k_visitfile,
/* 027 */	k_writefile,
/* 030 */	k_exchgdotmark,
/* 031 */	k_ubk,
/* 032 C-Z */	k_exit_to_shell,
/* 033 */	k_ubk,
/* 034 */	k_ubk,
/* 035 */	k_ubk,
/* 036 */	k_ubk,
/* 037 */	k_ubk,
/* 040 */	k_ubk,
/* 041 */	k_ubk,
/* 042 */	k_ubk,
/* 043 */	k_ubk,
/* 044 */	k_ubk,
/* 045 */	k_ubk,
/* 046 */	k_ubk,
/* 047 */	k_ubk,
/* 050 */	k_startdefkbdmac,
/* 051 */	k_enddefkbdmac,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/* 056 */	k_setfillprefix,
/*  */	k_ubk,
/*  */	k_ubk,
/* 061 */	k_onewindow,
/* 062 */	k_twowindows,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/* 073 */	k_setcommcol,
/*  */	k_ubk,
/* 074 */	k_whatcursorpos,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/* 102 */	k_selectbuffer,
/*  */	k_ubk,
/* 104 */	k_dired,
/* 105 */	k_executekbdmac,
/* 106 */	k_setfcol,
/*  */	k_ubk,
/* 110 */	k_markbuffer,
/*  */	k_ubk,
/*  */	k_ubk,
/* 113 */	k_killbuffer,
/* 114 */	k_cntlpg,
/* 115 */	k_mailbuffer,
/*  */	k_ubk,
/* 117 */	k_otherwindow,
/*  */	k_ubk,
/*  */	k_ubk,
/* 122 R */	k_readmail,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_exit_to_shell,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/* 136 */	k_growwindow,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk,
/*  */	k_ubk
};


funcp m_o_disptab[128] = {
/* 000 */	k_ubk,
/* 001 */	k_ascii,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 007 */	k_bell,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 023 */	k_sis,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 0 */	k_ubk,
/* 1 */	k_ubk,
/* 101 */	k_upline,
/* 102 */	k_downline,
/* 103 */	k_forwchar,
/* 104 */	k_backchar,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 123 */	k_edt_pf4,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 154 */	k_edt_comma,
/* 155 */	k_edt_dash,
/* 156 */	k_help,
/* 1 */	k_ubk,
/* 160 */	k_edt_0,
/* 1 */	k_ubk,
/* 162 */	k_endli,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 166 */	k_killregion,
/* 1 */	k_ubk,
/* 170 */	k_edt_8,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk,
/* 1 */	k_ubk
};

