/*
 * This is a sample unbatcher.  It is called with the batch file on stdin
 * and creates the unbatched files in the current directory.  Exit status:
 * 2  => wrong batcher invoked.
 * 33 => batch file was truncated.
 * 34 => write error occurred.
 * 1  => illegal batch file.
 */

#include "common.h"
#define UNBAT 1
#include "pack.h"

char unbattmp[] = "../unbatch.tmp" ;

long bits ;		/* current input bits */
int nbits ;		/* number of bits currently in "bits" */
int bversion ;		/* sub-version of batching used */
char line[1025] ;	/* place to unpack verying length characters */
char temp[1024] ;	/* temporary strings */
char saverelay[200] ;	/* old Relay-Version */
char relaysite[64] ;	/* site name from Relay-Version */
char postsite[64] ;	/* site name of posting site */
char artid[16] ;	/* article ID generated by message ID */

#define MOREBITS(n) while(nbits < n) bits |= getc(stdin) << nbits, nbits += BS
#define USEUP(n) bits >>= n, nbits -= n
long gbits() ;


main(argc, argv)
      char **argv ;
      {
      register c ;
      FILE *ufp ;
      int seqno ;
      char hdline[64] ;
      char fname[FNLEN] ;

      seqno = getpid() % 9000 ;
      if ((c = getc(stdin)) == EOF) {
            printf("empty batch file\n") ;
            exit(2) ;
      }
      if (c != 'b') {
            printf("bad version\n") ;
            exit(2) ;
      }
      bversion = gbits(4) ;
      if (gbits(20) != fsize(fileno(stdin))) {
            printf("bad size\n") ;
            exit(33) ;
      }
      if ((BVERSION - bversion & 017) > 1)
            die(2, "bad sub-version") ;
      while ((c = ftypes[gbits(LFTYPE)]) != '\0') {
            sprintf(fname, "%c%04d", c, seqno++) ;
            if ((ufp = fopen(unbattmp, "w")) == NULL) {
                  die(34, "can't create unbatch.tmp") ;
            }
            getfile(c, ufp) ;
            if (fclose(ufp) == EOF) {
                  printf("close error on unbatch.tmp\n") ;
                  exit(34) ;
            }
            if (link(unbattmp, fname) < 0) {
                  printf("link to %s failed\n", fname) ;
                  exit(34) ;
            }
            if (unlink(unbattmp) < 0) {
                  unlink(fname) ;
                  printf("can't unlink unbatch.tmp\n") ;
                  exit(34) ;
            }
      }
      exit(0) ;
}


getfile(type, ufp)
      FILE *ufp ;
      {
      if (type == 'n')
            newshead(ufp) ;
      readfile(ufp) ;
}


newshead(ufp)
      FILE *ufp ;
      {
      int ltype ;
      char *p, *q ;

      if (gbits(1)) {
            fputs(saverelay, ufp) ;
            printf("Old relay used\n") ;	/*DEBUG*/
      }
      else  printf("Old relay not used\n") ;	/*DEBUG*/
      postsite[0] = '\0' ;
      exchg('\n', EOFMARK|0200) ;
      for (;;) {
            switch (ltype = gbits(5)) {
            case NHRELAY:
            case NHVERSION:
                  readfile(NULL) ;
                  if ((p = index(line, ';')) == NULL)
                        die(1, "bad Version line") ;
                  *p++ = '\0' ;
                  sprintf(temp, "%s%s; site %s\n", hprefix[ltype], line, p) ;
                  fputs(temp, ufp) ;
                  if (ltype == NHRELAY) {
                        strcpy(saverelay, temp) ;
                        strcpy(relaysite, p) ;
                  } else {
                        strcpy(postsite, p) ;
                  }
                  break ;
            case NHMESSAGEID:
                  readfile(NULL) ;
                  if (index(line, '@') == NULL) {
			printf("Messageid taken from postsite\n") ;   /*DEBUG*/
                        strcat(line, "@") ;
                        strcat(line, postsite) ;
                  }
                  genartid(line) ;
                  strcat(line, ">") ;
                  goto outline ;
            case NHARTICLEID:
                  if (artid[0])
                        strcpy(line, artid) ;
                  else
                        readfile(NULL) ;
                  goto outline ;
            default:
                  readfile(NULL) ;
            outline:
                  fputs(hprefix[ltype], ufp) ;
                  fputs(line, ufp) ;
                  putc('\n', ufp) ;
                  break ;
            case NHSEP:
                  putc('\n', ufp) ;
                  goto out ;
            case NHEND:
                  goto out ;
            }
      }
out:  exchg('\n', EOFMARK|0200) ;
}


genartid(msgid)
      char *msgid ;
      {
      register char *p, *q ;

      strcpy(temp, line);
      p = index(temp, '@');
      *p++ = '\0';
      q = index(p, '.');
      if (q)
            *q++ = '\0';
      p[8] = '\0';
      sprintf(artid, "%s.%s", p, temp);
}


readfile(ufp)
      FILE *ufp ;
      {
      register char *lp ;
      register struct decode *dp ;

      lp = line ;
      for (;;) {
            MOREBITS(16) ;
            dp = &dtab[bits & 01777] ;
            USEUP(dp->clen) ;
            if ((dp->cval & 0200) == 0) {
                  if (lp >= line + 1024) {
                        if (ufp == NULL)
                              die(1, "header line too long") ;
                        if (fwrite(line, 1, 1024, ufp) != 1024)
                              die(33, "write error") ;
                        lp = line ;
                  }
                  *lp++ = dp->cval ;
                  continue ;
            }
            if (lp >= line + 1024) {
                  if (ufp == NULL)
                        die(1, "header line too long") ;
                  if (fwrite(line, 1, 1024, ufp) != 1024)
                        die(33, "write error") ;
                  lp = line ;
            }
            switch (dp->cval & 0177) {
            case EOFMARK:
                  goto out ;
            case EXTCHAR:
                  *lp++ = extchar[bits & 037] ;
                  USEUP(5) ;
                  break ;
            }
      }
out:
      if (ufp) {
            if (lp > line && fwrite(line, 1, lp - line, ufp) != lp - line)
                  die(33, "write error") ;
      } else
            *lp = '\0' ;
}


long
gbits(n) {
      register long ret ;

      MOREBITS(n) ;
      ret = bits &~ (-1 << n) ;
      USEUP(n) ;
      printf("gbits(%d) => %ld\n", n, ret) ;	/*DEBUG*/
      return ret ;
}


exchg(c1, c2)
      char c1, c2 ;
      {
      register struct decode *dp ;

      for (dp = dtab ; dp < &dtab[1024] ; dp++) {
            if (dp->cval == c1)
                  dp->cval = c2 ;
            else if (dp->cval == c2)
                  dp->cval = c1 ;
      }
}



die(status, msg)
      char *msg ;
      {
      printf("%s\n", msg) ;
      exit(status) ;
}


fsize(fd) {
      struct stat st ;

      if (fstat(fd, &st) < 0)
            return 0L ;
      return st.st_size ;
}
