/*
 * tree_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `tree.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include <group.h>
#include "tree_ui.h"

/*
 * Initialize an instance of object `window'.
 */
tree_window_objects *
tree_window_objects_initialize(ip, owner)
	tree_window_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (tree_window_objects *) calloc(1, sizeof (tree_window_objects))))
		return (tree_window_objects *) NULL;
	if (!ip->window)
		ip->window = tree_window_window_create(ip, owner);
	if (!ip->controls)
		ip->controls = tree_window_controls_create(ip, ip->window);
	if (!ip->draw)
		ip->draw = tree_window_draw_create(ip, ip->controls);
	if (!ip->properties)
		ip->properties = tree_window_properties_create(ip, ip->controls);
	if (!ip->group11)
		ip->group11 = tree_window_group11_create(ip, ip->controls);
	window_fit(ip->controls);
	
	if (!ip->canvas)
		ip->canvas = tree_window_canvas_create(ip, ip->window);
	window_fit(ip->window);
	
	xv_set(ip->controls, XV_WIDTH, WIN_EXTEND_TO_EDGE, NULL);
	xv_set(ip->canvas,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		NULL);
	return ip;
}

/*
 * Create object `window' in the specified instance.
 */
Xv_opaque
tree_window_window_create(ip, owner)
	tree_window_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 465,
		XV_HEIGHT, 449,
		XV_LABEL, "Fractal Tree",
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `controls' in the specified instance.
 */
Xv_opaque
tree_window_controls_create(ip, owner)
	tree_window_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 41,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `draw' in the specified instance.
 */
Xv_opaque
tree_window_draw_create(ip, owner)
	tree_window_objects	*ip;
	Xv_opaque	owner;
{
	extern void		draw();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 10,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Draw",
		PANEL_NOTIFY_PROC, draw,
		NULL);
	return obj;
}

/*
 * Create object `properties' in the specified instance.
 */
Xv_opaque
tree_window_properties_create(ip, owner)
	tree_window_objects	*ip;
	Xv_opaque	owner;
{
	extern void		tree_window_properties_notify_callback();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 70,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Properties...",
		PANEL_NOTIFY_PROC, tree_window_properties_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `group11' in the specified instance.
 */
Xv_opaque
tree_window_group11_create(ip, owner)
	tree_window_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, GROUP,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 10,
		XV_Y, 10,
		GROUP_TYPE, GROUP_ROW,
		GROUP_MEMBERS,
			ip->draw,
			ip->properties,
			NULL,
		GROUP_ROW_ALIGNMENT, GROUP_HORIZONTAL_CENTERS,
		GROUP_HORIZONTAL_SPACING, 10,
		NULL);
	return obj;
}

/*
 * Create object `canvas' in the specified instance.
 */
Xv_opaque
tree_window_canvas_create(ip, owner)
	tree_window_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, CANVAS,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, (int)xv_get(ip->controls, XV_Y) +
		      (int)xv_get(ip->controls, XV_HEIGHT),
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		NULL);
	/*
	 * This line is here for backwards compatibility. It will be
	 * removed for the next release.
	 */
	xv_set(canvas_paint_window(obj), XV_KEY_DATA, INSTANCE, ip, NULL);
	return obj;
}

/*
 * Initialize an instance of object `props'.
 */
tree_props_objects *
tree_props_objects_initialize(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (tree_props_objects *) calloc(1, sizeof (tree_props_objects))))
		return (tree_props_objects *) NULL;
	if (!ip->props)
		ip->props = tree_props_props_create(ip, owner);
	if (!ip->controls)
		ip->controls = tree_props_controls_create(ip, ip->props);
	if (!ip->dir)
		ip->dir = tree_props_dir_create(ip, ip->controls);
	if (!ip->dir_up_msg)
		ip->dir_up_msg = tree_props_dir_up_msg_create(ip, ip->controls);
	if (!ip->group)
		ip->group = tree_props_group_create(ip, ip->controls);
	if (!ip->dir_left)
		ip->dir_left = tree_props_dir_left_create(ip, ip->controls);
	if (!ip->dir_left_msg)
		ip->dir_left_msg = tree_props_dir_left_msg_create(ip, ip->controls);
	if (!ip->group1)
		ip->group1 = tree_props_group1_create(ip, ip->controls);
	if (!ip->dir_right)
		ip->dir_right = tree_props_dir_right_create(ip, ip->controls);
	if (!ip->dir_right_msg)
		ip->dir_right_msg = tree_props_dir_right_msg_create(ip, ip->controls);
	if (!ip->group3)
		ip->group3 = tree_props_group3_create(ip, ip->controls);
	if (!ip->group4)
		ip->group4 = tree_props_group4_create(ip, ip->controls);
	if (!ip->growth_left)
		ip->growth_left = tree_props_growth_left_create(ip, ip->controls);
	if (!ip->grow_left_msg)
		ip->grow_left_msg = tree_props_grow_left_msg_create(ip, ip->controls);
	if (!ip->group5)
		ip->group5 = tree_props_group5_create(ip, ip->controls);
	if (!ip->growth_right)
		ip->growth_right = tree_props_growth_right_create(ip, ip->controls);
	if (!ip->grow_right_msg)
		ip->grow_right_msg = tree_props_grow_right_msg_create(ip, ip->controls);
	if (!ip->group6)
		ip->group6 = tree_props_group6_create(ip, ip->controls);
	if (!ip->group7)
		ip->group7 = tree_props_group7_create(ip, ip->controls);
	if (!ip->bark_color)
		ip->bark_color = tree_props_bark_color_create(ip, ip->controls);
	if (!ip->leaf_color)
		ip->leaf_color = tree_props_leaf_color_create(ip, ip->controls);
	if (!ip->group8)
		ip->group8 = tree_props_group8_create(ip, ip->controls);
	if (!ip->leaf_size)
		ip->leaf_size = tree_props_leaf_size_create(ip, ip->controls);
	if (!ip->clear)
		ip->clear = tree_props_clear_create(ip, ip->controls);
	if (!ip->group9)
		ip->group9 = tree_props_group9_create(ip, ip->controls);
	if (!ip->apply)
		ip->apply = tree_props_apply_create(ip, ip->controls);
	if (!ip->defaults)
		ip->defaults = tree_props_defaults_create(ip, ip->controls);
	if (!ip->group2)
		ip->group2 = tree_props_group2_create(ip, ip->controls);
	if (!ip->group10)
		ip->group10 = tree_props_group10_create(ip, ip->controls);
	window_fit(ip->controls);
	
	window_fit(ip->props);
	
	xv_set(ip->controls,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		NULL);
	return ip;
}

/*
 * Create object `props' in the specified instance.
 */
Xv_opaque
tree_props_props_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 344,
		XV_HEIGHT, 310,
		XV_LABEL, "Fractal Tree: Properties",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `controls' in the specified instance.
 */
Xv_opaque
tree_props_controls_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `dir' in the specified instance.
 */
Xv_opaque
tree_props_dir_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 14,
		XV_Y, 8,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_TICKS, 0,
		PANEL_LABEL_STRING, "Direction Up:",
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, FALSE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 10,
		PANEL_MAX_VALUE, 170,
		PANEL_VALUE, 90,
		NULL);
	return obj;
}

/*
 * Create object `dir_up_msg' in the specified instance.
 */
Xv_opaque
tree_props_dir_up_msg_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 279,
		XV_Y, 8,
		PANEL_LABEL_STRING, "degrees",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `group' in the specified instance.
 */
Xv_opaque
tree_props_group_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, GROUP,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 14,
		XV_Y, 8,
		GROUP_TYPE, GROUP_ROW,
		GROUP_MEMBERS,
			ip->dir,
			ip->dir_up_msg,
			NULL,
		GROUP_ROW_ALIGNMENT, GROUP_TOP_EDGES,
		GROUP_HORIZONTAL_SPACING, 10,
		NULL);
	return obj;
}

/*
 * Create object `dir_left' in the specified instance.
 */
Xv_opaque
tree_props_dir_left_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 73,
		XV_Y, 34,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_TICKS, 0,
		PANEL_LABEL_STRING, "Left:",
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, FALSE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 5,
		PANEL_MAX_VALUE, 50,
		PANEL_VALUE, 15,
		NULL);
	return obj;
}

/*
 * Create object `dir_left_msg' in the specified instance.
 */
Xv_opaque
tree_props_dir_left_msg_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 279,
		XV_Y, 34,
		PANEL_LABEL_STRING, "degrees",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `group1' in the specified instance.
 */
Xv_opaque
tree_props_group1_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, GROUP,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 73,
		XV_Y, 34,
		GROUP_TYPE, GROUP_ROW,
		GROUP_MEMBERS,
			ip->dir_left,
			ip->dir_left_msg,
			NULL,
		GROUP_ROW_ALIGNMENT, GROUP_TOP_EDGES,
		GROUP_HORIZONTAL_SPACING, 10,
		NULL);
	return obj;
}

/*
 * Create object `dir_right' in the specified instance.
 */
Xv_opaque
tree_props_dir_right_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 64,
		XV_Y, 60,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_TICKS, 0,
		PANEL_LABEL_STRING, "Right:",
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, FALSE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 5,
		PANEL_MAX_VALUE, 50,
		PANEL_VALUE, 15,
		NULL);
	return obj;
}

/*
 * Create object `dir_right_msg' in the specified instance.
 */
Xv_opaque
tree_props_dir_right_msg_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 279,
		XV_Y, 60,
		PANEL_LABEL_STRING, "degrees",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `group3' in the specified instance.
 */
Xv_opaque
tree_props_group3_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, GROUP,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 64,
		XV_Y, 60,
		GROUP_TYPE, GROUP_ROW,
		GROUP_MEMBERS,
			ip->dir_right,
			ip->dir_right_msg,
			NULL,
		GROUP_ROW_ALIGNMENT, GROUP_TOP_EDGES,
		GROUP_HORIZONTAL_SPACING, 10,
		NULL);
	return obj;
}

/*
 * Create object `group4' in the specified instance.
 */
Xv_opaque
tree_props_group4_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, GROUP,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 14,
		XV_Y, 8,
		GROUP_TYPE, GROUP_COLUMN,
		GROUP_MEMBERS,
			ip->group,
			ip->group1,
			ip->group3,
			NULL,
		GROUP_COLUMN_ALIGNMENT, GROUP_LABELS,
		GROUP_VERTICAL_SPACING, 6,
		NULL);
	return obj;
}

/*
 * Create object `growth_left' in the specified instance.
 */
Xv_opaque
tree_props_growth_left_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 21,
		XV_Y, 94,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_TICKS, 0,
		PANEL_LABEL_STRING, "Growth Left:",
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, FALSE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 50,
		PANEL_MAX_VALUE, 85,
		PANEL_VALUE, 70,
		NULL);
	return obj;
}

/*
 * Create object `grow_left_msg' in the specified instance.
 */
Xv_opaque
tree_props_grow_left_msg_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 279,
		XV_Y, 94,
		PANEL_LABEL_STRING, "percent",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `group5' in the specified instance.
 */
Xv_opaque
tree_props_group5_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, GROUP,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 21,
		XV_Y, 94,
		GROUP_TYPE, GROUP_ROW,
		GROUP_MEMBERS,
			ip->growth_left,
			ip->grow_left_msg,
			NULL,
		GROUP_ROW_ALIGNMENT, GROUP_TOP_EDGES,
		GROUP_HORIZONTAL_SPACING, 10,
		NULL);
	return obj;
}

/*
 * Create object `growth_right' in the specified instance.
 */
Xv_opaque
tree_props_growth_right_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 64,
		XV_Y, 120,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_TICKS, 0,
		PANEL_LABEL_STRING, "Right:",
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, FALSE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 50,
		PANEL_MAX_VALUE, 85,
		PANEL_VALUE, 70,
		NULL);
	return obj;
}

/*
 * Create object `grow_right_msg' in the specified instance.
 */
Xv_opaque
tree_props_grow_right_msg_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 279,
		XV_Y, 120,
		PANEL_LABEL_STRING, "percent",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `group6' in the specified instance.
 */
Xv_opaque
tree_props_group6_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, GROUP,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 64,
		XV_Y, 120,
		GROUP_TYPE, GROUP_ROW,
		GROUP_MEMBERS,
			ip->growth_right,
			ip->grow_right_msg,
			NULL,
		GROUP_ROW_ALIGNMENT, GROUP_TOP_EDGES,
		GROUP_HORIZONTAL_SPACING, 10,
		NULL);
	return obj;
}

/*
 * Create object `group7' in the specified instance.
 */
Xv_opaque
tree_props_group7_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, GROUP,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 21,
		XV_Y, 94,
		GROUP_TYPE, GROUP_COLUMN,
		GROUP_MEMBERS,
			ip->group5,
			ip->group6,
			NULL,
		GROUP_COLUMN_ALIGNMENT, GROUP_LABELS,
		GROUP_VERTICAL_SPACING, 6,
		NULL);
	return obj;
}

/*
 * Create object `bark_color' in the specified instance.
 */
Xv_opaque
tree_props_bark_color_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 29,
		XV_Y, 154,
		PANEL_VALUE_DISPLAY_LENGTH, 25,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Bark Color:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE, "Brown",
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `leaf_color' in the specified instance.
 */
Xv_opaque
tree_props_leaf_color_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 30,
		XV_Y, 179,
		PANEL_VALUE_DISPLAY_LENGTH, 25,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Leaf Color:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE, "Forest Green",
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `group8' in the specified instance.
 */
Xv_opaque
tree_props_group8_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, GROUP,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 29,
		XV_Y, 154,
		GROUP_TYPE, GROUP_COLUMN,
		GROUP_MEMBERS,
			ip->bark_color,
			ip->leaf_color,
			NULL,
		GROUP_COLUMN_ALIGNMENT, GROUP_LABELS,
		GROUP_VERTICAL_SPACING, 10,
		NULL);
	return obj;
}

/*
 * Create object `leaf_size' in the specified instance.
 */
Xv_opaque
tree_props_leaf_size_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 1,
		XV_Y, 208,
		PANEL_VALUE_DISPLAY_LENGTH, 4,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Length of Leaf:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 25,
		PANEL_MIN_VALUE, 2,
		PANEL_VALUE, 5,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `clear' in the specified instance.
 */
Xv_opaque
tree_props_clear_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TOGGLE, PANEL_FEEDBACK, PANEL_MARKED,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 3,
		XV_Y, 237,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LABEL_STRING, "Clear Drawing:",
		PANEL_CHOICE_STRING, 0, "",
		PANEL_VALUE, 1,
		NULL);
	return obj;
}

/*
 * Create object `group9' in the specified instance.
 */
Xv_opaque
tree_props_group9_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, GROUP,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 1,
		XV_Y, 8,
		GROUP_TYPE, GROUP_COLUMN,
		GROUP_MEMBERS,
			ip->group4,
			ip->group7,
			ip->group8,
			ip->leaf_size,
			ip->clear,
			NULL,
		GROUP_COLUMN_ALIGNMENT, GROUP_LABELS,
		GROUP_VERTICAL_SPACING, 14,
		NULL);
	return obj;
}

/*
 * Create object `apply' in the specified instance.
 */
Xv_opaque
tree_props_apply_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	extern void		apply_properties();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 97,
		XV_Y, 280,
		PANEL_LABEL_STRING, "Apply",
		PANEL_NOTIFY_PROC, apply_properties,
		NULL);
	return obj;
}

/*
 * Create object `defaults' in the specified instance.
 */
Xv_opaque
tree_props_defaults_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	extern void		factory_defaults();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 160,
		XV_Y, 280,
		PANEL_LABEL_STRING, "Defaults",
		PANEL_NOTIFY_PROC, factory_defaults,
		NULL);
	return obj;
}

/*
 * Create object `group2' in the specified instance.
 */
Xv_opaque
tree_props_group2_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, GROUP,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 97,
		XV_Y, 280,
		GROUP_TYPE, GROUP_ROW,
		GROUP_MEMBERS,
			ip->apply,
			ip->defaults,
			NULL,
		GROUP_ROW_ALIGNMENT, GROUP_TOP_EDGES,
		GROUP_HORIZONTAL_SPACING, 10,
		NULL);
	return obj;
}

/*
 * Create object `group10' in the specified instance.
 */
Xv_opaque
tree_props_group10_create(ip, owner)
	tree_props_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, GROUP,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 1,
		XV_Y, 8,
		GROUP_TYPE, GROUP_COLUMN,
		GROUP_MEMBERS,
			ip->group9,
			ip->group2,
			NULL,
		GROUP_COLUMN_ALIGNMENT, GROUP_VERTICAL_CENTERS,
		GROUP_VERTICAL_SPACING, 20,
		NULL);
	return obj;
}

