/*
 * timer_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `timer.G'.
 * and has since been hand edited. Gxv (release 3) merges changes
 * when rewriting this file.
 *
 * $Id: timer_stubs.c,v 1.15 92/06/24 12:04:38 ian Exp $
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include "timer_ui.h"
#include "timekeeper.h"
#include <group.h>

void		addTopic();
void		delTopic();

/*
 * Global object definitions.
 */
timer_baseFrame_objects	*Timer_baseFrame;

#ifdef MAIN

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute	INSTANCE;

char *progname;
char *curTopic = NULL;
void shutdown();
static Server_image normal_image, nobilling_image;
static Icon frame_icon;
static unsigned short	normal_bits[] = {
#include "punchclock.icon"
	}, nobilling_bits[] = {
#include "nobilling.icon"
	};

main(argc, argv)
	int	argc;
	char	**argv;
{
	
	progname = *argv;

	/*
	 * Initialize XView.
	 */
	xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);
	INSTANCE = xv_unique_key();

	/*
	 * Initialize user interface components.
	 * Do NOT edit the object initializations by hand.
	 */
	Timer_baseFrame = timer_baseFrame_objects_initialize(NULL, NULL);
	
	/*
	 * Icon stuff: make up two server images, stuff one into
	 * the "frame_icon" (will switch them around later), then
	 * connect the icon onto the baseFrame.
	 */
	normal_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, normal_bits,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		NULL);
	
	nobilling_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, nobilling_bits,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		NULL);

	frame_icon = xv_create(XV_NULL, ICON,
		ICON_IMAGE, nobilling_image,
		XV_NULL);

	xv_set(Timer_baseFrame->baseFrame,
		FRAME_LEFT_FOOTER, NOTOPICMSG,
		FRAME_ICON, frame_icon,
		XV_NULL);

	readTopics();
#ifdef	SNOOPY
	writeLog("Start", "RECORDING");
#endif

	signal(SIGTERM, shutdown);	/* always catch */
	if (signal(SIGINT, shutdown) == SIG_IGN)	/* catch correctly */
		signal(SIGINT, SIG_IGN);
	
	/*
	 * Turn control over to XView.
	 */
	xv_main_loop(Timer_baseFrame->baseFrame);

	writeLog("End", "RECORDING");
	exit(0);
}

void
shutdown(i)
int i;
{
	char buf[128];

	sprintf(buf, "Caught signal %d", i);
	writeLog(buf, "");
	writeLog("End", "RECORDING");
	exit(1);
}


void
settopic(s)
char *s;
{
	writeLog("Start", s);
	xv_set(frame_icon,
		ICON_LABEL, s,
		ICON_IMAGE, normal_image,
		XV_NULL);
	xv_set(Timer_baseFrame->baseFrame,
		FRAME_LEFT_FOOTER, s,
#ifndef		NO_AUTO_CLOSE
		FRAME_CLOSED,	TRUE,
#endif
		XV_NULL);
	curTopic = s;
}

#endif


/*
 * Notify callback function for `startButton'.
 */
void
startTopic(item, event)
	Panel_item	item;
	Event		*event;
{
	timer_baseFrame_objects *ip = (timer_baseFrame_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	int inewTopic;
	char *getTopic(/*int i*/), *newTopic;
	
	inewTopic = xv_get(Timer_baseFrame->topicList,
		PANEL_LIST_FIRST_SELECTED);

	settopic(newTopic = getTopic(inewTopic));

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `stopButton'.
 */
void
stopTopic(item, event)
	Panel_item	item;
	Event		*event;
{
	int newtopic;
	timer_baseFrame_objects *ip = (timer_baseFrame_objects *)
		xv_get(item, XV_KEY_DATA, INSTANCE);

	newtopic = xv_get(ip->topicList,
		PANEL_LIST_FIRST_SELECTED);
	if (newtopic)
		writeLog("End", getTopic(newtopic));
	else if (curTopic)
		writeLog("End", curTopic);
	xv_set(frame_icon,
		ICON_LABEL, "",
		ICON_IMAGE, nobilling_image,
		XV_NULL);
	xv_set(ip->baseFrame,
		FRAME_LEFT_FOOTER, NOTOPICMSG,
		XV_NULL);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `addButton'.
 */
void
timer_baseFrame_addButton_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
	timer_baseFrame_objects *ip = (timer_baseFrame_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	addTopic(item, event);
	
	/* gxv_end_connections */

}

/*
 * User-defined action for `addButton'.
 */
void
addTopic(item, event)
	Panel_item	item;
	Event		*event;
{
	timer_baseFrame_objects *ip = (timer_baseFrame_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char *newtopic;

	newtopic = (char*)xv_get(ip->newTextfield, PANEL_VALUE);
	if (newtopic) {
		insertTopic(newtopic);
		writeTopics();
	}
}

/*
 * Notify callback function for `deleteButton'.
 */
void
timer_baseFrame_deleteButton_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
	timer_baseFrame_objects *ip = (timer_baseFrame_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	delTopic(item, event);
	
	/* gxv_end_connections */

}

/*
 * User-defined action for `deleteButton'.
 */
void
delTopic(item, event)
	Panel_item	item;
	Event		*event;
{
	fputs("timer: delTopic not written yet.\n", stderr);
}

/*
 * Notify callback function for `rereadButton'.
 */
void
rereadTopics(item, event)
	Panel_item	item;
	Event		*event;
{
	timer_baseFrame_objects *ip = (timer_baseFrame_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	readTopics();
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `topicList'.
 */
int
timer_baseFrame_topicList_notify_callback(item, string, client_data, op, event, row)
	Panel_item	item;
	char		*string;
	Xv_opaque	client_data;
	Panel_list_op	op;
	Event		*event;
	int		row;
{
	timer_baseFrame_objects *ip = (timer_baseFrame_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	static int selectcount = 0;
	
	switch(op) {
	case PANEL_LIST_OP_DESELECT:
		if (selectcount == 1) {
			settopic(string);
			selectcount = 0;
		}
		break;

	case PANEL_LIST_OP_SELECT:
		selectcount = 1;
		break;
	
	case PANEL_LIST_OP_VALIDATE:
		fprintf(stderr, "timer: timer_baseFrame_topicList_notify_callback: PANEL_LIST_OP_VALIDATE: %s\n",string);
		break;

	case PANEL_LIST_OP_DELETE:
		fprintf(stderr, "timer: timer_baseFrame_topicList_notify_callback: PANEL_LIST_OP_DELETE: %s\n",string);
		break;
	}
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	xv_set(Timer_baseFrame->topicList, XV_SHOW, TRUE, NULL);
	
	/* gxv_end_connections */

	return XV_OK;
}
